/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.eai.adapter.tcp.TCPException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPSocket {
    private static final Log log = LogFactory.getLog((Class)TCPSocket.class);
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int maxbytes = 2048;
    private InputStream in = null;
    private OutputStream out = null;
    private Socket socket;
    private byte[] recvbuff;
    private int current_offset = 0;
    private int current_length = 0;

    public TCPSocket(String address, int port, int timeout, int maxbytes) {
        this.address = address;
        this.commport = port;
        this.timeout = timeout;
        this.maxbytes = maxbytes;
        this.recvbuff = new byte[maxbytes];
    }

    public void connect() throws TCPException {
        try {
            this.socket = new Socket(this.address, this.commport);
            this.socket.setSoTimeout(this.timeout);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5efa\u7acb\u901a\u8bafsocket\u5bf9\u8c61,\u8bbe\u7f6e\u901a\u8baf\u63a5\u6536\u8d85\u65f6\u65f6\u95f4");
            }
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SocketException is emerged.");
            }
            throw new TCPException("socket_connect_exception", e);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IOException is emerged.");
            }
            throw new TCPException("socket_connect_ioexception", e);
        }
    }

    public void close() throws TCPException {
        try {
            this.in.close();
            this.out.close();
            this.socket.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5173\u95edsocket");
            }
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SocketException is emerged.");
            }
            throw new TCPException("socket_close_exception", e);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IOException is emerged.");
            }
            throw new TCPException("socket_close_exception", e);
        }
    }

    public int send(byte[] buff, int buff_off, int buff_len) throws TCPException {
        int cur_offset = buff_off;
        boolean retry_time = true;
        int len = buff_len;
        try {
            if (len <= this.maxbytes) {
                this.out.write(buff, cur_offset, len);
            } else {
                this.out.write(buff, cur_offset, this.maxbytes);
                len -= this.maxbytes;
                cur_offset += this.maxbytes;
            }
            this.out.flush();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u53d1\u9001\u6570\u636e\u5931\u8d25");
                log.debug((Object)("\u6570\u636e\u957f\u5ea6:" + buff_len));
                log.debug((Object)("\u6570\u636e:" + buff));
            }
            throw new TCPException("send_date_error", e);
        }
        return buff_len;
    }

    public int send(byte[] buff) throws TCPException {
        return this.send(buff, 0, buff.length);
    }

    public int recv(byte[] buff, int buff_off, int buff_len) throws TCPException {
        if (buff == null || buff_off < 0 || buff_len <= 0 || buff_off + buff_len > buff.length) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        if (this.current_length < buff_len) {
            if (this.current_length > 0) {
                byte[] tmp = new byte[this.current_length];
                System.arraycopy(this.recvbuff, this.current_offset, tmp, 0, this.current_length);
                System.arraycopy(tmp, 0, this.recvbuff, 0, this.current_length);
            }
            this.current_offset = 0;
            try {
                int tmp_length = this.in.read(this.recvbuff, this.current_length, this.maxbytes - this.current_length);
                this.current_length += tmp_length;
                if (this.current_length < buff_len) {
                    throw new TCPException("recieve_data_error");
                }
            }
            catch (IOException e) {
                throw new TCPException("recieve_data_error", e);
            }
        }
        System.arraycopy(this.recvbuff, this.current_offset, buff, buff_off, buff_len);
        this.current_length -= buff_len;
        this.current_offset += buff_len;
        return buff_len;
    }

    public int recv(byte[] buff) throws TCPException {
        int len_all = buff.length;
        int offset = 0;
        int len_read = 0;
        while (len_all - len_read > 0) {
            try {
                len_read += this.in.read(buff, offset, len_all - len_read);
            }
            catch (IOException e) {
                throw new TCPException("recieve_data_error", e);
            }
            offset = len_read;
        }
        return len_all;
    }

    public byte[] recv() throws TCPException {
        byte[] tmp = new byte[this.maxbytes];
        try {
            int length = this.in.read(tmp);
            byte[] received = new byte[length];
            System.arraycopy(tmp, 0, received, 0, length);
            return received;
        }
        catch (IOException e) {
            throw new TCPException("recieve_data_error", e);
        }
    }
}

