/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.eai.adapter.Connector;
import com.dc.eai.adapter.tcp.StandardTCPException;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.dispatch.Dispatch;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardTCPConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)StandardTCPConnector.class);
    private AdapterConfig config;
    private int port;
    private int mode = 0;
    private int maxbytes = 0;
    private String dispatcher;
    private ServerSocket server;
    private Socket client;

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public StandardTCPConnector(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        this.port = NumberUtils.intValue(config.getAttribute("commport"));
        this.mode = NumberUtils.intValue(config.getAttribute("mode"));
        this.maxbytes = NumberUtils.intValue(config.getAttribute("maxbytes"));
        this.dispatcher = config.getAttribute("dispatcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadConfig(this.config);
        try {
            try {
                this.server = new ServerSocket(this.port);
                while (true) {
                    this.client = this.server.accept();
                    Thread trd = new Thread(new Handler(this.client));
                    trd.start();
                }
            }
            catch (IOException e) {
                try {
                    this.server.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                try {
                    this.server.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    class Handler
    implements Runnable {
        private Socket connection;

        private Handler(Socket connection) {
            this.connection = connection;
        }

        public void run() {
            block14: {
                try {
                    int read;
                    InputStream is = this.connection.getInputStream();
                    OutputStream os = this.connection.getOutputStream();
                    byte[] buff_len = new byte[4];
                    is.read(buff_len);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u957f\u5ea6\u57df\u56db\u4e2a\u5b57\u8282\u4e3a[" + StringUtils.bytesToString(buff_len) + "]"));
                    }
                    int[] lens = new int[4];
                    for (int i = 0; i < buff_len.length; ++i) {
                        lens[i] = buff_len[i] & 0xFF;
                    }
                    int len = (lens[0] << 24) + (lens[1] << 16) + (lens[2] << 8) + lens[3];
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u6d88\u606f\u957f\u5ea6\u4e3a[" + len + "]"));
                    }
                    byte[] buff = new byte[len];
                    for (int remained = len; remained != 0; remained -= read) {
                        read = is.read(buff, len - remained, remained);
                        if (read != -1 || remained == 0) continue;
                        throw new IllegalStateException("\u6d88\u606f\u957f\u5ea6\u5c0f\u4e8ebuff[]\u524d\u56db\u4e2a\u5b57\u8282\u4e2d\u58f0\u660e\u7684\u957f\u5ea6");
                    }
                    if (StandardTCPConnector.this.mode == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("request[" + StringUtils.bytesToString(buff) + "]"));
                        }
                        byte[] out = this.doService(buff);
                        out = this.addLength(out);
                        os.write(out);
                        os.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("response[" + StringUtils.bytesToString(out) + "]"));
                        }
                        this.connection.close();
                        break block14;
                    }
                    if (StandardTCPConnector.this.mode == 1) {
                        if (this.isEndPack(buff)) {
                            os.close();
                            this.connection.close();
                        } else {
                            byte[] out = this.doService(buff);
                            out = this.addLength(out);
                            os.write(out);
                        }
                        break block14;
                    }
                    throw new StandardTCPException("\u4e0d\u652f\u6301\u7684\u901a\u8baf\u6a21\u5f0f(\u53ea\u5141\u8bb80\u62161),mode = " + StandardTCPConnector.this.mode);
                }
                catch (IOException e) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }

        private byte[] doService(byte[] in) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            ComponentManager cm = ComponentManagerGetter.getManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6");
            }
            Dispatch disp = (Dispatch)cm.getComponent(StandardTCPConnector.this.dispatcher);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u8c03\u5ea6\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            byte[] out = (byte[])disp.doDispatch(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
            }
            return out;
        }

        private byte[] addLength(byte[] in) {
            int length = in.length;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5411\u8f93\u5165\u5b57\u8282\u6570\u7ec4\u5934\u90e8\u52a0\u56db\u4e2a\u5b57\u8282\u7684\u957f\u5ea6\u4fe1\u606f\uff0c\u957f\u5ea6\u503c\u4e3a:" + length));
            }
            byte[] out = new byte[length + 4];
            out[0] = (byte)((0xFF000000 & length) >> 24);
            out[1] = (byte)((0xFF0000 & length) >> 16);
            out[2] = (byte)((0xFF00 & length) >> 8);
            out[3] = (byte)(0xFF & length);
            System.arraycopy(in, 0, out, 4, length);
            return out;
        }

        private boolean isEndPack(byte[] in) {
            byte[] endpack = new byte[]{62, 62, 62};
            boolean endflag = true;
            for (int i = 0; i < endpack.length; ++i) {
                if (in[i] == endpack[i]) continue;
                endflag = false;
                break;
            }
            return endflag;
        }
    }
}

