/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterCloseException;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.adapter.tcp.StandardTCPException;
import com.dc.eai.adapter.tcp.TCPException;
import com.dc.eai.adapter.tcp.TCPSocket;
import com.dc.eai.component.LifeCycle;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardTCPAdapter
implements Adapter,
LifeCycle {
    private static final Log log = LogFactory.getLog((Class)StandardTCPAdapter.class);
    private AdapterConfig config;
    private TCPSocket tcpsock;
    private int mode = 0;
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int endmode = 0;
    private int prelength = 0;
    private byte endflag = (byte)62;
    private int maxbytes = 0;
    private static final int SHORT_CONNECTION = 0;
    private static final int LONG_CONNECTION = 1;
    private static final int WITHOUT_PRE = 0;
    private static final int WITH_PRE = 1;
    private static final int WITHOUT_LENGTH = 0;
    private static final int WITH_LENGTH = 1;
    private static final String MODE = "mode";
    private static final String ENDMODE = "endmode";
    private static final String PRELENGTH = "prelength";
    private static final String MAXBYTES = "maxbytes";
    private static final String ADDRESS = "address";
    private static final String COMMPORT = "commport";
    private static final String TIMEOUT = "timeout";
    private static final int DEFAULT_MAX_BYTES = 8192;

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public StandardTCPAdapter(AdapterConfig config) {
        this.setConfig(config);
        this.mode = NumberUtils.intValue(config.getAttribute(MODE));
        this.endmode = NumberUtils.intValue(config.getAttribute(ENDMODE));
        this.prelength = NumberUtils.intValue(config.getAttribute(PRELENGTH));
        this.address = config.getAttribute(ADDRESS);
        this.commport = NumberUtils.intValue(config.getAttribute(COMMPORT));
        this.timeout = NumberUtils.intValue(config.getAttribute(TIMEOUT));
        this.maxbytes = NumberUtils.intValue(config.getAttribute(MAXBYTES));
        this.tcpsock = new TCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
    }

    public void start() {
        if (this.mode == 1) {
            try {
                this.tcpsock.connect();
            }
            catch (TCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot establish socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
                throw new AdapterConnectException(e);
            }
        }
    }

    public void stop() {
        if (this.mode == 1) {
            try {
                this.tcpsock.close();
            }
            catch (TCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot destroy socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
                throw new AdapterCloseException(e);
            }
        }
    }

    public Object doComm(Object request) {
        byte[] req = (byte[])request;
        byte[] in = this.addLength(req);
        byte[] out = null;
        if (this.mode == 0) {
            try {
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, in);
                out = this.readpacket(this.tcpsock);
                byte[] byArray = out = this.checklength(out);
                return byArray;
            }
            catch (TCPException e) {
                log.error((Object)("\u65e0\u6cd5\u5efa\u7acb\u5230\u4ee5\u4e0b\u5730\u5740\u7684\u8fde\u63a5 " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                throw new AdapterConnectException(e);
            }
            finally {
                this.tcpsock.close();
            }
        }
        if (this.mode == 1) {
            try {
                this.writepacket(this.tcpsock, in);
                out = this.readpacket(this.tcpsock);
                return this.checklength(out);
            }
            catch (AdapterSendDataException e) {
                this.tcpsock.close();
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u53d1\u9001\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (AdapterReceiveDataException e) {
                this.tcpsock.close();
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u63a5\u6536\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (TCPException e) {
                throw new AdapterConnectException(e);
            }
        }
        return null;
    }

    private byte[] checklength(byte[] source) {
        int length;
        block8: {
            block7: {
                length = 0;
                if (this.endmode != 0) break block7;
                byte[] temp = new byte[4];
                System.arraycopy(source, this.prelength, temp, 0, 4);
                int[] lens = new int[4];
                for (int i = 0; i < temp.length; ++i) {
                    lens[i] = temp[i] & 0xFF;
                }
                length = (lens[0] << 24) + (lens[1] << 16) + (lens[2] << 8) + lens[3];
                if (length < 0) {
                    throw new StandardTCPException("length cannot be negative value:" + length);
                }
                if (length >= 8192) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("\u8fd4\u56de\u6570\u636e\u957f\u5ea6\u5b9a\u4e49\u8d85\u51fa\u9650\u957f[8192],\u8fd4\u56de\u6570\u636e\u4e2d\u5b9a\u4e49\u7684\u957f\u5ea6\u4e3a:" + length));
                    }
                    throw new StandardTCPException("length cannot be over DEFAULT_MAX_BYTES:" + length);
                }
                int withpre = NumberUtils.intValue(this.config.getAttribute("includepre"));
                int withlength = NumberUtils.intValue(this.config.getAttribute("includelength"));
                if (withpre == 0) {
                    length += this.prelength;
                }
                if (withlength != 0) break block8;
                length += 4;
                break block8;
            }
            if (this.endmode == 1) {
                for (int i = 0; i < source.length; ++i) {
                    if (source[i] != this.endflag) continue;
                    length = i + 1;
                    break;
                }
            }
        }
        byte[] dest = new byte[length];
        System.arraycopy(source, 0, dest, 0, length);
        return dest;
    }

    private byte str2byte(String input) {
        if (input.length() != 4) {
            throw new IllegalArgumentException("\u8f93\u5165\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u662f\u56db\u4f4d!" + input);
        }
        byte[] temp = new byte[]{(byte)input.charAt(2), (byte)input.charAt(3)};
        byte[] conv = StringUtils.AscToBcd(temp, 2);
        return conv[0];
    }

    private byte[] readpacket(TCPSocket tcpsock) {
        try {
            return tcpsock.recv();
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bfb\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterReceiveDataException(e);
        }
    }

    private void writepacket(TCPSocket tcpsock, byte[] buff) {
        try {
            tcpsock.send(buff);
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterSendDataException(e);
        }
    }

    private byte[] addLength(byte[] in) {
        int length = in.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5411\u8f93\u5165\u5b57\u8282\u6570\u7ec4\u5934\u90e8\u52a0\u56db\u4e2a\u5b57\u8282\u7684\u957f\u5ea6\u4fe1\u606f\uff0c\u957f\u5ea6\u503c\u4e3a:" + length));
        }
        byte[] out = new byte[length + 4];
        out[0] = (byte)((0xFF000000 & length) >> 24);
        out[1] = (byte)((0xFF0000 & length) >> 16);
        out[2] = (byte)((0xFF00 & length) >> 8);
        out[3] = (byte)(0xFF & length);
        System.arraycopy(in, 0, out, 4, length);
        return out;
    }
}

