/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.adapter.tcp.TCPException;
import com.dc.eai.adapter.tcp.TCPSocket;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassStandardTCPAdapter
implements Adapter {
    private static Log log = LogFactory.getLog((Class)PassStandardTCPAdapter.class);
    private AdapterConfig config;
    private TCPSocket tcpsock;
    private int mode = 0;
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int endmode = 0;
    private int prelength = 0;
    private byte endflag = (byte)62;
    private int maxbytes = 0;
    private static final int SHORT_CONNECTION = 0;
    private static final int LONG_CONNECTION = 1;
    private static final int WITHOUT_PRE = 0;
    private static final int WITH_PRE = 1;
    private static final int WITHOUT_LENGTH = 0;
    private static final int WITH_LENGTH = 1;
    private static final String MODE = "mode";
    private static final String ENDMODE = "endmode";
    private static final String PRELENGTH = "prelength";
    private static final String MAXBYTES = "maxbytes";
    private static final String ADDRESS = "address";
    private static final String COMMPORT = "commport";
    private static final String TIMEOUT = "timeout";

    public static void main(String[] args) {
    }

    public void loadConfig(AdapterConfig config) {
        this.mode = NumberUtils.intValue(config.getAttribute(MODE));
        this.address = config.getAttribute(ADDRESS);
        this.commport = NumberUtils.intValue(config.getAttribute(COMMPORT));
        this.timeout = NumberUtils.intValue(config.getAttribute(TIMEOUT));
        this.maxbytes = NumberUtils.intValue(config.getAttribute(MAXBYTES));
    }

    public Object doComm(Object request) {
        this.loadConfig(this.config);
        this.tcpsock = new TCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
        byte[] req = (byte[])request;
        byte[] out = null;
        if (this.mode == 0) {
            try {
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, req);
                byte[] byArray = out = this.readpacket(this.tcpsock);
                return byArray;
            }
            catch (TCPException e) {
                log.error((Object)("\u65e0\u6cd5\u5efa\u7acb\u5230\u4ee5\u4e0b\u5730\u5740\u7684\u8fde\u63a5 " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                throw new AdapterConnectException(e);
            }
            finally {
                this.tcpsock.close();
            }
        }
        if (this.mode == 1) {
            try {
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, req);
                byte[] e = out = this.readpacket(this.tcpsock);
                return e;
            }
            catch (AdapterSendDataException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u53d1\u9001\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (AdapterReceiveDataException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u63a5\u6536\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (TCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u7f51\u7edc\u8fde\u63a5\u51fa\u9519!", (Throwable)e);
                }
                throw new AdapterConnectException(e);
            }
            finally {
                this.tcpsock.close();
            }
        }
        return null;
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig adapterconfig) {
        this.config = adapterconfig;
    }

    private byte[] readpacket(TCPSocket tcpsock) {
        try {
            return tcpsock.recv();
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bfb\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterReceiveDataException(e);
        }
    }

    private void writepacket(TCPSocket tcpsock, byte[] buff) {
        try {
            tcpsock.send(buff);
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterSendDataException(e);
        }
    }
}

