/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.concurrent.Executor;
import com.dc.concurrent.ExecutorManager;
import com.dc.eai.adapter.Connector;
import com.dc.eai.adapter.tcp.StandardTCPException;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.dispatch.Dispatch;
import com.dc.util.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassEaiTcpConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)PassEaiTcpConnector.class);
    private AdapterConfig config;
    private int port;
    private int mode = 0;
    private int maxbytes = 0;
    private int timeout = 60000;
    private String dispatcher;
    private int bufferCapacity = 200;
    private byte[] buffer = new byte[this.bufferCapacity];
    private int bufferSize;
    private ServerSocket server;
    private static final String COMMPORT = "commport";
    private Socket client;
    private String executorName;
    private Executor executor;

    public static void main(String[] args) {
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public PassEaiTcpConnector(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        this.port = NumberUtils.intValue(config.getAttribute(COMMPORT));
        this.mode = NumberUtils.intValue(config.getAttribute("mode"));
        this.maxbytes = NumberUtils.intValue(config.getAttribute("maxbytes"));
        this.dispatcher = config.getAttribute("dispatcher");
        this.executorName = config.getAttribute("executor");
        if (this.executorName != null) {
            this.executor = ExecutorManager.getExecutor(this.executorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadConfig(this.config);
        try {
            try {
                this.server = new ServerSocket(this.port);
                while (true) {
                    this.client = this.server.accept();
                    if (this.executor != null) {
                        try {
                            this.executor.execute(new PassHandler(this.client));
                        }
                        catch (InterruptedException e) {
                            if (!log.isErrorEnabled()) continue;
                            log.error((Object)"\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    Thread trd = new Thread(new PassHandler(this.client));
                    trd.start();
                }
            }
            catch (IOException e) {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    static /* synthetic */ byte[] access$302(PassEaiTcpConnector x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }

    class PassHandler
    implements Runnable {
        private Socket connection;

        private PassHandler(Socket connection) {
            this.connection = connection;
        }

        public void run() {
            block10: {
                try {
                    InputStream is = this.connection.getInputStream();
                    OutputStream os = this.connection.getOutputStream();
                    this.connection.setSoTimeout(PassEaiTcpConnector.this.timeout);
                    this.readFrom(is);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u63a5\u6536\u5230\u6d88\u606f\u4e3a[" + new String(PassEaiTcpConnector.this.buffer) + "]"));
                    }
                    if (PassEaiTcpConnector.this.mode == 0) {
                        byte[] out = this.doService(PassEaiTcpConnector.this.buffer);
                        os.write(out);
                        os.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("response[" + new String(out) + "]"));
                        }
                        this.connection.close();
                        break block10;
                    }
                    if (PassEaiTcpConnector.this.mode == 1) {
                        if (this.isEndPack(PassEaiTcpConnector.this.buffer)) {
                            os.close();
                            this.connection.close();
                        } else {
                            byte[] out = this.doService(PassEaiTcpConnector.this.buffer);
                            os.write(out);
                        }
                        break block10;
                    }
                    throw new StandardTCPException("\u4e0d\u652f\u6301\u7684\u901a\u8baf\u6a21\u5f0f(\u53ea\u5141\u8bb80\u62161),mode = " + PassEaiTcpConnector.this.mode);
                }
                catch (IOException e) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }

        private byte[] doService(byte[] in) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            ComponentManager cm = ComponentManagerGetter.getManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6[" + PassEaiTcpConnector.this.dispatcher + "]"));
            }
            Dispatch disp = (Dispatch)cm.getComponent(PassEaiTcpConnector.this.dispatcher);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8c03\u7528\u8c03\u5ea6\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42disp=" + disp));
            }
            byte[] out = (byte[])disp.doDispatch(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
            }
            return out;
        }

        private boolean isEndPack(byte[] in) {
            byte[] endpack = new byte[]{62, 62, 62};
            boolean endflag = true;
            for (int i = 0; i < endpack.length; ++i) {
                if (in[i] == endpack[i]) continue;
                endflag = false;
                break;
            }
            return endflag;
        }

        public void readFrom(InputStream in) {
            PassEaiTcpConnector.this.bufferSize = 0;
            try {
                int numberRead;
                while ((numberRead = in.read(PassEaiTcpConnector.this.buffer, PassEaiTcpConnector.this.bufferSize, PassEaiTcpConnector.this.bufferCapacity - PassEaiTcpConnector.this.bufferSize)) >= 0) {
                    PassEaiTcpConnector.this.bufferSize += numberRead;
                    if (PassEaiTcpConnector.this.bufferSize != PassEaiTcpConnector.this.bufferCapacity) continue;
                    this.increaseBufferSize();
                }
            }
            catch (IOException e) {
                log.error((Object)"\u6d41\u6570\u636e\u8bfb\u53d6\u51fa\u9519\uff01", (Throwable)e);
            }
        }

        protected void increaseBufferSize() {
            PassEaiTcpConnector.this.bufferCapacity *= 2;
            byte[] newBuffer = new byte[PassEaiTcpConnector.this.bufferCapacity];
            System.arraycopy(PassEaiTcpConnector.this.buffer, 0, newBuffer, 0, PassEaiTcpConnector.this.bufferSize);
            PassEaiTcpConnector.access$302(PassEaiTcpConnector.this, newBuffer);
        }
    }
}

