/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.concurrent.Executor;
import com.dc.concurrent.ExecutorManager;
import com.dc.eai.adapter.Connector;
import com.dc.eai.adapter.tcp.StandardTCPException;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.dispatch.Dispatch;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EAITCPConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)EAITCPConnector.class);
    private AdapterConfig config;
    private int port;
    private int mode = 0;
    private int maxbytes = 0;
    private int timeout = 60000;
    private String dispatcher;
    private ServerSocket server;
    private Socket client;
    private String executorName;
    private Executor executor;

    public static void main(String[] args) {
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public EAITCPConnector(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        this.port = NumberUtils.intValue(config.getAttribute("commport"));
        this.mode = NumberUtils.intValue(config.getAttribute("mode"));
        this.maxbytes = NumberUtils.intValue(config.getAttribute("maxbytes"));
        this.dispatcher = config.getAttribute("dispatcher");
        this.executorName = config.getAttribute("executor");
        if (this.executorName != null) {
            this.executor = ExecutorManager.getExecutor(this.executorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadConfig(this.config);
        try {
            try {
                this.server = new ServerSocket(this.port);
                while (true) {
                    this.client = this.server.accept();
                    if (this.executor != null) {
                        try {
                            this.executor.execute(new Handler(this.client));
                        }
                        catch (InterruptedException e) {
                            if (!log.isErrorEnabled()) continue;
                            log.error((Object)"\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    Thread trd = new Thread(new Handler(this.client));
                    trd.start();
                }
            }
            catch (IOException e) {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    class Handler
    implements Runnable {
        private Socket connection;

        private Handler(Socket connection) {
            this.connection = connection;
        }

        public void run() {
            block15: {
                try {
                    InputStream is = this.connection.getInputStream();
                    OutputStream os = this.connection.getOutputStream();
                    this.connection.setSoTimeout(EAITCPConnector.this.timeout);
                    byte[] buff_len = new byte[10];
                    int head_len = 0;
                    head_len = is.read(buff_len);
                    if (head_len != buff_len.length) {
                        this.connection.close();
                        throw new StandardTCPException("\u62a5\u6587\u5934\u957f\u5ea6\u57df\u4e0d\u7b49\u4e8e10\uff0c\u63a5\u6536\u7684\u957f\u5ea6\uff1a" + head_len);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u957f\u5ea6\u57df10\u4e2a\u5b57\u8282\u4e3a[" + StringUtils.bytesToString(buff_len) + "]"));
                    }
                    int len = Integer.parseInt(new String(this.bytesToChars(buff_len)));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u6d88\u606f\u957f\u5ea6\u4e3a[" + len + "]"));
                    }
                    byte[] buff = new byte[len];
                    int recv_len = 0;
                    byte[] tbuff = new byte[len];
                    for (int real_len = 0; real_len < len; real_len += recv_len) {
                        recv_len = is.read(tbuff);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u672c\u6b21\u63a5\u6536\u957f\u5ea6\u4e3a[" + recv_len + "]"));
                        }
                        int copy_len = recv_len + real_len > len ? len - real_len : recv_len;
                        System.arraycopy(tbuff, 0, buff, real_len, copy_len);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("\u5b9e\u9645\u6d88\u606f\u957f\u5ea6\u4e3a[" + real_len + "]"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u63a5\u6536\u5230\u6d88\u606f\u4e3a[" + new String(buff) + "]"));
                    }
                    if (EAITCPConnector.this.mode == 0) {
                        byte[] out = this.doService(buff);
                        os.write(out);
                        os.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("response[" + new String(out) + "]"));
                        }
                        this.connection.close();
                        break block15;
                    }
                    if (EAITCPConnector.this.mode == 1) {
                        if (this.isEndPack(buff)) {
                            os.close();
                            this.connection.close();
                        } else {
                            byte[] out = this.doService(buff);
                            os.write(out);
                        }
                        break block15;
                    }
                    throw new StandardTCPException("\u4e0d\u652f\u6301\u7684\u901a\u8baf\u6a21\u5f0f(\u53ea\u5141\u8bb80\u62161),mode = " + EAITCPConnector.this.mode);
                }
                catch (IOException e) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }

        private char[] bytesToChars(byte[] bs) {
            int len = bs.length;
            char[] cs = new char[len];
            for (int j = 0; j < len; ++j) {
                cs[j] = (char)bs[j];
            }
            return cs;
        }

        private byte[] doService(byte[] in) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            ComponentManager cm = ComponentManagerGetter.getManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6[" + EAITCPConnector.this.dispatcher + "]"));
            }
            Dispatch disp = (Dispatch)cm.getComponent(EAITCPConnector.this.dispatcher);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8c03\u7528\u8c03\u5ea6\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42disp=" + disp));
            }
            byte[] out = (byte[])disp.doDispatch(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
            }
            return out;
        }

        private boolean isEndPack(byte[] in) {
            byte[] endpack = new byte[]{62, 62, 62};
            boolean endflag = true;
            for (int i = 0; i < endpack.length; ++i) {
                if (in[i] == endpack[i]) continue;
                endflag = false;
                break;
            }
            return endflag;
        }
    }
}

