/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tcp;

import com.dc.concurrent.Executor;
import com.dc.concurrent.ExecutorManager;
import com.dc.eai.adapter.Connector;
import com.dc.eai.adapter.tcp.StandardTCPException;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.dispatch.Dispatch;
import com.dc.util.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ACETcpConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)ACETcpConnector.class);
    private AdapterConfig config;
    private int port;
    private int mode = 0;
    private int maxbytes = 0;
    private int timeout = 60000;
    private String dispatcher;
    private ServerSocket server;
    private Socket client;
    private String executorName;
    private Executor executor;

    public static void main(String[] args) {
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public ACETcpConnector(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        this.port = NumberUtils.intValue(config.getAttribute("commport"));
        this.mode = NumberUtils.intValue(config.getAttribute("mode"));
        this.maxbytes = NumberUtils.intValue(config.getAttribute("maxbytes"));
        this.dispatcher = config.getAttribute("dispatcher");
        this.executorName = config.getAttribute("executor");
        if (this.executorName != null) {
            this.executor = ExecutorManager.getExecutor(this.executorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadConfig(this.config);
        try {
            try {
                this.server = new ServerSocket(this.port);
                while (true) {
                    this.client = this.server.accept();
                    if (this.executor != null) {
                        try {
                            this.executor.execute(new TuxeduoHandler(this.client));
                        }
                        catch (InterruptedException e) {
                            if (!log.isErrorEnabled()) continue;
                            log.error((Object)"\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    Thread trd = new Thread(new TuxeduoHandler(this.client));
                    trd.start();
                }
            }
            catch (IOException e) {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    class TuxeduoHandler
    implements Runnable {
        private Socket connection;

        private TuxeduoHandler(Socket connection) {
            this.connection = connection;
        }

        public void run() {
            block20: {
                try {
                    InputStream is = this.connection.getInputStream();
                    OutputStream os = this.connection.getOutputStream();
                    this.connection.setSoTimeout(ACETcpConnector.this.timeout);
                    byte[] buff_len = new byte[5];
                    int head_len = 0;
                    head_len = is.read(buff_len);
                    if (head_len != buff_len.length) {
                        this.connection.close();
                        throw new StandardTCPException("\u62a5\u6587\u5934\u957f\u5ea6\u57df\u4e0d\u7b49\u4e8e5\uff0c\u63a5\u6536\u7684\u957f\u5ea6\uff1a" + head_len);
                    }
                    byte[] temp_buffer = new byte[4];
                    System.arraycopy(buff_len, 1, temp_buffer, 0, 4);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u957f\u5ea6\u57df4\u4e2a\u5b57\u8282\u4e3a[" + this.byteToInt(temp_buffer) + "]"));
                    }
                    int len = this.byteToInt(temp_buffer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u6d88\u606f\u957f\u5ea6\u4e3a[" + len + "]"));
                    }
                    byte[] buff = new byte[len];
                    int real_len = 0;
                    int recv_len = 0;
                    int i = 0;
                    while (real_len < len - 5) {
                        byte[] tbuff = new byte[256];
                        recv_len = is.read(tbuff);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u672c\u6b21\u63a5\u6536\u62a5\u6587\u4e3a[" + new String(tbuff) + "]"));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u672c\u6b21\u63a5\u6536\u957f\u5ea6\u4e3a[" + recv_len + "]"));
                        }
                        if (recv_len < 256 && i == 0) {
                            System.arraycopy(tbuff, 0, buff, 0, recv_len);
                            real_len = len;
                            break;
                        }
                        int copy_len = 0;
                        if (i > 0) {
                            copy_len = recv_len - 5;
                            System.arraycopy(tbuff, 5, buff, i * 256, copy_len);
                        } else {
                            copy_len = recv_len;
                            System.arraycopy(tbuff, 0, buff, 0, copy_len);
                        }
                        real_len += copy_len;
                        ++i;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u63a5\u6536\u5230\u6d88\u606f\u4e3a[" + new String(buff) + "]"));
                    }
                    if (ACETcpConnector.this.mode == 0) {
                        byte[] out = this.doService(buff);
                        byte[] out_len = new byte[5];
                        out_len[0] = 2;
                        byte[] temp_out = this.intToByte(out.length);
                        byte[] reout = new byte[out.length + 5];
                        System.arraycopy(temp_out, 0, out_len, 1, 4);
                        System.arraycopy(out_len, 0, reout, 0, 5);
                        System.arraycopy(out, 0, reout, 5, out.length);
                        os.write(reout);
                        os.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("response[" + new String(out) + "]"));
                        }
                        this.connection.close();
                        break block20;
                    }
                    if (ACETcpConnector.this.mode == 1) {
                        if (this.isEndPack(buff)) {
                            os.close();
                            this.connection.close();
                        } else {
                            byte[] out = this.doService(buff);
                            byte[] out_len = new byte[5];
                            out_len[0] = 2;
                            byte[] temp_out = this.intToByte(out.length);
                            byte[] reout = new byte[out.length + 5];
                            System.arraycopy(temp_out, 0, out_len, 1, 4);
                            System.arraycopy(out_len, 0, reout, 0, 5);
                            System.arraycopy(out, 0, reout, 5, out.length);
                            os.write(reout);
                            os.close();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\u5e73\u53f0\u8fd4\u56de\u62a5\u6587:[" + new String(out) + "]"));
                            }
                        }
                        break block20;
                    }
                    throw new StandardTCPException("\u4e0d\u652f\u6301\u7684\u901a\u8baf\u6a21\u5f0f(\u53ea\u5141\u8bb80\u62161),mode = " + ACETcpConnector.this.mode);
                }
                catch (IOException e) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }

        public int byteToInt(byte[] b) {
            int s = 0;
            for (int i = 0; i < 3; ++i) {
                s = b[i] >= 0 ? (s += b[i]) : s + 256 + b[i];
                s *= 256;
            }
            s = b[3] >= 0 ? (s += b[3]) : s + 256 + b[3];
            return s;
        }

        public byte[] intToByte(int in) {
            int temp = in;
            byte[] b = new byte[4];
            for (int i = b.length - 1; i > -1; --i) {
                b[i] = new Integer(temp & 0xFF).byteValue();
                temp >>= 8;
            }
            return b;
        }

        private byte[] doService(byte[] in) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            ComponentManager cm = ComponentManagerGetter.getManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6[" + ACETcpConnector.this.dispatcher + "]"));
            }
            Dispatch disp = (Dispatch)cm.getComponent(ACETcpConnector.this.dispatcher);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8c03\u7528\u8c03\u5ea6\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42disp=" + disp));
            }
            byte[] out = (byte[])disp.doDispatch(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
            }
            return out;
        }

        private boolean isEndPack(byte[] in) {
            byte[] endpack = new byte[]{62, 62, 62};
            boolean endflag = true;
            for (int i = 0; i < endpack.length; ++i) {
                if (in[i] == endpack[i]) continue;
                endflag = false;
                break;
            }
            return endflag;
        }

        public void addLength() {
        }
    }
}

