/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.http;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterInitException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.data.CompositeData;
import com.dc.eai.security.DataProcess;
import com.dc.eai.service.ServiceResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityRemoteServiceHttpAdapter
implements Adapter {
    private static Log log = LogFactory.getLog((Class)SecurityRemoteServiceHttpAdapter.class);
    private AdapterConfig config;
    private String remoteurl = "";

    public Object doComm(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8bfb\u53d6\u8fdc\u7a0b\u670d\u52a1HTTP\u9002\u914d\u5668\u914d\u7f6e\u5f00\u59cb");
        }
        this.config = this.getConfig();
        this.remoteurl = this.config.getAttribute("remoteurl");
        if ("".equals(this.remoteurl) || this.remoteurl == null) {
            throw new IllegalArgumentException("\u8fdc\u7a0b\u670d\u52a1\u5668 remoteurl \u4e3a\u7a7a\uff01");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("remoteurl=" + this.remoteurl));
        }
        CompositeData request = (CompositeData)obj;
        request = DataProcess.encryptData(request);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u52a0\u5bc6\u540e\u6570\u636e\uff1a" + request));
        }
        return this.doService(request);
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    private Object doService(CompositeData req) {
        Object objResp = null;
        URLConnection urlcon = null;
        URL httpUrl = null;
        try {
            httpUrl = new URL(this.remoteurl);
        }
        catch (MalformedURLException e1) {
            AdapterInitException ie = new AdapterInitException(e1);
            ie.addScene("\u83b7\u53d6URL\u8bf7\u6c42\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl + "]");
            throw ie;
        }
        try {
            urlcon = httpUrl.openConnection();
        }
        catch (IOException e1) {
            AdapterConnectException ce = new AdapterConnectException(e1);
            ce.addScene("\u8c03\u7528\u8fdc\u7a0b\u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl + "]");
            throw ce;
        }
        ObjectOutputStream objout = null;
        try {
            urlcon.setDoOutput(true);
            urlcon.setUseCaches(false);
            OutputStream outs = urlcon.getOutputStream();
            objout = new ObjectOutputStream(outs);
            objout.writeObject(req);
            objout.close();
        }
        catch (IOException e1) {
            AdapterSendDataException se = new AdapterSendDataException(e1);
            se.addScene("\u8fdc\u7a0b\u670d\u52a1\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff01\u670d\u52a1\u672a\u542f\u52a8\u6216\u542f\u52a8\u65f6\u53d1\u751f\u5f02\u5e38!", "remoteurl=[" + this.remoteurl.substring(0, 28) + "]");
            throw se;
        }
        finally {
            try {
                objout.close();
            }
            catch (IOException e) {
                AdapterSendDataException se = new AdapterSendDataException(e);
                se.addScene("\u8fdc\u7a0b\u670d\u52a1\u53d1\u9001\u8bf7\u6c42\u540e\u5173\u95ed\u8fde\u63a5\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl.substring(0, 28) + "]");
                throw se;
            }
        }
        ObjectInputStream objIuput = null;
        try {
            InputStream instr = urlcon.getInputStream();
            objIuput = new ObjectInputStream(instr);
            objResp = objIuput.readObject();
            objIuput.close();
        }
        catch (IOException e1) {
            AdapterReceiveDataException re = new AdapterReceiveDataException(e1);
            re.addScene("\u8fdc\u7a0b\u670d\u52a1\u63a5\u53d7\u8bf7\u6c42\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl.substring(0, 28) + "]");
            throw re;
        }
        catch (ClassNotFoundException e1) {
            AdapterReceiveDataException re = new AdapterReceiveDataException(e1);
            re.addScene("\u8fdc\u7a0b\u670d\u52a1\u63a5\u53d7\u8bf7\u6c42,\u83b7\u53d6\u5bf9\u8c61\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl + "]");
            throw re;
        }
        finally {
            try {
                objIuput.close();
            }
            catch (IOException e) {
                AdapterReceiveDataException se = new AdapterReceiveDataException(e);
                se.addScene("\u8fdc\u7a0b\u670d\u52a1\u63a5\u6536\u8bf7\u6c42\u540e\u5173\u95ed\u8fde\u63a5\u5931\u8d25\uff01", "remoteurl=[" + this.remoteurl.substring(0, 28) + "]");
                throw se;
            }
        }
        ServiceResult serviceResult = (ServiceResult)objResp;
        return serviceResult;
    }
}

