/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.http;

import com.dc.eai.entry.http.HTTPException;
import com.dc.eai.startup.Bootstrap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPConnector
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog((Class)HTTPConnector.class);
    private String dispatcher = null;
    private byte[] responseData;

    public void init(ServletConfig config) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"-------------\u52a0\u8f7d:HTTPConnector\u5f00\u59cb--------------");
        }
        this.dispatcher = config.getInitParameter("dispatcher");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isDebugEnabled() || this.log.isErrorEnabled()) {
            this.log.debug((Object)("connector recevie time is :" + System.currentTimeMillis()));
        }
        try {
            byte[] requestData = this.readContent(request);
            this.responseData = this.doService(requestData);
            this.writeContent(response, this.responseData);
        }
        catch (HTTPException e) {
            e.printStackTrace();
            byte[] err = e.errCode().getBytes();
            this.responseData = err;
        }
        if (this.log.isDebugEnabled() || this.log.isErrorEnabled()) {
            this.log.debug((Object)("connector send end  time is :" + System.currentTimeMillis()));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private byte[] doService(byte[] request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u5f00\u59cb\u6267\u884c\u670d\u52a1:\u8bf7\u6c42\u6570\u636e[" + new String(request)));
        }
        Class<?> cmgetter = null;
        try {
            cmgetter = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManagerGetter");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            HTTPException he = new HTTPException("ClassNotFound_ComponentManagerGetter Error", e);
            throw he;
        }
        Object cmo = null;
        try {
            cmo = cmgetter.getMethod("getManager", null).invoke(null, null);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManagerGetter.getManager Error", e1);
            throw he;
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManagerGetter.getManager Error", e1);
            throw he;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManagerGetter.getManager Error", e1);
            throw he;
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManagerGetter.getManager Error", e1);
            throw he;
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManagerGetter.getManager Error", e1);
            throw he;
        }
        Class<?> cm = null;
        try {
            cm = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManager");
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            HTTPException he = new HTTPException("ClassNotFound_ComponentManager Error", e2);
            throw he;
        }
        Object compo = null;
        try {
            compo = cm.getMethod("getComponent", String.class).invoke(cmo, this.dispatcher);
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.getComponent Error", e3);
            throw he;
        }
        catch (SecurityException e3) {
            e3.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.getComponent Error", e3);
            throw he;
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.getComponent Error", e3);
            throw he;
        }
        catch (InvocationTargetException e3) {
            e3.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.getComponent Error", e3);
            throw he;
        }
        catch (NoSuchMethodException e3) {
            e3.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.getComponent Error", e3);
            throw he;
        }
        byte[] data = request;
        Object resp = null;
        try {
            resp = compo.getClass().getMethod("doDispatch", Object.class).invoke(compo, new Object[]{data});
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.doDispatch Error", e4);
            throw he;
        }
        catch (SecurityException e4) {
            e4.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.doDispatch Error", e4);
            throw he;
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.doDispatch Error", e4);
            throw he;
        }
        catch (InvocationTargetException e4) {
            e4.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.doDispatch Error", e4);
            throw he;
        }
        catch (NoSuchMethodException e4) {
            e4.printStackTrace();
            HTTPException he = new HTTPException("invoke_ComponentManager.doDispatch Error", e4);
            throw he;
        }
        byte[] respbuff = (byte[])resp;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u6267\u884c\u670d\u52a1\u5b8c\u6bd5:\u54cd\u5e94\u6570\u636e[" + new String(respbuff)));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u76f8\u5e94\u6570\u636e\u8f6c\u6362\u62a5\u6587\u5f00\u59cb...");
        }
        byte[] result = null;
        try {
            result = new String(respbuff).getBytes("UTF-8");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u8f6c\u7801\u540e\u7684\u6570\u636e\u4e3a:" + new String(result, "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            HTTPException he = new HTTPException("UnsupportedEncoding inptream to UTF-8  Error", e);
            throw he;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u76f8\u5e94\u6570\u636e\u8f6c\u6362\u62a5\u7ed3\u675f...");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContent(HttpServletRequest request) {
        ServletInputStream input;
        block18: {
            input = null;
            try {
                input = request.getInputStream();
            }
            catch (IOException e) {
                if (!this.log.isErrorEnabled()) break block18;
                this.log.error((Object)"GetInputStream Error", (Throwable)e);
            }
        }
        int bufferSize = 0;
        int bufferCapacity = 1024;
        byte[] b = new byte[bufferCapacity];
        int numberRead = 0;
        try {
            while ((numberRead = input.read(b, bufferSize, bufferCapacity - bufferSize)) >= 0) {
                if ((bufferSize += numberRead) != bufferCapacity) continue;
                bufferCapacity = 2 * bufferCapacity;
                byte[] newBuffer = new byte[bufferCapacity];
                System.arraycopy(b, 0, newBuffer, 0, bufferSize);
                b = newBuffer;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"\u6d41\u6570\u636e\u8bfb\u53d6\u51fa\u9519\uff01", (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.log.error((Object)"\u8f93\u5165\u6d41\u5173\u95ed\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        byte[] buffer = new byte[bufferSize];
        System.arraycopy(b, 0, buffer, 0, bufferSize);
        String temp = null;
        try {
            temp = new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            return temp.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(HttpServletResponse response, byte[] data) {
        ServletOutputStream out;
        block16: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WriteInput start...");
            }
            out = null;
            try {
                out = response.getOutputStream();
            }
            catch (IOException e) {
                if (!this.log.isErrorEnabled()) break block16;
                this.log.error((Object)"GetOutputStream Error", (Throwable)e);
            }
        }
        try {
            out.write(data);
        }
        catch (IOException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"ReadInput Error", (Throwable)e);
            }
        }
        finally {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"WriteInput end...");
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

