/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.http;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterCloseException;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterInitException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPAdapter
implements Adapter {
    private String str;
    private Log log = LogFactory.getLog((Class)HTTPAdapter.class);
    private AdapterConfig config;
    private String address;
    private String service = "";
    private int port = 80;
    private String method = "POST";

    public Object doComm(Object request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"------HTTP\u901a\u8baf\u63a5\u51fa\u5f00\u59cb");
            this.log.debug((Object)("\u8bf7\u6c42\u62a5\u6587=[" + request + "]"));
        }
        this.readConfig(this.config);
        HttpURLConnection httpCon = this.connect();
        if (this.log.isDebugEnabled() || this.log.isErrorEnabled()) {
            this.log.debug((Object)("adapter send  time is :" + System.currentTimeMillis()));
        }
        this.writeContent((byte[])request, httpCon);
        byte[] response = this.readContent(httpCon);
        if (this.log.isDebugEnabled() || this.log.isErrorEnabled()) {
            this.log.debug((Object)("adapter recevie  time is :" + System.currentTimeMillis()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u54cd\u5e94\u62a5\u6587=[" + response + "]"));
            this.log.debug((Object)"------HTTP\u901a\u8baf\u63a5\u51fa\u6210\u529f");
        }
        this.close(httpCon);
        return response;
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    private void readConfig(AdapterConfig config) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u8bfb\u53d6HTTP\u9002\u914d\u5668\u914d\u7f6e\u5f00\u59cb");
        }
        this.address = config.getAttribute("address");
        if (this.address == null) {
            throw new AdapterInitException(new IllegalArgumentException("Null Address"));
        }
        if (config.getAttribute("port") != null) {
            this.port = NumberUtils.intValue(config.getAttribute("port"));
        }
        if (config.getAttribute("service") != null) {
            this.service = config.getAttribute("service");
        }
        if (config.getAttribute("method") != null) {
            this.method = config.getAttribute("method");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u8bfb\u53d6HTTP\u9002\u914d\u5668\u914d\u7f6e\u6210\u529f");
        }
    }

    private HttpURLConnection connect() {
        URL host;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5efa\u7acbURL\u8fde\u63a5\u5f00\u59cb");
        }
        try {
            host = new URL("http", this.address, this.port, this.service);
        }
        catch (MalformedURLException e) {
            AdapterInitException ie = new AdapterInitException(e);
            throw ie;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)host.openConnection();
        }
        catch (IOException e) {
            this.close(connection);
            AdapterConnectException ce = new AdapterConnectException(e);
            throw ce;
        }
        connection.setDoOutput(true);
        if (this.config.getAttribute("method") != null) {
            this.method = this.config.getAttribute("method");
        }
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            this.close(connection);
            AdapterConnectException ce = new AdapterConnectException(e);
            throw ce;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5efa\u7acbURL\u8fde\u63a5\u6210\u529f");
        }
        return connection;
    }

    private void writeContent(byte[] content, HttpURLConnection connection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u586b\u5145\u8bf7\u6c42\u62a5\u6587\u5f00\u59cb");
        }
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(content);
        }
        catch (IOException e) {
            this.close(connection);
            throw new AdapterSendDataException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u586b\u5145\u8bf7\u6c42\u62a5\u6587\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContent(HttpURLConnection connection) {
        InputStream input;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u5f00\u59cb");
        }
        try {
            input = connection.getInputStream();
        }
        catch (IOException e) {
            this.close(connection);
            AdapterReceiveDataException re = new AdapterReceiveDataException(e);
            throw re;
        }
        int bufferSize = 0;
        int bufferCapacity = 1024;
        byte[] b = new byte[bufferCapacity];
        int numberRead = 0;
        try {
            while ((numberRead = input.read(b, bufferSize, bufferCapacity - bufferSize)) >= 0) {
                if ((bufferSize += numberRead) != bufferCapacity) continue;
                bufferCapacity = 2 * bufferCapacity;
                byte[] newBuffer = new byte[bufferCapacity];
                System.arraycopy(b, 0, newBuffer, 0, bufferSize);
                b = newBuffer;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"\u6d41\u6570\u636e\u8bfb\u53d6\u51fa\u9519\uff01", (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.log.error((Object)"\u8f93\u5165\u6d41\u5173\u95ed\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        byte[] buffer = new byte[bufferSize];
        System.arraycopy(b, 0, buffer, 0, bufferSize);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u63a5\u6536\u8bf7\u6c42\u6570\u636e,\u4e0d\u5e26\u5b57\u7b26\u96c6[" + new String(buffer) + "]"));
        }
        String temp = null;
        try {
            temp = new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u63a5\u6536\u8bf7\u6c42\u6570\u636e,[UTF-8]\u5b57\u7b26\u96c6\u8f6c\u6362\u540e[" + temp + "]"));
        }
        byte[] temp_byte = null;
        temp_byte = temp.getBytes();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u7ed3\u675f");
        }
        return temp_byte;
    }

    private void close(HttpURLConnection connection) {
        try {
            connection.disconnect();
        }
        catch (Exception e) {
            AdapterCloseException ce = new AdapterCloseException(e);
            throw ce;
        }
    }
}

