/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.db.DBException;
import com.dc.db.DBMetaData;
import com.dc.db.DBRecord;
import com.dc.db.DBUtil;
import com.dc.db.SQLText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLParser {
    private static Log log = LogFactory.getLog((Class)SQLParser.class);
    private static final String PARAMETER_TOKEN = "#";
    private DBMetaData dbMeta;

    public SQLParser(DBMetaData dbMeta) {
        this.dbMeta = dbMeta;
    }

    public SQLText getInsertSql(String tableName, DBRecord dbRecord) {
        int i;
        List columnList = this.dbMeta.getcolumnList(tableName);
        List primaryKeyList = this.dbMeta.getPrimaryKeyList(tableName);
        ArrayList fieldList = new ArrayList(dbRecord.columnSet());
        Collections.sort(fieldList);
        for (i = fieldList.size() - 1; i > -1; --i) {
            if (columnList.contains(fieldList.get(i))) continue;
            fieldList.remove(i);
        }
        for (i = 0; i < primaryKeyList.size(); ++i) {
            if (fieldList.contains(primaryKeyList.get(i))) continue;
            DBException e_ret = new DBException("dbrecord_contain_no_column");
            e_ret.addScene("TABLE_NAME", tableName);
            for (int j = 0; j < columnList.size(); ++j) {
                e_ret.addScene("COLUMN_NAME_IN_TABLE" + (j + 1), columnList.get(j));
            }
            Object[] columns_in_dbrecord = dbRecord.columnSet().toArray();
            e_ret.addScene("COLUMN_COUNT_IN_DBRECORD", columns_in_dbrecord.length);
            for (int j = 0; j < columns_in_dbrecord.length; ++j) {
                e_ret.addScene("COUNT_IN_DBRECORD" + (j + 1), columns_in_dbrecord[j]);
            }
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8f93\u5165\u7684\u6570\u636e\u5e93\u8bb0\u5f55\u4e0d\u5305\u542b\u8be5\u8868\u6240\u9700\u7684\u4efb\u4f55\u5217\u4fe1\u606f", (Throwable)e_ret);
            }
            throw e_ret;
        }
        StringBuffer buff = new StringBuffer();
        StringBuffer valBuff = new StringBuffer();
        buff.append("INSERT INTO ").append(tableName).append("(");
        for (int i2 = 0; i2 < fieldList.size(); ++i2) {
            if (i2 > 0) {
                buff.append(", ");
                valBuff.append(", ");
            }
            buff.append(fieldList.get(i2));
            valBuff.append("?");
        }
        buff.append(") VALUES (").append(valBuff).append(")");
        String[] insertFields = fieldList.toArray(new String[fieldList.size()]);
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(insertFields);
        return sqlText;
    }

    public SQLText getUpdateSql(String tableName, DBRecord dbRecord) {
        int i;
        int i2;
        List columnList = this.dbMeta.getcolumnList(tableName);
        List primaryKeyList = this.dbMeta.getPrimaryKeyList(tableName);
        ArrayList fieldList = new ArrayList(dbRecord.columnSet());
        Collections.sort(fieldList);
        for (i2 = fieldList.size() - 1; i2 > -1; --i2) {
            if (columnList.contains(fieldList.get(i2))) continue;
            fieldList.remove(i2);
        }
        for (i2 = 0; i2 < primaryKeyList.size(); ++i2) {
            if (!fieldList.contains(primaryKeyList.get(i2))) {
                DBException e_ret = new DBException("dbrecord_primary_key_absent");
                e_ret.addScene("TABLE_NAME", tableName);
                for (int j = 0; j < primaryKeyList.size(); ++j) {
                    e_ret.addScene("PK_COLUMN_NAME" + (j + 1), primaryKeyList.get(j));
                }
                Object[] columns_in_dbrecord = dbRecord.columnSet().toArray();
                for (int j = 0; j < columns_in_dbrecord.length; ++j) {
                    e_ret.addScene("COUNT_IN_DBRECORD" + (j + 1), columns_in_dbrecord[j]);
                }
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8f93\u5165\u7684\u6570\u636e\u5e93\u8bb0\u5f55\u4e0d\u5305\u542b\u8be5\u8868\u4e3b\u952e\u5b57\u6bb5\u4fe1\u606f", (Throwable)e_ret);
                }
                throw e_ret;
            }
            fieldList.remove(primaryKeyList.get(i2));
        }
        StringBuffer buff = new StringBuffer();
        buff.append("UPDATE ").append(tableName).append(" SET ");
        for (i = 0; i < fieldList.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(fieldList.get(i)).append("=?");
        }
        buff.append(" WHERE ");
        for (i = 0; i < primaryKeyList.size(); ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(primaryKeyList.get(i)).append("=?");
        }
        int count = fieldList.size();
        int updateFieldsCount = count + primaryKeyList.size();
        String[] updateFields = fieldList.toArray(new String[updateFieldsCount]);
        for (int i3 = 0; i3 < primaryKeyList.size(); ++i3) {
            updateFields[count + i3] = (String)primaryKeyList.get(i3);
        }
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(updateFields);
        return sqlText;
    }

    public SQLText getDeleteSql(String tableName, DBRecord dbRecord) {
        List primaryKeyList = this.dbMeta.getPrimaryKeyList(tableName);
        ArrayList fieldList = new ArrayList(dbRecord.columnSet());
        Collections.sort(fieldList);
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            if (fieldList.contains(primaryKeyList.get(i))) continue;
            DBException e_ret = new DBException("dbrecord_primary_key_absent");
            e_ret.addScene("TABLE_NAME", tableName);
            for (int j = 0; j < primaryKeyList.size(); ++j) {
                e_ret.addScene("PK_COLUMN_NAME" + (j + 1), primaryKeyList.get(j));
            }
            Object[] columns_in_dbrecord = dbRecord.columnSet().toArray();
            for (int j = 0; j < columns_in_dbrecord.length; ++j) {
                e_ret.addScene("COUNT_IN_DBRECORD" + (j + 1), columns_in_dbrecord[j]);
            }
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8f93\u5165\u7684\u6570\u636e\u5e93\u8bb0\u5f55\u4e0d\u5305\u542b\u8be5\u8868\u4e3b\u952e\u5b57\u6bb5\u4fe1\u606f", (Throwable)e_ret);
            }
            throw e_ret;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("DELETE FROM ").append(tableName).append(" WHERE ");
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(primaryKeyList.get(i)).append("=?");
        }
        int deleteFieldsCount = primaryKeyList.size();
        String[] deleteFields = primaryKeyList.toArray(new String[deleteFieldsCount]);
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(deleteFields);
        return sqlText;
    }

    public SQLText getSelectSql(String tableName, DBRecord dbRecord) {
        List primaryKeyList = this.dbMeta.getPrimaryKeyList(tableName);
        ArrayList fieldList = new ArrayList(dbRecord.columnSet());
        Collections.sort(fieldList);
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            if (fieldList.contains(primaryKeyList.get(i))) continue;
            DBException e_ret = new DBException("dbrecord_primary_key_absent");
            e_ret.addScene("TABLE_NAME", tableName);
            for (int j = 0; j < primaryKeyList.size(); ++j) {
                e_ret.addScene("PK_COLUMN_NAME" + (j + 1), primaryKeyList.get(j));
            }
            Object[] columns_in_dbrecord = dbRecord.columnSet().toArray();
            for (int j = 0; j < columns_in_dbrecord.length; ++j) {
                e_ret.addScene("COUNT_IN_DBRECORD" + (j + 1), columns_in_dbrecord[j]);
            }
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8f93\u5165\u7684\u6570\u636e\u5e93\u8bb0\u5f55\u4e0d\u5305\u542b\u8be5\u8868\u4e3b\u952e\u5b57\u6bb5\u4fe1\u606f", (Throwable)e_ret);
            }
            throw e_ret;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT * FROM ").append(tableName).append(" WHERE ");
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(primaryKeyList.get(i)).append("=?");
        }
        int selectParamsCount = primaryKeyList.size();
        String[] selectParams = primaryKeyList.toArray(new String[selectParamsCount]);
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(selectParams);
        return sqlText;
    }

    public SQLText parseSQLDynamic(String sqlStatement, DBRecord dbRecord, Map paramTypeMap) {
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        String token = null;
        String lastToken = null;
        StringBuffer buff = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(sqlStatement, "# ,()", true);
        int clause = 0;
        int INSERT = 1;
        int FROM = 2;
        int UPDATE = 3;
        int SET = 4;
        int WHERE = 5;
        int VALUES = 6;
        boolean firstWhere = true;
        boolean firstSet = true;
        boolean isFields = false;
        boolean firstValues = true;
        ArrayList<String> fieldsList = new ArrayList<String>();
        String tempString = "";
        if (paramTypeMap != null) {
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                if (token.equals("into")) {
                    clause = INSERT;
                    buff.append(token);
                } else if (clause == INSERT) {
                    if (isFields) {
                        fieldsList.add(token);
                        if (token.equals("values")) {
                            clause = VALUES;
                        }
                    } else {
                        buff.append(token);
                        if (token.equals("(")) {
                            isFields = true;
                        }
                    }
                } else if (clause == VALUES) {
                    if (!PARAMETER_TOKEN.equals(token)) {
                        fieldsList.add(token);
                    } else {
                        String tempField;
                        token = parser.nextToken();
                        if (PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_param_null");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        lastToken = token;
                        token = parser.nextToken();
                        if (!PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_unterminated");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        token = null;
                        boolean havePara = false;
                        if (dbRecord.columnSet().contains(lastToken)) {
                            paramList.add(lastToken);
                            Integer type = (Integer)paramTypeMap.get(lastToken);
                            Integer columnType = new Integer(DBUtil.getColumnType(type));
                            typeList.add(columnType);
                            if (firstValues) {
                                String tempItem;
                                while ((tempItem = (String)fieldsList.remove(fieldsList.size() - 1)).equals(" ")) {
                                }
                                if (!tempItem.equals(",")) {
                                    fieldsList.add(tempItem);
                                }
                            }
                            fieldsList.add("?");
                            havePara = true;
                        } else {
                            String tempItem;
                            while ((tempItem = (String)fieldsList.remove(fieldsList.size() - 1)).equals(" ")) {
                            }
                            if (!tempItem.equals(",")) {
                                fieldsList.add(tempItem);
                            }
                        }
                        if (firstValues) {
                            while (((String)fieldsList.get(0)).equals(" ") || ((String)fieldsList.get(0)).equals(",")) {
                                tempField = (String)fieldsList.remove(0);
                            }
                            tempField = (String)fieldsList.remove(0);
                            if (havePara) {
                                buff.append(tempField);
                                firstValues = false;
                            }
                        } else {
                            while (((String)fieldsList.get(0)).equals(" ") || ((String)fieldsList.get(0)).equals(",")) {
                                tempField = (String)fieldsList.remove(0);
                                if (!havePara) continue;
                                buff.append(tempField);
                            }
                            tempField = (String)fieldsList.remove(0);
                            if (havePara) {
                                buff.append(tempField);
                            }
                        }
                    }
                } else if (token.equals("where")) {
                    buff.append(token);
                    clause = WHERE;
                } else {
                    Integer columnType;
                    if (clause == WHERE) {
                        String tsql = sqlStatement.substring(sqlStatement.indexOf("where") + 5);
                        StringTokenizer tparser = new StringTokenizer(tsql, "# ,()", true);
                        String str = new MyParser().toString(tparser, dbRecord, paramTypeMap, paramList, typeList);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("After replace parameter : [" + str + "]"));
                        }
                        buff.append(" ").append(str);
                        break;
                    }
                    if (token.equals("set")) {
                        clause = SET;
                        buff.append(token);
                        tempString = "";
                    } else if (clause == SET) {
                        if (!PARAMETER_TOKEN.equals(token)) {
                            if (!firstSet || !token.equals(",")) {
                                tempString = tempString + token;
                            }
                        } else {
                            token = parser.nextToken();
                            if (PARAMETER_TOKEN.equals(token)) {
                                DBException ex_ret = new DBException("parse_sql_param_null");
                                ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                                throw ex_ret;
                            }
                            lastToken = token;
                            token = parser.nextToken();
                            if (!PARAMETER_TOKEN.equals(token)) {
                                DBException ex_ret = new DBException("parse_sql_unterminated");
                                ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                                throw ex_ret;
                            }
                            token = null;
                            if (dbRecord.columnSet().contains(lastToken)) {
                                paramList.add(lastToken);
                                Integer type = (Integer)paramTypeMap.get(lastToken);
                                columnType = new Integer(DBUtil.getColumnType(type));
                                typeList.add(columnType);
                                buff.append(tempString);
                                buff.append("?");
                                tempString = "";
                                firstSet = false;
                            } else {
                                tempString = "";
                            }
                        }
                    } else if (PARAMETER_TOKEN.equals(lastToken)) {
                        if (PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_param_null");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        if (0 == token.trim().length()) {
                            DBException ex_ret = new DBException("parse_sql_param_invalid");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        paramList.add(token.trim());
                        Integer type = (Integer)paramTypeMap.get(lastToken);
                        columnType = new Integer(DBUtil.getColumnType(type));
                        typeList.add(columnType);
                        buff.append("?");
                        token = parser.nextToken();
                        if (!PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_unterminated");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        token = null;
                    } else if (!PARAMETER_TOKEN.equals(token)) {
                        buff.append(token);
                    }
                }
                lastToken = token;
            }
            if (clause == VALUES) {
                while (!fieldsList.isEmpty()) {
                    buff.append((String)fieldsList.remove(0));
                }
            }
        } else {
            String tableName = null;
            while (parser.hasMoreTokens()) {
                Integer columnType;
                token = parser.nextToken();
                if (clause == 0) {
                    if (token.equals("from")) {
                        clause = FROM;
                    } else if (token.equals("into")) {
                        clause = INSERT;
                    } else if (token.equals("update")) {
                        clause = UPDATE;
                    }
                    buff.append(token);
                } else if (token.equals("where")) {
                    buff.append(token);
                    clause = WHERE;
                } else if (clause == WHERE) {
                    if (!PARAMETER_TOKEN.equals(token)) {
                        if (!firstWhere || !token.equals("and") && !token.equals("or")) {
                            fieldsList.add(token);
                        }
                    } else {
                        token = parser.nextToken();
                        if (PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_param_null");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        lastToken = token;
                        token = parser.nextToken();
                        if (!PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_unterminated");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        token = null;
                        if (dbRecord.columnSet().contains(lastToken)) {
                            paramList.add(lastToken);
                            while (!fieldsList.isEmpty()) {
                                String tempItem = (String)fieldsList.remove(0);
                                buff.append(tempItem);
                                if (tempItem.equals(" ") || tempItem.equals("=") || tempItem.equals("<") || tempItem.equals(">") || tempItem.equals("<>") || tempItem.equals(">=") || tempItem.equals("<=") || tempItem.equals("like")) continue;
                                columnType = new Integer(this.getFieldType(tableName, tempItem));
                                typeList.add(columnType);
                            }
                            buff.append("?");
                            firstWhere = false;
                        }
                        fieldsList = new ArrayList();
                    }
                } else if (clause == FROM) {
                    buff.append(token);
                    if (!token.equals(" ")) {
                        tableName = token;
                    }
                } else if (clause == INSERT) {
                    if (isFields) {
                        fieldsList.add(token);
                        if (token.equals("values")) {
                            clause = VALUES;
                        }
                    } else {
                        buff.append(token);
                        if (!token.equals(" ")) {
                            if (token.equals("(")) {
                                isFields = true;
                            } else {
                                tableName = token;
                            }
                        }
                    }
                } else if (clause == VALUES) {
                    if (!PARAMETER_TOKEN.equals(token)) {
                        fieldsList.add(token);
                    } else {
                        Integer columnType2;
                        String tempField;
                        String tempItem;
                        token = parser.nextToken();
                        if (PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_param_null");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        lastToken = token;
                        token = parser.nextToken();
                        if (!PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_unterminated");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        token = null;
                        boolean havePara = false;
                        if (dbRecord.columnSet().contains(lastToken)) {
                            paramList.add(lastToken);
                            if (firstValues) {
                                while ((tempItem = (String)fieldsList.remove(fieldsList.size() - 1)).equals(" ")) {
                                }
                                if (!tempItem.equals(",")) {
                                    fieldsList.add(tempItem);
                                }
                            }
                            fieldsList.add("?");
                            havePara = true;
                        } else {
                            while ((tempItem = (String)fieldsList.remove(fieldsList.size() - 1)).equals(" ")) {
                            }
                            if (!tempItem.equals(",")) {
                                fieldsList.add(tempItem);
                            }
                        }
                        if (firstValues) {
                            while (((String)fieldsList.get(0)).equals(" ") || ((String)fieldsList.get(0)).equals(",")) {
                                tempField = (String)fieldsList.remove(0);
                            }
                            tempField = (String)fieldsList.remove(0);
                            if (havePara) {
                                buff.append(tempField);
                                columnType2 = new Integer(this.getFieldType(tableName, tempField));
                                typeList.add(columnType2);
                                firstValues = false;
                            }
                        } else {
                            while (((String)fieldsList.get(0)).equals(" ") || ((String)fieldsList.get(0)).equals(",")) {
                                tempField = (String)fieldsList.remove(0);
                                if (!havePara) continue;
                                buff.append(tempField);
                            }
                            tempField = (String)fieldsList.remove(0);
                            if (havePara) {
                                buff.append(tempField);
                                columnType2 = new Integer(this.getFieldType(tableName, tempField));
                                typeList.add(columnType2);
                            }
                        }
                    }
                } else if (clause == UPDATE) {
                    buff.append(token);
                    if (token.equals("set")) {
                        clause = SET;
                        fieldsList = new ArrayList();
                    } else if (!token.equals(" ")) {
                        tableName = token;
                    }
                } else if (clause == SET) {
                    if (!PARAMETER_TOKEN.equals(token)) {
                        if (!firstSet || !token.equals(",")) {
                            fieldsList.add(token);
                        }
                    } else {
                        token = parser.nextToken();
                        if (PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_param_null");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        lastToken = token;
                        token = parser.nextToken();
                        if (!PARAMETER_TOKEN.equals(token)) {
                            DBException ex_ret = new DBException("parse_sql_unterminated");
                            ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                            throw ex_ret;
                        }
                        token = null;
                        if (dbRecord.columnSet().contains(lastToken)) {
                            paramList.add(lastToken);
                            while (!fieldsList.isEmpty()) {
                                String tempField = (String)fieldsList.remove(0);
                                buff.append(tempField);
                                if (tempField.equals(" ") || tempField.equals("=") || tempField.equals(",")) continue;
                                columnType = new Integer(this.getFieldType(tableName, tempField));
                                typeList.add(columnType);
                            }
                            buff.append("?");
                            buff.append(" ");
                            firstSet = false;
                        }
                        fieldsList = new ArrayList();
                    }
                }
                lastToken = token;
            }
            if (clause == VALUES) {
                while (!fieldsList.isEmpty()) {
                    buff.append((String)fieldsList.remove(0));
                }
            }
        }
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(paramList.toArray(new String[paramList.size()]));
        sqlText.setTypes(typeList.toArray(new Integer[typeList.size()]));
        return sqlText;
    }

    public SQLText parseSQLStatic(String sqlStatement, Map paramTypeMap) {
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        String token = null;
        String lastToken = null;
        StringBuffer buff = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(sqlStatement, "# ,()", true);
        int clause = 0;
        int INSERT = 1;
        int FROM = 2;
        int UPDATE = 3;
        int SET = 4;
        int WHERE = 5;
        int BRACKET = 6;
        if (paramTypeMap != null) {
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                if (PARAMETER_TOKEN.equals(lastToken)) {
                    DBException ex_ret;
                    if (PARAMETER_TOKEN.equals(token)) {
                        ex_ret = new DBException("parse_sql_param_null");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    if (0 == token.trim().length()) {
                        ex_ret = new DBException("parse_sql_param_invalid");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    paramList.add(token.trim());
                    Integer type = (Integer)paramTypeMap.get(token);
                    Integer columnType = new Integer(DBUtil.getColumnType(type));
                    typeList.add(columnType);
                    buff.append("?");
                    token = parser.nextToken();
                    if (!PARAMETER_TOKEN.equals(token)) {
                        DBException ex_ret2 = new DBException("parse_sql_unterminated");
                        ex_ret2.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret2;
                    }
                    token = null;
                } else if (!PARAMETER_TOKEN.equals(token)) {
                    buff.append(token);
                }
                lastToken = token;
            }
        } else {
            HashMap fieldTypeMap = new HashMap();
            String tableName = null;
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                if (PARAMETER_TOKEN.equals(lastToken)) {
                    DBException ex_ret;
                    if (PARAMETER_TOKEN.equals(token)) {
                        ex_ret = new DBException("parse_sql_param_null");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    if (0 == token.trim().length()) {
                        ex_ret = new DBException("parse_sql_param_invalid");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    paramList.add(token.trim());
                    buff.append("?");
                    token = parser.nextToken();
                    if (!PARAMETER_TOKEN.equals(token)) {
                        ex_ret = new DBException("parse_sql_unterminated");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    token = null;
                } else if (!PARAMETER_TOKEN.equals(token)) {
                    Integer columnType;
                    buff.append(token);
                    if (clause == 0) {
                        if (token.equals("from")) {
                            clause = FROM;
                            continue;
                        }
                        if (token.equals("into")) {
                            clause = INSERT;
                            continue;
                        }
                        if (!token.equals("update")) continue;
                        clause = UPDATE;
                        continue;
                    }
                    if (clause == FROM) {
                        if (token.equals(" ")) continue;
                        if (!token.equals("where")) {
                            tableName = token;
                            continue;
                        }
                        clause = WHERE;
                        continue;
                    }
                    if (clause == INSERT) {
                        if (token.equals(" ")) continue;
                        if (!token.equals("(")) {
                            tableName = token;
                            continue;
                        }
                        clause = BRACKET;
                        continue;
                    }
                    if (clause == UPDATE) {
                        if (token.equals(" ")) continue;
                        if (!token.equals("set")) {
                            tableName = token;
                            continue;
                        }
                        clause = SET;
                        continue;
                    }
                    if (clause == BRACKET) {
                        if (token.equals(" ") || token.equals(",")) continue;
                        if (token.equals(")")) {
                            clause = 0;
                            continue;
                        }
                        columnType = new Integer(this.getFieldType(tableName, token));
                        typeList.add(columnType);
                        continue;
                    }
                    if (clause == SET) {
                        if (token.equals(" ") || token.equals("=") || token.equals(",") || token.equals("set")) continue;
                        if (token.equals("where")) {
                            clause = WHERE;
                            continue;
                        }
                        columnType = new Integer(this.getFieldType(tableName, token));
                        typeList.add(columnType);
                        continue;
                    }
                    if (clause == WHERE) {
                        if (token.equals(" ") || token.equals("and") || token.equals("or") || token.equals(",") || token.equals("<>") || token.equals(">") || token.equals("<") || token.equals(">=") || token.equals("<=") || token.equals("like") || token.equals("between") || token.equals("in")) continue;
                        columnType = new Integer(this.getFieldType(tableName, token));
                        typeList.add(columnType);
                        continue;
                    }
                }
                lastToken = token;
            }
        }
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(paramList.toArray(new String[paramList.size()]));
        sqlText.setTypes(typeList.toArray(new Integer[typeList.size()]));
        return sqlText;
    }

    static boolean isDynamic(String sqlStatement, DBRecord dbRecord) {
        int paramCount = 0;
        StringTokenizer parser = new StringTokenizer(sqlStatement, PARAMETER_TOKEN, true);
        while (parser.hasMoreTokens()) {
            if (!PARAMETER_TOKEN.equals(parser.nextToken())) continue;
            ++paramCount;
        }
        return dbRecord.columnSet().size() != paramCount / 2;
    }

    public int getFieldType(String tableName, String fieldName) {
        Map fieldTypes = this.dbMeta.getFieldTypeMap(tableName);
        if (!fieldTypes.containsKey(fieldName)) {
            return 0;
        }
        Integer type = (Integer)fieldTypes.get(fieldName);
        return DBUtil.getColumnType(type);
    }

    public SQLText parseProc(String sqlStatement, Map paramTypeMap) {
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        String token = null;
        String lastToken = null;
        StringBuffer buff = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(sqlStatement, "# ,()={[]}", true);
        if (paramTypeMap != null) {
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                if (PARAMETER_TOKEN.equals(lastToken)) {
                    DBException ex_ret;
                    if (PARAMETER_TOKEN.equals(token)) {
                        ex_ret = new DBException("parse_sql_param_null");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    if (0 == token.trim().length()) {
                        ex_ret = new DBException("parse_sql_param_invalid");
                        ex_ret.addScene("SQL_STATEMENT", sqlStatement);
                        throw ex_ret;
                    }
                    paramList.add(token.trim());
                    Integer type = new Integer((String)paramTypeMap.get(token));
                    Integer columnType = new Integer(DBUtil.getColumnType(type));
                    typeList.add(columnType);
                    buff.append("?");
                    lastToken = token;
                    token = parser.nextToken();
                    if (PARAMETER_TOKEN.equals(token)) continue;
                    DBException ex_ret2 = new DBException("parse_sql_unterminated");
                    ex_ret2.addScene("SQL_STATEMENT", sqlStatement);
                    throw ex_ret2;
                }
                if (!PARAMETER_TOKEN.equals(token)) {
                    buff.append(token);
                }
                lastToken = token;
            }
        }
        SQLText sqlText = new SQLText();
        sqlText.setSql(buff.toString());
        sqlText.setFields(paramList.toArray(new String[paramList.size()]));
        sqlText.setTypes(typeList.toArray(new Integer[typeList.size()]));
        return sqlText;
    }

    private class MyParser {
        private MyParser() {
        }

        public String toString(StringTokenizer parser, DBRecord dbRecord, Map paramTypeMap, List paramList, List typeList) {
            StringBuffer sb = new StringBuffer();
            Stack s = this.calc(parser, dbRecord, paramTypeMap, paramList, typeList);
            String[] res = s.toArray(new String[s.size()]);
            for (int i = 0; i < res.length; ++i) {
                sb.append(res[i]).append(" ");
            }
            return sb.toString();
        }

        private Stack calc(StringTokenizer parser, DBRecord dbRecord, Map paramTypeMap, List paramList, List typeList) {
            Stack<String> s = new Stack<String>();
            String token = null;
            int cause = -1;
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                if (token.equals(SQLParser.PARAMETER_TOKEN)) {
                    DBException ex_ret;
                    token = parser.nextToken();
                    if (token.equals(SQLParser.PARAMETER_TOKEN)) {
                        ex_ret = new DBException("parse_sql_param_null");
                        ex_ret.addScene("SQL_STATEMENT", parser.toString());
                        throw ex_ret;
                    }
                    if (dbRecord.columnSet().contains(token)) {
                        paramList.add(token);
                        Integer type = (Integer)paramTypeMap.get(token);
                        Integer columnType = new Integer(DBUtil.getColumnType(type));
                        typeList.add(columnType);
                        s.push("?");
                    } else {
                        this.pop(s);
                    }
                    if ((token = parser.nextToken()).equals(SQLParser.PARAMETER_TOKEN)) continue;
                    ex_ret = new DBException("parse_sql_unterminated");
                    ex_ret.addScene("SQL_STATEMENT", parser.toString());
                    throw ex_ret;
                }
                if (" ".equals(token)) continue;
                if ("and".equals(token) || "or".equals(token)) {
                    if (s.size() == 0) continue;
                    s.push(token);
                    continue;
                }
                if (",".equals(token)) {
                    if (s.size() == 0 || "(".equals((String)s.peek())) continue;
                    s.push(token);
                    continue;
                }
                s.push(token);
            }
            return s;
        }

        private void pop(Stack s) {
            if ("=".equals((String)s.peek())) {
                s.pop();
                s.pop();
            } else if (!"(".equals((String)s.peek())) {
                s.pop();
            }
            if (s.size() > 0 && ("and".equals((String)s.peek()) || "or".equals((String)s.peek()))) {
                s.pop();
            }
        }
    }
}

