/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.db.DBException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultMetaData {
    private static Log log = LogFactory.getLog((Class)ResultMetaData.class);
    private static Map columnCache = new HashMap(101);
    private static Map fieldTypeCache = new HashMap(101);

    private ResultMetaData() {
    }

    public static synchronized List getcolumnList(ResultSet rs, String id) {
        ArrayList<String> list = (ArrayList<String>)columnCache.get(id);
        if (list != null) {
            return list;
        }
        ResultSetMetaData rsmd = null;
        try {
            rsmd = rs.getMetaData();
            list = new ArrayList<String>();
            int count = rsmd.getColumnCount();
            for (int i = 0; i < count; ++i) {
                list.add(rsmd.getColumnName(i + 1));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SQL_TEMPLATE:" + id));
                log.debug((Object)("column_in_result:" + ((Object)list).toString()));
            }
            columnCache.put(id, list);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u53d6\u7ed3\u679c\u96c6\u5b57\u6bb5\u5217\u8868\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            throw new DBException("get_result_column_list_exception", e);
        }
    }

    public static synchronized Map getfieldTypeMap(ResultSet rs, String id) {
        HashMap<String, Integer> map = (HashMap<String, Integer>)fieldTypeCache.get(id);
        if (map != null) {
            return map;
        }
        ResultSetMetaData rsmd = null;
        try {
            rsmd = rs.getMetaData();
            map = new HashMap<String, Integer>();
            int count = rsmd.getColumnCount();
            for (int i = 0; i < count; ++i) {
                map.put(rsmd.getColumnName(i + 1), new Integer(rsmd.getColumnType(i + 1)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("column_count:" + count));
                log.debug((Object)("SQL_TEMPLATE:" + id));
                log.debug((Object)("column/type:" + ((Object)map).toString()));
            }
            fieldTypeCache.put(id, map);
            HashMap<String, Integer> hashMap = map;
            return hashMap;
        }
        catch (SQLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u53d6\u7ed3\u679c\u96c6\u5b57\u6bb5\u7c7b\u578b\u6620\u5c04\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            throw new DBException("get_result_field_type_map_exception", e);
        }
    }
}

