/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBSql;
import com.dc.db.PageRecords;
import com.dc.db.SQLText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageRecordsStaticImpl
implements PageRecords {
    private Log log = LogFactory.getLog((Class)PageRecordsStaticImpl.class);
    private DBSql dbSql;
    private int pageSize;
    private int index;
    private DBRecord dbRecord;
    private int totalPages;
    private String id;
    private SQLText sqlText;
    private DBRecordSet prevPage;
    private DBRecordSet currentPage;
    private DBRecordSet nextPage;

    public PageRecordsStaticImpl(String id, DBRecord dbRecord, int pageSize, SQLText sqlText, DBSql dbSql) {
        this.dbSql = dbSql;
        this.dbRecord = dbRecord;
        this.id = id;
        this.pageSize = pageSize;
        this.sqlText = sqlText;
        this.index = 0;
        this.pageTo(0);
        int totalRecords = dbSql.countRecordsStatic(id, dbRecord);
        this.totalPages = totalRecords % pageSize == 0 ? totalRecords / pageSize : totalRecords / pageSize + 1;
    }

    private DBRecordSet getResults(int idx, int localPageSize) {
        return this.dbSql.queryRecordsStatic(this.id, this.dbRecord, idx * this.pageSize, localPageSize);
    }

    private void pageTo(int idx) {
        this.index = idx;
        DBRecordSet results = idx < 1 ? this.getResults(idx, this.pageSize) : (idx < 2 ? this.getResults(idx - 1, this.pageSize * 2) : this.getResults(idx - 2, this.pageSize * 3));
        if (results.size() < 1) {
            this.prevPage = new DBRecordSet();
            this.currentPage = new DBRecordSet();
            this.nextPage = new DBRecordSet();
        } else if (idx < 1) {
            this.prevPage = new DBRecordSet();
            this.currentPage = new DBRecordSet();
            this.nextPage = results.subRecordSet(0, results.size());
        } else if (idx < 2) {
            if (results.size() <= this.pageSize) {
                this.prevPage = new DBRecordSet();
                this.currentPage = results.subRecordSet(0, results.size());
                this.nextPage = new DBRecordSet();
            } else {
                this.prevPage = new DBRecordSet();
                this.currentPage = results.subRecordSet(0, this.pageSize);
                this.nextPage = results.subRecordSet(this.pageSize, results.size());
            }
        } else if (results.size() <= this.pageSize) {
            this.prevPage = results.subRecordSet(0, results.size());
            this.currentPage = new DBRecordSet();
            this.nextPage = new DBRecordSet();
        } else if (results.size() <= this.pageSize * 2) {
            this.prevPage = results.subRecordSet(0, this.pageSize);
            this.currentPage = results.subRecordSet(this.pageSize, results.size());
            this.nextPage = new DBRecordSet();
        } else {
            this.prevPage = results.subRecordSet(0, this.pageSize);
            this.currentPage = results.subRecordSet(this.pageSize, this.pageSize * 2);
            this.nextPage = results.subRecordSet(this.pageSize * 2, results.size());
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int currentPageIndex() {
        return this.index;
    }

    public boolean isFirstPage() {
        return this.index == 0;
    }

    public boolean isLastPage() {
        return this.nextPage.size() < 1;
    }

    public boolean hasNextPage() {
        return this.nextPage.size() > 0;
    }

    public boolean hasPrevPage() {
        return this.prevPage.size() > 0;
    }

    public DBRecordSet nextPage() {
        if (this.hasNextPage()) {
            ++this.index;
            this.prevPage = this.currentPage;
            this.currentPage = this.nextPage;
            this.nextPage = this.getResults(this.index, this.pageSize);
        }
        return this.currentPage;
    }

    public DBRecordSet prevPage() {
        if (this.hasPrevPage()) {
            --this.index;
            this.nextPage = this.currentPage;
            this.currentPage = this.prevPage;
            this.prevPage = this.index > 1 ? this.getResults(this.index - 2, this.pageSize) : new DBRecordSet();
        }
        return this.currentPage;
    }

    public DBRecordSet gotoPage(int i) {
        if (i < 1) {
            i = 1;
        } else if (i > this.totalPages) {
            i = this.totalPages;
        }
        this.pageTo(i);
        return this.currentPage;
    }
}

