/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.db.DBMetaData;
import com.dc.db.SQLParser;
import com.dc.db.SQLTemplate;
import java.util.HashMap;
import java.util.Map;

public class MultiDBHelper {
    private static Map metadatas = new HashMap(5);
    private static Map templates = new HashMap(5);
    private static Map parsers = new HashMap(5);

    public static synchronized DBMetaData getDBMetaData(String dbName) {
        if (dbName == null) {
            return null;
        }
        DBMetaData md = (DBMetaData)metadatas.get(dbName);
        if (md == null && dbName != null) {
            md = new DBMetaData(dbName);
            metadatas.put(dbName, md);
        }
        return md;
    }

    public static void add(String dbName, SQLTemplate t) {
        HashMap<String, SQLTemplate> m = (HashMap<String, SQLTemplate>)templates.get(dbName);
        if (m == null) {
            m = new HashMap<String, SQLTemplate>(101);
            templates.put(dbName, m);
        }
        m.put(t.id, t);
    }

    public static SQLTemplate getTemplate(String dbName, String templName) {
        return (SQLTemplate)((Map)templates.get(dbName)).get(templName);
    }

    public static SQLParser getParser(String dbName) {
        SQLParser parser = (SQLParser)parsers.get(dbName);
        if (parser == null) {
            parser = new SQLParser(MultiDBHelper.getDBMetaData(dbName));
            parsers.put(dbName, parser);
        }
        return parser;
    }
}

