/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.datastore.DataStore;
import com.dc.db.DBRecord;
import com.dc.db.ResultMetaData;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUtil {
    private static Log log = LogFactory.getLog((Class)DBUtil.class);
    public static final int UNKNOWN_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int LONG_TYPE = 2;
    public static final int DOUBLE_TYPE = 3;
    public static final int STRING_TYPE = 4;
    public static final int BYTES_TYPE = 5;
    public static final int DATE_TYPE = 6;
    public static final int TIME_TYPE = 7;
    public static final int DATETIME_TYPE = 8;
    public static final int BLOB = 9;

    private DBUtil() {
    }

    public static int getFieldType(ResultSet rs, String id, String fieldName) {
        Map fieldTypes = ResultMetaData.getfieldTypeMap(rs, id);
        if (!fieldTypes.containsKey(fieldName)) {
            return 0;
        }
        Integer type = (Integer)fieldTypes.get(fieldName);
        return DBUtil.getColumnType(type);
    }

    public static int getColumnType(Integer type) {
        if (type == null) {
            return 0;
        }
        int sqlType = type;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return 4;
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return 1;
            }
            case -5: {
                return 2;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 91: {
                return 6;
            }
            case 92: {
                return 7;
            }
            case 93: {
                return 8;
            }
            case -4: 
            case -3: 
            case -2: {
                return 5;
            }
            case 2004: {
                return 9;
            }
        }
        return 0;
    }

    public static void setParameter(PreparedStatement stmt, int index, int type, DBRecord dbRecord, String fieldName) throws SQLException {
        if (dbRecord.getString(fieldName) == null) {
            if (type == 1) {
                stmt.setNull(index, 4);
            } else if (type == 2) {
                stmt.setNull(index, -5);
            } else if (type == 3) {
                stmt.setNull(index, 8);
            } else if (type == 5) {
                stmt.setBytes(index, null);
            } else if (type == 6) {
                stmt.setNull(index, 91);
            } else if (type == 7) {
                stmt.setTime(index, null);
            } else if (type == 8) {
                stmt.setTimestamp(index, null);
            } else if (type == 9) {
                stmt.setBytes(index, null);
            } else {
                stmt.setString(index, null);
            }
            return;
        }
        if (type == 1) {
            stmt.setInt(index, dbRecord.getInt(fieldName));
        } else if (type == 2) {
            stmt.setLong(index, dbRecord.getLong(fieldName));
        } else if (type == 3) {
            stmt.setDouble(index, dbRecord.getDouble(fieldName));
        } else if (type == 5) {
            stmt.setBytes(index, dbRecord.getBytes(fieldName));
        } else if (type == 6) {
            try {
                String strDBRecord = dbRecord.getString(fieldName);
                if (strDBRecord.indexOf(":") < 0) {
                    strDBRecord = strDBRecord + " 00:00:00.000";
                }
                stmt.setTimestamp(index, Timestamp.valueOf(strDBRecord));
            }
            catch (Exception e) {
                log.error((Object)"\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25\uff01");
                throw new SQLException("" + e);
            }
        } else if (type == 7) {
            stmt.setTime(index, Time.valueOf(dbRecord.getString(fieldName)));
        } else if (type == 8) {
            try {
                String strDBRecord = dbRecord.getString(fieldName);
                if (strDBRecord.indexOf(":") < 0) {
                    strDBRecord = strDBRecord + " 00:00:00.000";
                }
                stmt.setTimestamp(index, Timestamp.valueOf(strDBRecord));
            }
            catch (Exception e) {
                log.error((Object)"\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25\uff01");
                throw new SQLException("" + e);
            }
        } else if (type == 9) {
            stmt.setBytes(index, dbRecord.getBytes(fieldName));
        } else {
            stmt.setString(index, dbRecord.getString(fieldName));
        }
    }

    public static void getFieldValue(ResultSet rs, String fieldName, int type, DBRecord dbRecord) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFieldValue: fieldName:" + fieldName + ", type=" + type));
        }
        try {
            switch (type) {
                case 5: {
                    dbRecord.setBytes(fieldName, rs.getBytes(fieldName));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    dbRecord.setString(fieldName, rs.getString(fieldName));
                    break;
                }
                case 9: {
                    if (rs.getBlob(fieldName) != null) {
                        int i = (int)rs.getBlob(fieldName).length();
                        byte[] bt = new byte[i];
                        rs.getBlob(fieldName).getBinaryStream().read(bt);
                        dbRecord.setBytes(fieldName, bt);
                        break;
                    }
                    byte[] bt = new byte[]{};
                    dbRecord.setBytes(fieldName, bt);
                    break;
                }
                case 6: {
                    if (rs.getDate(fieldName) != null) {
                        dbRecord.setString(fieldName, rs.getDate(fieldName).toString());
                        break;
                    }
                    dbRecord.setString(fieldName, null);
                    break;
                }
                case 8: {
                    if (rs.getTimestamp(fieldName) != null) {
                        dbRecord.setString(fieldName, rs.getTimestamp(fieldName).toString());
                        break;
                    }
                    dbRecord.setString(fieldName, null);
                    break;
                }
                case 7: {
                    if (rs.getTime(fieldName) != null) {
                        dbRecord.setString(fieldName, rs.getTime(fieldName).toString());
                        break;
                    }
                    dbRecord.setString(fieldName, null);
                    break;
                }
                default: {
                    dbRecord.setString(fieldName, rs.getString(fieldName));
                    break;
                }
            }
        }
        catch (SQLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Exception occured when fetching value from: " + fieldName));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void closeDataStore(DataStore ds) {
        if (ds != null) {
            ds.close();
        }
    }

    public static void closeConnection(Connection conn) {
        block3: {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"\u5173\u95edConnection\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static void closeStatement(PreparedStatement ps) {
        block3: {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"\u5173\u95edPreparedStatement\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
    }
}

