/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBException;
import com.dc.db.DBMetaData;
import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBUtil;
import com.dc.db.MultiDBHelper;
import com.dc.db.PKHandler;
import com.dc.db.SQLParser;
import com.dc.db.SQLText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBTable {
    private String dbName;
    private Connection conn;
    private DBMetaData dbMeta;
    private SQLParser parser;
    private static Log log = LogFactory.getLog((Class)DBTable.class);
    private static final String OPERATION_INSERT = "insert";
    private static final String OPERATION_UPDATE = "update";
    private static final String OPERATION_DELETE = "delete";

    private DBTable(String dbName) {
        this.dbName = dbName;
        this.conn = DataStoreMan.getInstance().getDataStore(dbName).getConnection();
        this.dbMeta = MultiDBHelper.getDBMetaData(dbName);
        this.parser = MultiDBHelper.getParser(dbName);
    }

    public static DBTable getInstance(String dbName) {
        DBTable dt = new DBTable(dbName);
        dt.dbName = dbName;
        return dt;
    }

    public int insert(String tableName, DBRecord dbRecord) throws DBException {
        return this.executeUpdate(tableName, dbRecord, OPERATION_INSERT);
    }

    public int insert(String tableName, DBRecordSet dbRecords) throws DBException {
        return this.executeUpdate(tableName, dbRecords, OPERATION_INSERT);
    }

    public int insert(String tableName, DBRecord dbRecord, PKHandler pKHandler) throws DBException {
        pKHandler.genPK(tableName, dbRecord);
        return this.executeUpdate(tableName, dbRecord, OPERATION_INSERT);
    }

    public int insert(String tableName, DBRecordSet dbRecords, PKHandler pKHandler) throws DBException {
        if (dbRecords == null || dbRecords.size() == 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8bb0\u5f55\u9700\u8981\u63d2\u5165");
            }
            throw new DBException("null_or_empty_dbrecordset");
        }
        pKHandler.genPK(tableName, dbRecords.getRow(0));
        SQLText sqlText = this.parser.getInsertSql(tableName, dbRecords.getRow(0));
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            ps.clearParameters();
            for (int row = 0; row < dbRecords.size(); ++row) {
                if (row > 0) {
                    pKHandler.genPK(tableName, dbRecords.getRow(row));
                }
                DBRecord dbRecord = dbRecords.getRow(row);
                for (int i = 0; i < param.length; ++i) {
                    int type = this.parser.getFieldType(tableName, param[i]);
                    DBUtil.setParameter(ps, i + 1, type, dbRecord, param[i]);
                }
                ret += ps.executeUpdate();
            }
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884c\u63d2\u5165\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("dbtable_insert_sqlexception", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeStatement(ps);
        return ret;
    }

    public int delete(String tableName, DBRecord dbRecord) throws DBException {
        return this.executeUpdate(tableName, dbRecord, OPERATION_DELETE);
    }

    public int delete(String tableName, DBRecordSet dbRecords) throws DBException {
        return this.executeUpdate(tableName, dbRecords, OPERATION_DELETE);
    }

    public int update(String tableName, DBRecord dbRecord) throws DBException {
        return this.executeUpdate(tableName, dbRecord, OPERATION_UPDATE);
    }

    public int update(String tableName, DBRecordSet dbRecords) throws DBException {
        return this.executeUpdate(tableName, dbRecords, OPERATION_UPDATE);
    }

    private int executeUpdate(String tableName, DBRecord dbRecord, String operation) throws DBException {
        SQLText sqlText = null;
        sqlText = operation.equalsIgnoreCase(OPERATION_INSERT) ? this.parser.getInsertSql(tableName, dbRecord) : (operation.equalsIgnoreCase(OPERATION_UPDATE) ? this.parser.getUpdateSql(tableName, dbRecord) : this.parser.getDeleteSql(tableName, dbRecord));
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                int type = this.parser.getFieldType(tableName, param[i]);
                DBUtil.setParameter(ps, i + 1, type, dbRecord, param[i]);
            }
            ret = ps.executeUpdate();
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)("\u6267\u884c" + operation + "\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e1);
            }
            DBException e_ret = this.generateDBException(tableName, dbRecord, "dbtable_" + operation + "_sqlexception", (Exception)e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return ret;
    }

    private int executeUpdate(String tableName, DBRecordSet dbRecords, String operation) throws DBException {
        if (dbRecords == null || dbRecords.size() == 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8bb0\u5f55\u9700\u8981" + operation + "\u64cd\u4f5c"));
            }
            throw new DBException("null_or_empty_dbrecordset");
        }
        SQLText sqlText = null;
        sqlText = operation.equalsIgnoreCase(OPERATION_INSERT) ? this.parser.getInsertSql(tableName, dbRecords.getRow(0)) : (operation.equalsIgnoreCase(OPERATION_UPDATE) ? this.parser.getUpdateSql(tableName, dbRecords.getRow(0)) : this.parser.getDeleteSql(tableName, dbRecords.getRow(0)));
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            ps.clearParameters();
            for (int row = 0; row < dbRecords.size(); ++row) {
                DBRecord dbRecord = dbRecords.getRow(row);
                for (int i = 0; i < param.length; ++i) {
                    int type = this.parser.getFieldType(tableName, param[i]);
                    DBUtil.setParameter(ps, i + 1, type, dbRecord, param[i]);
                }
                ret += ps.executeUpdate();
            }
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)("\u6267\u884c" + operation + "\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e1);
            }
            DBException e_ret = this.generateDBException(tableName, dbRecords, "dbtable_" + operation + "_sqlexception", (Exception)e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return ret;
    }

    public DBRecord queryByPK(String tableName, DBRecord dbRecord) throws DBException {
        DBRecord result;
        ResultSet rs;
        PreparedStatement ps;
        block10: {
            DBRecord i;
            List columnList = MultiDBHelper.getDBMetaData(this.dbName).getcolumnList(tableName);
            SQLText sqlText = this.parser.getSelectSql(tableName, dbRecord);
            String sql = sqlText.getSql();
            String[] param = sqlText.getFields();
            if (log.isDebugEnabled()) {
                log.debug((Object)("sql=[" + sql + "]"));
                for (int i2 = 0; i2 < param.length; ++i2) {
                    log.debug((Object)("param[" + i2 + "]:" + param[i2]));
                }
            }
            ps = null;
            rs = null;
            result = new DBRecord();
            try {
                int i3;
                ps = this.conn.prepareStatement(sql);
                for (i3 = 0; i3 < param.length; ++i3) {
                    int type = this.parser.getFieldType(tableName, param[i3]);
                    DBUtil.setParameter(ps, i3 + 1, type, dbRecord, param[i3]);
                }
                rs = ps.executeQuery();
                if (rs.next()) {
                    for (i3 = 0; i3 < columnList.size(); ++i3) {
                        String fieldName = (String)columnList.get(i3);
                        int type = this.parser.getFieldType(tableName, fieldName);
                        DBUtil.getFieldValue(rs, fieldName, type, result);
                    }
                    break block10;
                }
                i = null;
            }
            catch (SQLException e1) {
                try {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u6267\u884c\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    }
                    DBException e_ret = this.generateDBException(tableName, dbRecord, "dbtable_select_sqlexception", (Exception)e1);
                    e_ret.addScene("SQL", sql);
                    throw e_ret;
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs);
                    DBUtil.closeStatement(ps);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
            return i;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return result;
    }

    private DBException generateDBException(String tableName, DBRecord dbRecord, String errCode, Exception e) {
        DBException ex = new DBException(errCode, e);
        ex.addScene("TableName", tableName);
        ex.addScene("DBRecord", dbRecord.toString());
        return ex;
    }

    private DBException generateDBException(String tableName, DBRecordSet dbRecords, String errCode, Exception e) {
        DBException ex = new DBException(errCode, e);
        ex.addScene("TableName", tableName);
        ex.addScene("DBRecordSet", dbRecords.toString());
        return ex;
    }
}

