/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.datastore.DataStore;
import com.dc.datastore.DataStoreMan;
import com.dc.db.DBException;
import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBUtil;
import com.dc.db.MultiDBHelper;
import com.dc.db.PageRecords;
import com.dc.db.PageRecordsDynamicImpl;
import com.dc.db.PageRecordsStaticImpl;
import com.dc.db.ResultMetaData;
import com.dc.db.SQLParser;
import com.dc.db.SQLTemplate;
import com.dc.db.SQLText;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBSql {
    private String dbName;
    private Connection conn;
    private SQLParser parser;
    private static Log log = LogFactory.getLog((Class)DBSql.class);
    public static final int NO_SKIPPED_RESULTS = 0;
    public static final int NO_MAXIMUM_RESULTS = -999999;

    private DBSql(String dbName) {
        this.dbName = dbName;
        this.conn = DataStoreMan.getInstance().getDataStore(dbName).getConnection();
        this.parser = MultiDBHelper.getParser(dbName);
    }

    private DataStore getDataStore() {
        return DataStoreMan.getInstance().getDataStore(this.dbName);
    }

    public static DBSql getInstance(String dbName) {
        return new DBSql(dbName);
    }

    public DBRecord query(String id, DBRecord dbRecord) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        if (SQLParser.isDynamic(originalSql, dbRecord)) {
            return this.queryDynamic(id, dbRecord);
        }
        return this.queryStatic(id, dbRecord);
    }

    public DBRecordSet queryRecords(String id, DBRecord dbRecord) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        if (SQLParser.isDynamic(originalSql, dbRecord)) {
            return this.queryRecordsDynamic(id, dbRecord);
        }
        return this.queryRecordsStatic(id, dbRecord);
    }

    public PageRecords queryPageRecords(String id, DBRecord dbRecord, int rowsPerPage) {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        if (SQLParser.isDynamic(originalSql, dbRecord)) {
            return this.queryPageRecordsDynamic(id, dbRecord, rowsPerPage);
        }
        return this.queryPageRecordsStatic(id, dbRecord, rowsPerPage);
    }

    public int execute(String id, DBRecord dbRecord) {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        if (SQLParser.isDynamic(originalSql, dbRecord)) {
            return this.executeDynamic(id, dbRecord);
        }
        return this.executeStatic(id, dbRecord);
    }

    private DBRecord queryDynamic(String id, DBRecord dbRecord) throws DBException {
        DBRecord result;
        ResultSet rs;
        PreparedStatement ps;
        block10: {
            DBRecord columnList2;
            SQLText sqlText = null;
            SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
            String originalSql = sqlTemplate.getSql();
            Map paramTypeMap = sqlTemplate.getParamTypeMap();
            sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
            String sql = sqlText.getSql();
            String[] param = sqlText.getFields();
            int[] type = sqlText.getTypes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("sql=[" + sql + "]"));
                for (int i = 0; i < param.length; ++i) {
                    log.debug((Object)("param[" + i + "]:" + param[i]));
                }
            }
            ps = null;
            rs = null;
            result = null;
            boolean ret = false;
            try {
                ps = this.getDataStore().getConnection().prepareStatement(sql);
                for (int i = 0; i < param.length; ++i) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                }
                rs = ps.executeQuery();
                if (rs.next()) {
                    List columnList2 = ResultMetaData.getcolumnList(rs, id);
                    result = new DBRecord();
                    for (int i = 0; i < columnList2.size(); ++i) {
                        String fieldName = (String)columnList2.get(i);
                        int resultType = DBUtil.getFieldType(rs, id, fieldName);
                        DBUtil.getFieldValue(rs, fieldName, resultType, result);
                    }
                    break block10;
                }
                columnList2 = null;
            }
            catch (SQLException e1) {
                try {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    }
                    DBException e_ret = new DBException("", e1);
                    e_ret.addScene("SQL", sql);
                    throw e_ret;
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs);
                    DBUtil.closeStatement(ps);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
            return columnList2;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return result;
    }

    private DBRecord queryStatic(String id, DBRecord dbRecord) throws DBException {
        DBRecord result;
        ResultSet rs;
        PreparedStatement ps;
        block10: {
            DBRecord columnList2;
            SQLText sqlText = null;
            SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
            String originalSql = sqlTemplate.getSql();
            Map paramTypeMap = sqlTemplate.getParamTypeMap();
            sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
            String sql = sqlText.getSql();
            String[] param = sqlText.getFields();
            int[] type = sqlText.getTypes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("sql=[" + sql + "]"));
                for (int i = 0; i < param.length; ++i) {
                    log.debug((Object)("param[" + i + "]:" + param[i]));
                }
            }
            ps = null;
            rs = null;
            result = null;
            boolean ret = false;
            try {
                ps = this.getDataStore().getConnection().prepareStatement(sql);
                for (int i = 0; i < param.length; ++i) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                }
                rs = ps.executeQuery();
                if (rs.next()) {
                    List columnList2 = ResultMetaData.getcolumnList(rs, id);
                    result = new DBRecord();
                    for (int i = 0; i < columnList2.size(); ++i) {
                        String fieldName = (String)columnList2.get(i);
                        int resultType = DBUtil.getFieldType(rs, id, fieldName);
                        DBUtil.getFieldValue(rs, fieldName, resultType, result);
                    }
                    break block10;
                }
                columnList2 = null;
            }
            catch (SQLException e1) {
                try {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    }
                    DBException e_ret = new DBException("", e1);
                    e_ret.addScene("SQL", sql);
                    throw e_ret;
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs);
                    DBUtil.closeStatement(ps);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
            return columnList2;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return result;
    }

    private DBRecordSet queryRecordsStatic(String id, DBRecord dbRecord) throws DBException {
        DBRecordSet columnList2;
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBRecordSet results = null;
        DBRecord result = null;
        boolean ret = false;
        try {
            ps = this.getDataStore().getConnection().prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            rs = ps.executeQuery();
            results = new DBRecordSet();
            while (rs.next()) {
                List columnList2 = ResultMetaData.getcolumnList(rs, id);
                result = new DBRecord();
                for (int i = 0; i < columnList2.size(); ++i) {
                    String fieldName = (String)columnList2.get(i);
                    int resultType = DBUtil.getFieldType(rs, id, fieldName);
                    DBUtil.getFieldValue(rs, fieldName, resultType, result);
                }
                results.addRow(result);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("result count: " + results.size()));
                log.debug((Object)("results: " + results.toString()));
            }
            columnList2 = results;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return columnList2;
    }

    private DBRecordSet queryRecordsDynamic(String id, DBRecord dbRecord) throws DBException {
        DBRecordSet columnList2;
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBRecordSet results = null;
        DBRecord result = null;
        boolean ret = false;
        try {
            ps = this.getDataStore().getConnection().prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            rs = ps.executeQuery();
            results = new DBRecordSet();
            while (rs.next()) {
                List columnList2 = ResultMetaData.getcolumnList(rs, id);
                result = new DBRecord();
                for (int i = 0; i < columnList2.size(); ++i) {
                    String fieldName = (String)columnList2.get(i);
                    int resultType = DBUtil.getFieldType(rs, id, fieldName);
                    DBUtil.getFieldValue(rs, fieldName, resultType, result);
                }
                results.addRow(result);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("result count: " + results.size()));
                log.debug((Object)("results: " + results.toString()));
            }
            columnList2 = results;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return columnList2;
    }

    DBRecordSet queryRecordsStatic(String id, DBRecord dbRecord, int skipResults, int maxResults) throws DBException {
        Object columnList;
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBRecordSet results = null;
        DBRecord result = null;
        boolean ret = false;
        try {
            int i;
            ps = MultiDBHelper.getDBMetaData(this.dbName).supportScrollResultSet() ? this.getDataStore().getConnection().prepareStatement(sql, 1004, 1007) : this.getDataStore().getConnection().prepareStatement(sql);
            for (i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            rs = ps.executeQuery();
            if (rs.getType() != 1003) {
                if (skipResults != 0) {
                    rs.absolute(skipResults);
                }
            } else {
                for (i = 0; i < skipResults && rs.next(); ++i) {
                }
            }
            results = new DBRecordSet();
            for (int resultFetched = 0; (maxResults == -999999 || resultFetched < maxResults) && rs.next(); ++resultFetched) {
                columnList = ResultMetaData.getcolumnList(rs, id);
                result = new DBRecord();
                for (int i2 = 0; i2 < columnList.size(); ++i2) {
                    String fieldName = (String)columnList.get(i2);
                    int resultType = DBUtil.getFieldType(rs, id, fieldName);
                    DBUtil.getFieldValue(rs, fieldName, resultType, result);
                }
                results.addRow(result);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("result count: " + results.size()));
                log.debug((Object)("results: " + results.toString()));
            }
            columnList = results;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return columnList;
    }

    DBRecordSet queryRecordsDynamic(String id, DBRecord dbRecord, int skipResults, int maxResults) throws DBException {
        Object columnList;
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBRecordSet results = null;
        DBRecord result = null;
        boolean ret = false;
        try {
            int i;
            ps = MultiDBHelper.getDBMetaData(this.dbName).supportScrollResultSet() ? this.getDataStore().getConnection().prepareStatement(sql, 1004, 1007) : this.getDataStore().getConnection().prepareStatement(sql);
            for (i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            rs = ps.executeQuery();
            if (rs.getType() != 1003) {
                if (skipResults != 0) {
                    rs.absolute(skipResults);
                }
            } else {
                for (i = 0; i < skipResults && rs.next(); ++i) {
                }
            }
            results = new DBRecordSet();
            for (int resultFetched = 0; (maxResults == -999999 || resultFetched < maxResults) && rs.next(); ++resultFetched) {
                columnList = ResultMetaData.getcolumnList(rs, id);
                result = new DBRecord();
                for (int i2 = 0; i2 < columnList.size(); ++i2) {
                    String fieldName = (String)columnList.get(i2);
                    int resultType = DBUtil.getFieldType(rs, id, fieldName);
                    DBUtil.getFieldValue(rs, fieldName, resultType, result);
                }
                results.addRow(result);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("result count: " + results.size()));
                log.debug((Object)("results: " + results.toString()));
            }
            columnList = results;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return columnList;
    }

    int countRecordsStatic(String id, DBRecord dbRecord) throws DBException {
        int i;
        ResultSet rs;
        PreparedStatement ps;
        String sql;
        block11: {
            block10: {
                SQLText sqlText = null;
                SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
                String originalSql = sqlTemplate.getSql();
                Map paramTypeMap = sqlTemplate.getParamTypeMap();
                sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
                sql = sqlText.getSql();
                int index = sql.indexOf(" from ");
                String countSql = "select count(1) " + sql.substring(index);
                String[] param = sqlText.getFields();
                int[] type = sqlText.getTypes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sql=[" + sql + "]"));
                    log.debug((Object)("countSql=[" + countSql + "]"));
                    for (int i2 = 0; i2 < param.length; ++i2) {
                        log.debug((Object)("param[" + i2 + "]:" + param[i2]));
                    }
                }
                ps = null;
                rs = null;
                Object results = null;
                Object result = null;
                boolean ret = false;
                ps = MultiDBHelper.getDBMetaData(this.dbName).supportScrollResultSet() ? this.getDataStore().getConnection().prepareStatement(sql, 1004, 1007) : this.getDataStore().getConnection().prepareStatement(countSql);
                for (i = 0; i < param.length; ++i) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                }
                rs = ps.executeQuery();
                if (rs.getType() == 1003) break block10;
                rs.last();
                i = rs.getRow();
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                return i;
            }
            if (!rs.next()) break block11;
            i = rs.getInt(1);
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
            return i;
        }
        try {
            i = 0;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return i;
    }

    int countRecordsDynamic(String id, DBRecord dbRecord) throws DBException {
        int i;
        ResultSet rs;
        PreparedStatement ps;
        String sql;
        block11: {
            block10: {
                SQLText sqlText = null;
                SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
                String originalSql = sqlTemplate.getSql();
                Map paramTypeMap = sqlTemplate.getParamTypeMap();
                sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
                sql = sqlText.getSql();
                int index = sql.indexOf(" from ");
                String countSql = "select count(1) " + sql.substring(index);
                String[] param = sqlText.getFields();
                int[] type = sqlText.getTypes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sql=[" + sql + "]"));
                    log.debug((Object)("countSql=[" + countSql + "]"));
                    for (int i2 = 0; i2 < param.length; ++i2) {
                        log.debug((Object)("param[" + i2 + "]:" + param[i2]));
                    }
                }
                ps = null;
                rs = null;
                Object results = null;
                Object result = null;
                boolean ret = false;
                ps = MultiDBHelper.getDBMetaData(this.dbName).supportScrollResultSet() ? this.getDataStore().getConnection().prepareStatement(sql, 1004, 1007) : this.getDataStore().getConnection().prepareStatement(countSql);
                for (i = 0; i < param.length; ++i) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                }
                rs = ps.executeQuery();
                if (rs.getType() == 1003) break block10;
                rs.last();
                i = rs.getRow();
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                return i;
            }
            if (!rs.next()) break block11;
            i = rs.getInt(1);
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
            return i;
        }
        try {
            i = 0;
        }
        catch (SQLException e1) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                }
                DBException e_ret = new DBException("", e1);
                e_ret.addScene("SQL", sql);
                throw e_ret;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(ps);
        return i;
    }

    private PageRecords queryPageRecordsStatic(String id, DBRecord dbRecord, int rowsPerPage) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        SQLText sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
        return new PageRecordsStaticImpl(id, dbRecord, rowsPerPage, sqlText, this);
    }

    private PageRecords queryPageRecordsDynamic(String id, DBRecord dbRecord, int rowsPerPage) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        SQLText sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
        return new PageRecordsDynamicImpl(id, dbRecord, rowsPerPage, sqlText, this);
    }

    private int executeDynamic(String id, DBRecord dbRecord) {
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLDynamic(originalSql, dbRecord, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = this.getDataStore().getConnection().prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            ret = ps.executeUpdate();
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            DBException e_ret = new DBException("", e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return ret;
    }

    private int executeStatic(String id, DBRecord dbRecord) {
        SQLText sqlText = null;
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        String originalSql = sqlTemplate.getSql();
        Map paramTypeMap = sqlTemplate.getParamTypeMap();
        sqlText = this.parser.parseSQLStatic(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
            }
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = this.getDataStore().getConnection().prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
            }
            ret = ps.executeUpdate();
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            DBException e_ret = new DBException("", e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return ret;
    }

    public DBRecord executeProc(String id, DBRecord dbRecord) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        SQLText sqlText = null;
        String originalSql = sqlTemplate.getSql();
        HashMap paramTypeMap = new HashMap();
        Map inMap = null;
        Map outMap = null;
        Map inOutMap = null;
        if (sqlTemplate.getInParamType() != null) {
            inMap = sqlTemplate.getInParamType();
            paramTypeMap.putAll(inMap);
        }
        if (sqlTemplate.getOutParamType() != null) {
            outMap = sqlTemplate.getOutParamType();
            paramTypeMap.putAll(outMap);
        }
        if (sqlTemplate.getInOutParamType() != null) {
            inOutMap = sqlTemplate.getInOutParamType();
            paramTypeMap.putAll(inOutMap);
        }
        sqlText = this.parser.parseProc(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
                log.debug((Object)("type[" + i + "]:" + type[i]));
            }
        }
        CallableStatement ps = null;
        boolean ret = false;
        DBRecord res = new DBRecord();
        try {
            int i;
            ps = this.getDataStore().getConnection().prepareCall(sql);
            for (i = 0; i < param.length; ++i) {
                if (outMap != null && outMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                    continue;
                }
                if (inOutMap != null && inOutMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                }
                if (dbRecord.columnSet().contains(param[i])) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                    continue;
                }
                ps.setObject(param[i], null);
            }
            ps.execute();
            for (i = 0; i < param.length; ++i) {
                if (outMap != null && outMap.containsKey(param[i])) {
                    res.setString(param[i], String.valueOf(ps.getObject(i + 1)));
                    continue;
                }
                if (inOutMap == null || !inOutMap.containsKey(param[i])) continue;
                res.setString(param[i], String.valueOf(ps.getObject(i + 1)));
            }
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            DBException e_ret = new DBException(String.valueOf(e1.getErrorCode()), e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return res;
    }

    public DBRecord queryProc(String id, DBRecord dbRecord) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        SQLText sqlText = null;
        String originalSql = sqlTemplate.getSql();
        HashMap paramTypeMap = new HashMap();
        Map inMap = null;
        Map outMap = null;
        Map inOutMap = null;
        if (sqlTemplate.getInParamType() != null) {
            inMap = sqlTemplate.getInParamType();
            paramTypeMap.putAll(inMap);
        }
        if (sqlTemplate.getOutParamType() != null) {
            outMap = sqlTemplate.getOutParamType();
            paramTypeMap.putAll(outMap);
        }
        if (sqlTemplate.getInOutParamType() != null) {
            inOutMap = sqlTemplate.getInOutParamType();
            paramTypeMap.putAll(inOutMap);
        }
        sqlText = this.parser.parseProc(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
                log.debug((Object)("type[" + i + "]:" + type[i]));
            }
        }
        CallableStatement ps = null;
        boolean ret = false;
        DBRecord res = new DBRecord();
        try {
            int i;
            ps = this.getDataStore().getConnection().prepareCall(sql);
            for (i = 0; i < param.length; ++i) {
                if (outMap != null && outMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                    continue;
                }
                if (inOutMap != null && inOutMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                }
                if (dbRecord.columnSet().contains(param[i])) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                    continue;
                }
                ps.setObject(param[i], null);
            }
            ps.execute();
            for (i = 0; i < param.length; ++i) {
                if (outMap != null && outMap.containsKey(param[i])) {
                    res.setString(param[i], String.valueOf(ps.getObject(i + 1)));
                    continue;
                }
                if (inOutMap == null || !inOutMap.containsKey(param[i])) continue;
                res.setString(param[i], String.valueOf(ps.getObject(i + 1)));
            }
            ps.close();
            ps = null;
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            DBException e_ret = new DBException(String.valueOf(e1.getErrorCode()), e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            if (ps != null) {
                DBUtil.closeStatement(ps);
            }
        }
        return res;
    }

    public DBRecordSet queryRecordsProc(String id, DBRecord dbRecord) throws DBException {
        SQLTemplate sqlTemplate = MultiDBHelper.getTemplate(this.dbName, id);
        SQLText sqlText = null;
        String originalSql = sqlTemplate.getSql();
        HashMap paramTypeMap = new HashMap();
        Map inMap = null;
        Map outMap = null;
        Map inOutMap = null;
        if (sqlTemplate.getInParamType() != null) {
            inMap = sqlTemplate.getInParamType();
            paramTypeMap.putAll(inMap);
        }
        if (sqlTemplate.getOutParamType() != null) {
            outMap = sqlTemplate.getOutParamType();
            paramTypeMap.putAll(outMap);
        }
        if (sqlTemplate.getInOutParamType() != null) {
            inOutMap = sqlTemplate.getInOutParamType();
            paramTypeMap.putAll(inOutMap);
        }
        sqlText = this.parser.parseProc(originalSql, paramTypeMap);
        String sql = sqlText.getSql();
        String[] param = sqlText.getFields();
        int[] type = sqlText.getTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
            for (int i = 0; i < param.length; ++i) {
                log.debug((Object)("param[" + i + "]:" + param[i]));
                log.debug((Object)("type[" + i + "]:" + type[i]));
            }
        }
        CallableStatement ps = null;
        boolean ret = false;
        DBRecord res = new DBRecord();
        DBRecordSet results = null;
        ResultSet rs = null;
        int updateCount = -1;
        try {
            int i;
            ps = this.getDataStore().getConnection().prepareCall(sql);
            for (i = 0; i < param.length; ++i) {
                if (outMap != null && outMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                    continue;
                }
                if (inOutMap != null && inOutMap.containsKey(param[i])) {
                    ps.registerOutParameter(i + 1, (int)new Integer((String)paramTypeMap.get(param[i])));
                }
                if (dbRecord.columnSet().contains(param[i])) {
                    DBUtil.setParameter(ps, i + 1, type[i], dbRecord, param[i]);
                    continue;
                }
                ps.setObject(param[i], null);
            }
            ret = ps.execute();
            results = new DBRecordSet();
            for (i = 0; i < param.length; ++i) {
                int resultType;
                String fieldName;
                int jj;
                DBRecord record;
                List columnList;
                Object temp;
                res = new DBRecord();
                if (sqlTemplate.getOutParamType() != null && sqlTemplate.getOutParamType().containsKey(param[i])) {
                    temp = ps.getObject(i + 1);
                    if (temp instanceof ResultSet) {
                        rs = (ResultSet)temp;
                        while (rs.next()) {
                            columnList = ResultMetaData.getcolumnList(rs, sqlTemplate.getId());
                            record = new DBRecord();
                            for (jj = 0; jj < columnList.size(); ++jj) {
                                fieldName = (String)columnList.get(jj);
                                resultType = DBUtil.getFieldType(rs, sqlTemplate.getId(), fieldName);
                                DBUtil.getFieldValue(rs, fieldName, resultType, record);
                            }
                            results.addRow(record);
                        }
                        continue;
                    }
                    res.setString(param[i], String.valueOf(temp));
                    results.addRow(res);
                    continue;
                }
                if (sqlTemplate.getInOutParamType() == null || !sqlTemplate.getInOutParamType().containsKey(param[i])) continue;
                temp = ps.getObject(i + 1);
                if (temp instanceof ResultSet) {
                    rs = (ResultSet)temp;
                    while (rs.next()) {
                        columnList = ResultMetaData.getcolumnList(rs, sqlTemplate.getId());
                        record = new DBRecord();
                        for (jj = 0; jj < columnList.size(); ++jj) {
                            fieldName = (String)columnList.get(jj);
                            resultType = DBUtil.getFieldType(rs, sqlTemplate.getId(), fieldName);
                            DBUtil.getFieldValue(rs, fieldName, resultType, record);
                        }
                        results.addRow(record);
                    }
                    continue;
                }
                res.setString(param[i], String.valueOf(temp));
                results.addRow(res);
            }
        }
        catch (SQLException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884cSQL\u6a21\u677f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            DBException e_ret = new DBException(String.valueOf(e1.getErrorCode()), e1);
            e_ret.addScene("SQL", sql);
            throw e_ret;
        }
        finally {
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(ps);
        }
        return results;
    }

    public static void main(String[] args) {
    }
}

