/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.db.DBException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DBRecord {
    private Map map;
    private boolean case_sensitive;
    private List columnList;
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-mm-dd");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("hh:mm:ss");

    public DBRecord() {
        this.map = new HashMap();
        this.case_sensitive = false;
    }

    public void setColumnList(List columnList) {
        this.columnList = columnList;
    }

    public List getColumnList() {
        return this.columnList;
    }

    public DBRecord(boolean case_sensitive) {
        this.map = new HashMap();
        this.case_sensitive = case_sensitive;
    }

    protected DBRecord(DBRecord dbRecord) {
        this.map = new HashMap(dbRecord.map);
        this.case_sensitive = dbRecord.case_sensitive;
    }

    private void addColumn(String columnName, Object columnValue) {
        if (!this.case_sensitive) {
            columnName = columnName.toLowerCase();
        }
        this.map.put(columnName, columnValue);
    }

    private Object getColumnValue(String columnName) {
        if (!this.case_sensitive) {
            columnName = columnName.toLowerCase();
        }
        if (!this.map.containsKey(columnName)) {
            throw this.getDBException(columnName, "column_not_exist_in_dbrecord");
        }
        return this.map.get(columnName);
    }

    public void setString(String columnName, String x) {
        this.addColumn(columnName, x);
    }

    public void setInt(String columnName, int x) {
        this.addColumn(columnName, new Integer(x));
    }

    public void setLong(String columnName, long x) {
        this.addColumn(columnName, new Long(x));
    }

    public void setDouble(String columnName, double x) {
        this.addColumn(columnName, new Double(x));
    }

    public void setBytes(String columnName, byte[] x) {
        this.addColumn(columnName, x);
    }

    public void setBoolean(String columnName, boolean x) {
        this.addColumn(columnName, new Boolean(x));
    }

    public String getString(String columnName) {
        if (null != this.getColumnValue(columnName)) {
            return this.getColumnValue(columnName).toString();
        }
        return null;
    }

    public int getInt(String columnName) throws DBException {
        Object columnValue = this.getColumnValue(columnName);
        if (columnValue instanceof Integer) {
            return (Integer)columnValue;
        }
        if (columnValue instanceof Long) {
            return ((Long)columnValue).intValue();
        }
        if (columnValue instanceof Double) {
            return ((Double)columnValue).intValue();
        }
        if (columnValue instanceof byte[]) {
            throw this.getDBException(columnName, "getint_not_allowed_bytes");
        }
        try {
            String val = this.getString(columnName);
            if (null != val) {
                return Integer.parseInt(val);
            }
            throw this.getDBException(columnName, "getint_not_allowed_null");
        }
        catch (NumberFormatException e) {
            throw this.getDBException(columnName, "getint_number_format_exception");
        }
    }

    public long getLong(String columnName) throws DBException {
        Object columnValue = this.getColumnValue(columnName);
        if (columnValue instanceof Long) {
            return (Long)columnValue;
        }
        if (columnValue instanceof Integer) {
            return ((Integer)columnValue).longValue();
        }
        if (columnValue instanceof Double) {
            return ((Double)columnValue).longValue();
        }
        if (columnValue instanceof byte[]) {
            throw this.getDBException(columnName, "getlong_not_allowed_bytes");
        }
        try {
            String val = this.getString(columnName);
            if (null != val) {
                return Long.parseLong(val);
            }
            throw this.getDBException(columnName, "getlong_not_allowed_null");
        }
        catch (NumberFormatException e) {
            throw this.getDBException(columnName, "getlong_number_format_exception");
        }
    }

    public double getDouble(String columnName) throws DBException {
        Object columnValue = this.getColumnValue(columnName);
        if (columnValue instanceof Double) {
            return (Double)columnValue;
        }
        if (columnValue instanceof Integer) {
            return ((Integer)columnValue).doubleValue();
        }
        if (columnValue instanceof Long) {
            return ((Long)columnValue).doubleValue();
        }
        if (columnValue instanceof byte[]) {
            throw this.getDBException(columnName, "getdouble_not_allowed_bytes");
        }
        try {
            String val = this.getString(columnName);
            if (null != val) {
                return Double.parseDouble(val);
            }
            throw this.getDBException(columnName, "getdouble_not_allowed_null");
        }
        catch (NumberFormatException e) {
            throw this.getDBException(columnName, "getdouble_number_format_exception");
        }
    }

    public byte[] getBytes(String columnName) throws DBException {
        Object columnValue = this.getColumnValue(columnName);
        if (columnValue instanceof byte[]) {
            return (byte[])columnValue;
        }
        throw this.getDBException(columnName, "getbytes_not_allowed_type");
    }

    public boolean getBoolean(String columnName) throws DBException {
        Object columnValue = this.getColumnValue(columnName);
        if (columnValue instanceof Boolean) {
            return (Boolean)columnValue;
        }
        throw this.getDBException(columnName, "getboolean_not_allowed_type");
    }

    public Iterator columns() {
        return this.map.keySet().iterator();
    }

    public Set columnSet() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }

    private DBException getDBException(String columnName, String errCode) {
        DBException ex = new DBException(errCode);
        ex.addScene("columnName", columnName);
        ex.addScene("DBRecord", this.toString());
        return ex;
    }

    public void setInt(String columnName, String x) {
        if (x != null) {
            try {
                int temp = Integer.parseInt(x);
                this.setInt(columnName, temp);
            }
            catch (NumberFormatException e) {
                throw this.getDBException(columnName, "setint_number_format_exception");
            }
        } else {
            this.addColumn(columnName, x);
        }
    }

    public void setLong(String columnName, String x) {
        if (x != null) {
            try {
                long temp = Long.parseLong(x);
                this.setLong(columnName, temp);
            }
            catch (NumberFormatException e) {
                throw this.getDBException(columnName, "setint_number_format_exception");
            }
        } else {
            this.addColumn(columnName, x);
        }
    }

    public void setDouble(String columnName, String x) {
        if (x != null) {
            try {
                double temp = Double.parseDouble(x);
                this.setDouble(columnName, temp);
            }
            catch (NumberFormatException e) {
                throw this.getDBException(columnName, "setint_number_format_exception");
            }
        } else {
            this.addColumn(columnName, x);
        }
    }

    public void setBoolean(String columnName, String x) {
        if (x != null) {
            try {
                boolean temp = Boolean.valueOf(x);
                this.setBoolean(columnName, temp);
            }
            catch (NumberFormatException e) {
                throw this.getDBException(columnName, "setint_number_format_exception");
            }
        } else {
            this.addColumn(columnName, x);
        }
    }
}

