/*
 * Decompiled with CFR 0.152.
 */
package com.dc.db;

import com.dc.datastore.DataStore;
import com.dc.datastore.DataStoreMan;
import com.dc.db.DBException;
import com.dc.db.DBUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBMetaData {
    private static Log log = LogFactory.getLog((Class)DBMetaData.class);
    private Map columnCache = new HashMap(101);
    private Map fieldTypeCache = new HashMap(101);
    private Map primaryKeyCache = new HashMap(101);
    private boolean inited = false;
    private boolean supportSRS;
    private String dbName;
    private static Map metadatas = new HashMap(5);

    public static synchronized DBMetaData getInstance(String dbName) {
        if (dbName == null) {
            return null;
        }
        DBMetaData md = (DBMetaData)metadatas.get(dbName);
        if (md == null && dbName != null) {
            md = new DBMetaData(dbName);
            metadatas.put(dbName, md);
        }
        return md;
    }

    DBMetaData(String dbName) {
        this.dbName = dbName;
    }

    public synchronized boolean supportScrollResultSet() {
        if (!this.inited) {
            DataStore ds = DataStoreMan.getInstance().getDataStore(this.dbName);
            Connection conn = ds.getConnection();
            try {
                DatabaseMetaData md = conn.getMetaData();
                this.supportSRS = md.supportsResultSetType(1004);
                this.inited = true;
                boolean bl = this.supportSRS;
                return bl;
            }
            catch (SQLException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u68c0\u6d4b\u5f53\u524d\u6570\u636e\u5e93\u662f\u5426\u652f\u6301\u6eda\u52a8\u7ed3\u679c\u96c6\u51fa\u73b0SQLException", (Throwable)e);
                }
                throw new DBException("support_scroll_result_set_exception", e);
            }
            finally {
                DBUtil.closeConnection(conn);
                DBUtil.closeDataStore(ds);
            }
        }
        return this.supportSRS;
    }

    public synchronized List getcolumnList(String tableName) {
        ArrayList<String> arrayList;
        ArrayList<String> list = (ArrayList<String>)this.columnCache.get(tableName);
        if (list != null) {
            return list;
        }
        DataStore ds = DataStoreMan.getInstance().getDataStore(this.dbName);
        Connection conn = ds.getConnection();
        DatabaseMetaData dmd = null;
        ResultSet rs = null;
        try {
            dmd = conn.getMetaData();
            String name = tableName.toUpperCase();
            String schema = null;
            int index = name.indexOf(46);
            if (index > -1) {
                schema = name.substring(0, index);
                name = name.substring(index + 1);
            }
            if (schema == null) {
                schema = dmd.getUserName();
            }
            list = new ArrayList<String>();
            rs = dmd.getColumns(null, schema, name, null);
            while (rs.next()) {
                list.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TABLE_NAME:" + name));
                log.debug((Object)("Columns:" + ((Object)list).toString()));
            }
            this.columnCache.put(tableName, list);
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                throw new DBException("get_column_list_exception", e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeConnection(conn);
                DBUtil.closeDataStore(ds);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeConnection(conn);
        DBUtil.closeDataStore(ds);
        return arrayList;
    }

    public synchronized List getPrimaryKeyList(String tableName) {
        ArrayList<String> arrayList;
        ArrayList<String> list = (ArrayList<String>)this.primaryKeyCache.get(tableName);
        if (list != null) {
            return list;
        }
        DataStore ds = DataStoreMan.getInstance().getDataStore(this.dbName);
        Connection conn = ds.getConnection();
        DatabaseMetaData dmd = null;
        ResultSet rs = null;
        try {
            dmd = conn.getMetaData();
            String name = tableName.toUpperCase();
            String schema = null;
            int index = name.indexOf(46);
            if (index > -1) {
                schema = name.substring(0, index);
                name = name.substring(index + 1);
            }
            if (schema == null) {
                schema = dmd.getUserName();
            }
            list = new ArrayList<String>();
            rs = dmd.getPrimaryKeys(null, schema, name);
            while (rs.next()) {
                list.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TABLE_NAME:" + name));
                log.debug((Object)("Primary Key:" + ((Object)list).toString()));
            }
            this.primaryKeyCache.put(tableName, list);
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8868\u4e3b\u952e\u5217\u8868\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                throw new DBException("get_primary_key_list_exception", e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeConnection(conn);
                DBUtil.closeDataStore(ds);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeConnection(conn);
        DBUtil.closeDataStore(ds);
        return arrayList;
    }

    public synchronized Map getFieldTypeMap(String tableName) {
        HashMap<String, Integer> hashMap;
        HashMap<String, Integer> map = (HashMap<String, Integer>)this.fieldTypeCache.get(tableName);
        if (map != null) {
            return map;
        }
        DataStore ds = DataStoreMan.getInstance().getDataStore(this.dbName);
        Connection conn = ds.getConnection();
        DatabaseMetaData dmd = null;
        ResultSet rs = null;
        try {
            dmd = conn.getMetaData();
            String name = tableName.toUpperCase();
            String schema = null;
            int index = name.indexOf(46);
            if (index > -1) {
                schema = name.substring(0, index);
                name = name.substring(index + 1);
            }
            map = new HashMap<String, Integer>();
            rs = dmd.getColumns(null, schema, name, null);
            while (rs.next()) {
                map.put(rs.getString("COLUMN_NAME").toLowerCase(), new Integer(rs.getInt("DATA_TYPE")));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TABLE_NAME:" + name));
                log.debug((Object)("column/type:" + ((Object)map).toString()));
            }
            this.fieldTypeCache.put(tableName, map);
            hashMap = map;
        }
        catch (SQLException e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u7c7b\u578b\u6620\u5c04\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                throw new DBException("get_field_type_map_exception", e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeConnection(conn);
                DBUtil.closeDataStore(ds);
                throw throwable;
            }
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeConnection(conn);
        DBUtil.closeDataStore(ds);
        return hashMap;
    }
}

