/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import com.dc.datastore.PMException;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public class UserTransactionHelper {
    private static ThreadLocal tx_keepsakes;

    public static UserTransaction getUserTransaction() {
        try {
            InitialContext ctx = new InitialContext();
            UserTransaction ut = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            return ut;
        }
        catch (Exception ex) {
            throw new PMException("GetUserTransactionFail", ex);
        }
    }

    static void begin_tx() {
        try {
            UserTransaction ut = UserTransactionHelper.getUserTransaction();
            if (ut.getStatus() != 0) {
                ut.begin();
            }
        }
        catch (Exception ex) {
            throw new PMException("StartTransactionFail", ex);
        }
    }

    static void commit() {
        try {
            UserTransaction ut = UserTransactionHelper.getUserTransaction();
            if (ut.getStatus() == 0) {
                ut.commit();
            }
        }
        catch (Exception ex) {
            throw new PMException("CommitTransactionFail", ex);
        }
    }

    static void rollback() {
        try {
            UserTransaction ut = UserTransactionHelper.getUserTransaction();
            if (ut.getStatus() == 0) {
                ut.rollback();
            }
        }
        catch (Exception ex) {
            throw new PMException("RollbackTransactionFail", ex);
        }
    }

    public static boolean isActive() {
        try {
            UserTransaction ut = UserTransactionHelper.getUserTransaction();
            return ut.getStatus() == 0;
        }
        catch (Exception ex) {
            throw new PMException("GetTransactionStatusFail", ex);
        }
    }

    public static Object begin() {
        Object tx_keepsake = tx_keepsakes.get();
        if (tx_keepsake == null && !UserTransactionHelper.isActive()) {
            UserTransactionHelper.begin_tx();
            tx_keepsake = new Object();
            tx_keepsakes.set(tx_keepsake);
            return tx_keepsake;
        }
        return null;
    }

    public static int commit(Object keepsake) {
        if (keepsake != null && keepsake == tx_keepsakes.get()) {
            UserTransactionHelper.commit();
            tx_keepsakes.set(null);
            return 0;
        }
        return 1;
    }

    public static int rollback(Object keepsake) {
        if (keepsake != null && keepsake == tx_keepsakes.get()) {
            tx_keepsakes.set(new Integer(-1));
            UserTransactionHelper.rollback();
            return 0;
        }
        return 1;
    }
}

