/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import com.dc.datastore.JDBCInformixWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCInformixProxy
implements InvocationHandler {
    private static Log logger = LogFactory.getLog((Class)JDBCInformixProxy.class);
    private Object target;
    private JDBCInformixWrapper wrapper;

    public JDBCInformixProxy(Object target) {
        this.target = target;
        this.wrapper = new JDBCInformixWrapper();
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String name = m.getName();
        if ("prepareStatement".equals(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PrepareStatement:" + args[0]));
            }
            args[0] = this.convertTo((String)args[0]);
            PreparedStatement stmt = (PreparedStatement)m.invoke(this.target, args);
            return this.wrapper.getPreparedStatementWrapper(stmt);
        }
        if ("createStatement".equals(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"CreateStatement");
            }
            Statement stmt = (Statement)m.invoke(this.target, args);
            return this.wrapper.getStatementWrapper(stmt);
        }
        if ("executeQuery".equals(name)) {
            if (logger.isDebugEnabled()) {
                if (args != null && args.length > 0) {
                    logger.debug((Object)("ExecuteQuery:" + args[0]));
                } else {
                    logger.debug((Object)"ExecuteQuery");
                }
            }
            if (args != null && args.length > 0) {
                args[0] = this.convertTo((String)args[0]);
            }
            ResultSet rs = (ResultSet)m.invoke(this.target, args);
            return this.wrapper.getResultSetWrapper(rs);
        }
        if ("getResultSet".equals(name)) {
            ResultSet rs = (ResultSet)m.invoke(this.target, args);
            return this.wrapper.getResultSetWrapper(rs);
        }
        if ("execute".equals(name) || "executeUpdate".equals(name)) {
            if (args != null && args.length > 0) {
                args[0] = this.convertTo((String)args[0]);
            }
        } else if ("setString".equals(name) || "updateString".equals(name)) {
            if (args.length == 2) {
                args[1] = this.convertTo((String)args[1]);
            }
        } else if ("getString".equals(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("GetString:" + args[0]));
            }
            String s = (String)m.invoke(this.target, args);
            return this.convertFrom(s);
        }
        return m.invoke(this.target, args);
    }

    private String convertTo(String str) {
        if (str == null) {
            return str;
        }
        try {
            return new String(str.getBytes("GBK"), "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private String convertFrom(String str) {
        if (str == null) {
            return str;
        }
        try {
            return new String(str.getBytes("ISO8859_1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}

