/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import com.dc.datastore.ConnectionWrapper;
import com.dc.datastore.DataStoreInterface;
import com.dc.datastore.JDBCWrapper;
import com.dc.datastore.JDBCWrapperFactory;
import com.dc.datastore.PMException;
import com.dc.datastore.PersistenceManager;
import com.dc.datastore.UserTransactionHelper;
import com.dc.exception.SystemException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDataStoreImpl
implements DataStoreInterface {
    private static Log logger = LogFactory.getLog((Class)JDBCDataStoreImpl.class);
    private static Properties prop = new Properties();
    private static String configFile = "/system.properties";
    private static JDBCWrapper wrapper;
    private Connection conn;
    private Connection connWrapper;
    private boolean need_begin = false;
    private static Map driverMap;
    private static Map driverClassMap;
    private static Properties connProp;
    private static String transactionMode;
    private static String dbms;
    private static String connectionMode;
    private static String driver;
    private static String url;
    private static String datasource;
    private static String user;
    private static String password;

    public JDBCDataStoreImpl() {
        try {
            prop.load(JDBCDataStoreImpl.class.getResourceAsStream(configFile));
            transactionMode = (String)prop.get("db.jdbc.transaction.mode");
            dbms = (String)prop.get("db.jdbc.dbms");
            connectionMode = (String)prop.get("db.jdbc.connection.mode");
            driver = (String)prop.get("db.jdbc.driver");
            url = (String)prop.get("db.jdbc.url");
            datasource = (String)prop.get("db.jdbc.datasource");
            user = (String)prop.get("db.jdbc.user");
            password = (String)prop.get("db.jdbc.password");
            wrapper = JDBCWrapperFactory.getWrapper(driver);
            connProp.setProperty("user", user);
            connProp.setProperty("password", password);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"IOException:", (Throwable)e);
            }
            throw new SystemException("NoSystemConfig");
        }
    }

    public JDBCDataStoreImpl(Properties p) {
        this.setProperties(p);
    }

    public PersistenceManager getPersistenceManager() {
        return null;
    }

    public Connection getIndependentConnection() {
        return this.getIndependentConnection(user, password);
    }

    public Connection getIndependentConnection(String user, String password) {
        try {
            Class.forName(driver).newInstance();
            Connection independConn = user == null || "".equals(user) ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"\u521b\u5efa\u72ec\u7acbJDBC\u6570\u636e\u5e93\u8fde\u63a5");
            }
            if (wrapper != null) {
                independConn = wrapper.getConnectionWrapper(independConn);
            }
            return independConn;
        }
        catch (ClassNotFoundException ex) {
            PMException e = new PMException("LoadDriverFail", ex);
            e.addScene("driver", driver);
            e.addScene("url", url);
            if (user != null && !"".equals(user)) {
                e.addScene("user", user);
                e.addScene("password", password);
            }
            throw e;
        }
        catch (SQLException ex) {
            PMException e = new PMException("CreateConnectionFail", ex);
            e.addScene("driver", driver);
            e.addScene("url", url);
            if (user != null && !"".equals(user)) {
                e.addScene("user", user);
                e.addScene("password", password);
            }
            throw e;
        }
        catch (Exception ex) {
            PMException e = new PMException("CreateConnectionFail", ex);
            e.addScene("driver", driver);
            e.addScene("url", url);
            if (user != null && !"".equals(user)) {
                e.addScene("user", user);
                e.addScene("password", password);
            }
            throw e;
        }
    }

    public Connection getConnection() {
        return this.getConnection(user, password);
    }

    public Connection getConnection(String user, String password) {
        if (this.conn == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u521b\u5efaJDBC\u6570\u636e\u5e93\u8fde\u63a5");
            }
            if ("datasource".equals(connectionMode) && !"".equals(datasource) && datasource != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Create DB Connection by DataSource:" + datasource));
                }
                try {
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup(datasource);
                    if (user == null || "".equals(user)) {
                        this.conn = ds.getConnection();
                    }
                    this.conn = ds.getConnection(user, password);
                }
                catch (SQLException ex) {
                    PMException e = new PMException("CreateConnectionFail", ex);
                    e.addScene("datasource", datasource);
                    if (user != null && !"".equals(user)) {
                        e.addScene("user", user);
                        e.addScene("password", password);
                    }
                    throw e;
                }
                catch (NamingException ex) {
                    PMException e = new PMException("GetDataSourceFail", ex);
                    e.addScene("datasource", datasource);
                    if (user != null && !"".equals(user)) {
                        e.addScene("user", user);
                        e.addScene("password", password);
                    }
                    throw e;
                }
            } else {
                try {
                    Driver driv;
                    if (!driverClassMap.containsKey(driver)) {
                        Class.forName(driver);
                        driverClassMap.put(driver, null);
                    }
                    if (!driverMap.containsKey(url + user)) {
                        driv = DriverManager.getDriver(url);
                        driverMap.put(url + user, driv);
                    } else {
                        driv = (Driver)driverMap.get(url + user);
                    }
                    if (user != null && !"".equals(user)) {
                        Properties p = new Properties();
                        p.setProperty("user", user);
                        p.setProperty("password", password);
                        this.conn = driv.connect(url, p);
                    } else {
                        this.conn = driv.connect(url, connProp);
                    }
                    if ("informix".equalsIgnoreCase(dbms)) {
                        Statement stmt = this.conn.createStatement();
                        stmt.executeUpdate("set lock mode to wait 120");
                    }
                }
                catch (ClassNotFoundException ex) {
                    PMException e = new PMException("LoadDriverFail", ex);
                    e.addScene("driver", driver);
                    e.addScene("url", url);
                    if (user != null && !"".equals(user)) {
                        e.addScene("user", user);
                        e.addScene("password", password);
                    }
                    throw e;
                }
                catch (SQLException ex) {
                    PMException e = new PMException("CreateConnectionFail", ex);
                    e.addScene("driver", driver);
                    e.addScene("url", url);
                    if (user != null && !"".equals(user)) {
                        e.addScene("user", user);
                        e.addScene("password", password);
                    }
                    throw e;
                }
                catch (Exception ex) {
                    PMException e = new PMException("CreateConnectionFail", ex);
                    e.addScene("driver", driver);
                    e.addScene("url", url);
                    if (user != null && !"".equals(user)) {
                        e.addScene("user", user);
                        e.addScene("password", password);
                    }
                    throw e;
                }
            }
            if (this.need_begin) {
                this.begin();
            }
            if (wrapper != null) {
                this.conn = wrapper.getConnectionWrapper(this.conn);
            }
            this.connWrapper = new ConnectionWrapper(this.conn);
        }
        return this.connWrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin() {
        if (transactionMode != null && "global".equals(transactionMode)) {
            UserTransactionHelper.begin_tx();
            if (!logger.isInfoEnabled()) return;
            logger.info((Object)"\u542f\u52a8\u5168\u5c40\u4e8b\u52a1");
            return;
        }
        if (this.conn != null) {
            try {
                this.conn.setAutoCommit(false);
                if (!logger.isInfoEnabled()) return;
                logger.info((Object)"\u542f\u52a8\u672c\u5730\u4e8b\u52a1");
                return;
            }
            catch (SQLException ex) {
                throw new PMException("SetAutoCommitFail", ex);
            }
        } else {
            this.need_begin = true;
        }
    }

    public void commit() {
        if (transactionMode != null && "global".equals(transactionMode)) {
            UserTransactionHelper.commit();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"\u63d0\u4ea4\u5168\u5c40\u4e8b\u52a1");
            }
        } else if (this.conn != null) {
            try {
                this.conn.commit();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"\u63d0\u4ea4\u672c\u5730\u4e8b\u52a1");
                }
            }
            catch (SQLException ex) {
                throw new PMException("CommitTransactionFail", ex);
            }
        }
    }

    public void rollback() {
        if (transactionMode != null && "global".equals(transactionMode)) {
            UserTransactionHelper.rollback();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"\u56de\u6eda\u5168\u5c40\u4e8b\u52a1");
            }
        } else if (this.conn != null) {
            try {
                this.conn.rollback();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"\u56de\u6eda\u672c\u5730\u4e8b\u52a1");
                }
            }
            catch (SQLException ex) {
                throw new PMException("RollbackTransactionFail", ex);
            }
        }
    }

    public void rollbackAndResume() {
        if (transactionMode != null && "global".equals(transactionMode)) {
            UserTransactionHelper.rollback();
            UserTransactionHelper.begin_tx();
            return;
        }
        this.rollback();
        this.begin();
    }

    public void commitAndResume() {
        if (transactionMode != null && "global".equals(transactionMode)) {
            UserTransactionHelper.commit();
            UserTransactionHelper.begin_tx();
            return;
        }
        this.commit();
        this.begin();
    }

    public void close() {
        block4: {
            try {
                if (this.conn != null && !this.conn.isClosed()) {
                    this.conn.close();
                    this.conn = null;
                    this.connWrapper = null;
                    this.need_begin = false;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"\u5173\u95edJDBC\u6570\u636e\u5e93\u8fde\u63a5");
                    }
                }
            }
            catch (SQLException ex) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error((Object)"SQLException:", (Throwable)ex);
            }
        }
    }

    public boolean isGlobalTx() {
        return transactionMode != null && "global".equals(transactionMode);
    }

    public void setProperties(Properties p) {
        transactionMode = (String)p.get("db.jdbc.transaction.mode");
        dbms = (String)p.get("db.jdbc.dbms");
        connectionMode = (String)p.get("db.jdbc.connection.mode");
        driver = (String)p.get("db.jdbc.driver");
        url = (String)p.get("db.jdbc.url");
        datasource = (String)p.get("db.jdbc.datasource");
        user = (String)p.get("db.jdbc.user");
        password = (String)p.get("db.jdbc.password");
        wrapper = JDBCWrapperFactory.getWrapper(driver);
        connProp.setProperty("user", user);
        connProp.setProperty("password", password);
    }

    static {
        driverMap = new HashMap();
        driverClassMap = new HashMap();
        connProp = new Properties();
    }
}

