/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import com.dc.datastore.DataStore;
import com.dc.datastore.JDBCDataStoreImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataStoreMan
implements Runnable {
    private static Map db_conf_s = new HashMap(5);
    private static Log logger = LogFactory.getLog((Class)DataStore.class);
    private static DataStoreMan single = null;
    private static ThreadLocal maps = new ThreadLocal();
    public static long CHECK_CYC = 30L;
    private Map ds2thread = Collections.synchronizedMap(new HashMap(101));

    public static DataStoreMan getInstance() {
        if (single == null) {
            single = new DataStoreMan();
        }
        return single;
    }

    public void addConfig(Properties p) {
        String name = p.getProperty("name");
        if (name == null) {
            throw new NullPointerException("db access name not defined");
        }
        db_conf_s.put(name, p);
    }

    public DataStore getDataStore(String name) {
        if (name == null || "".equals(name)) {
            throw new NullPointerException("DataSource name cannot be empty");
        }
        HashMap<String, DataStore> m = (HashMap<String, DataStore>)maps.get();
        if (m == null) {
            m = new HashMap<String, DataStore>(5);
            maps.set(m);
        }
        DataStore ds = (DataStore)m.get(name);
        Properties p = (Properties)db_conf_s.get(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The DB source is " + name + "..................."));
            Iterator<Object> ite = p.keySet().iterator();
            while (ite.hasNext()) {
                String tmpname = (String)ite.next();
                String vale = (String)p.get(tmpname);
                logger.debug((Object)("The DB properties key is" + tmpname + ",value is " + vale + "........"));
            }
        }
        if (ds == null) {
            if (p == null) {
                throw new NullPointerException("db config not defined here for name of [" + name + "]");
            }
            JDBCDataStoreImpl dsimpl = new JDBCDataStoreImpl(p);
            ds = new DataStore(dsimpl);
            ds.setName(name);
            m.put(name, ds);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u83b7\u53d6\u521b\u5efa" + ds));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6DataStore,name=" + ds.getName()));
            }
            ds.setProperties(p);
        }
        return ds;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Iterator iter = this.ds2thread.keySet().iterator();
                    while (iter.hasNext()) {
                        DataStore dsi = (DataStore)iter.next();
                        Thread t = (Thread)this.ds2thread.get(dsi);
                        if (t.isAlive()) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("\u5f00\u59cb\u5173\u95ed\u6b7b\u4ea1\u7ebf\u7a0b\u5360\u7528\u7684\u8fde\u63a5" + dsi));
                        }
                        dsi.finalize();
                    }
                    Thread.sleep(CHECK_CYC);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void dispose() {
        Map m = (Map)maps.get();
        Iterator iter = m.keySet().iterator();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"\u9500\u6bc1\u5f53\u524d\u7ebf\u7a0b\u7684\u6570\u636e\u5e93\u8fde\u63a5");
        }
        while (iter.hasNext()) {
            Object access = iter.next();
            DataStore ds = (DataStore)m.get(access);
            try {
                ds.finalize();
            }
            catch (Throwable e) {}
        }
        m.clear();
    }
}

