/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import com.dc.datastore.DataStoreInterface;
import com.dc.datastore.JDBCDataStoreImpl;
import com.dc.datastore.PMException;
import com.dc.datastore.PersistenceManager;
import com.dc.datastore.UserTransactionHelper;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataStore {
    private static Log logger = LogFactory.getLog((Class)DataStore.class);
    protected DataStoreInterface dsimpl;
    protected int ref = 0;
    Object tx_keepsake = null;
    private String name;

    public static DataStore getDataStore() {
        DataStore ds = null;
        if (ds == null) {
            JDBCDataStoreImpl dsimpl = new JDBCDataStoreImpl();
            ds = new DataStore(dsimpl);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u521b\u5efa" + ds));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("\u83b7\u53d6" + ds));
        }
        return ds;
    }

    protected DataStore(DataStoreInterface dsimpl) {
        this.dsimpl = dsimpl;
        this.ref = 0;
    }

    public PersistenceManager getPersistenceManager() {
        return this.dsimpl.getPersistenceManager();
    }

    public Connection getIndependentConnection() {
        return this.dsimpl.getIndependentConnection();
    }

    public Connection getIndependentConnection(String user, String password) {
        return this.dsimpl.getIndependentConnection(user, password);
    }

    public Connection getConnection() {
        return this.dsimpl.getConnection();
    }

    public Connection getConnection(String user, String password) {
        return this.dsimpl.getConnection(user, password);
    }

    public int commit(Object keepsake) throws PMException {
        if (keepsake != null && keepsake == this.tx_keepsake) {
            this.dsimpl.commit();
            this.close(true);
            this.tx_keepsake = null;
            return 0;
        }
        return 1;
    }

    public int rollback(Object keepsake) throws PMException {
        if (keepsake != null && keepsake == this.tx_keepsake) {
            this.dsimpl.rollback();
            this.close(true);
            this.tx_keepsake = null;
            return 0;
        }
        throw new PMException("LocalTransactionNeedRollback");
    }

    public Object begin() throws PMException {
        if (this.dsimpl.isGlobalTx()) {
            this.tx_keepsake = UserTransactionHelper.begin();
            return this.tx_keepsake;
        }
        if (this.tx_keepsake == null) {
            this.dsimpl.begin();
            this.tx_keepsake = new Object();
            return this.tx_keepsake;
        }
        return null;
    }

    public void rollbackAndResume() throws PMException {
        this.dsimpl.rollbackAndResume();
    }

    public void commitAndResume() {
        this.dsimpl.commitAndResume();
    }

    public void close() {
        this.release();
        this.close(false);
    }

    public void close(boolean force) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u91ca\u653e" + this));
        }
        if (force) {
            this.ref = 0;
            this.tx_keepsake = null;
            this.dsimpl.close();
        }
    }

    public void flush() {
        PersistenceManager pm = this.dsimpl.getPersistenceManager();
        if (pm != null) {
            pm.flush();
        }
    }

    private int addRef() {
        return ++this.ref;
    }

    private int release() {
        return --this.ref;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProperties(Properties p) {
        this.dsimpl.setProperties(p);
    }
}

