/*
 * Decompiled with CFR 0.152.
 */
package com.dc.datastore;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionPoolCreater {
    private static String WHEN_EXHAUSTED_BLOCK = "block";
    private static String WHEN_EXHAUSTED_FAIL = "fail";
    private static String WHEN_EXHAUSTED_GROW = "grow";

    public static void createPool(String url, String name, int maxActive, long maxWait, int maxIdle, String exhaustedAction, String user, String password) {
        GenericObjectPool connectionPool = null;
        if (url == null) {
            throw new IllegalArgumentException("null connection url");
        }
        if (name == null) {
            throw new IllegalArgumentException("null connection name");
        }
        connectionPool = exhaustedAction.equals(WHEN_EXHAUSTED_BLOCK) ? new GenericObjectPool(null, maxActive, 1, maxWait, maxIdle) : (exhaustedAction.equals(WHEN_EXHAUSTED_FAIL) ? new GenericObjectPool(null, maxActive, 0, maxWait, maxIdle) : (exhaustedAction.equals(WHEN_EXHAUSTED_GROW) ? new GenericObjectPool(null, maxActive, 2, maxWait, maxIdle) : new GenericObjectPool(null, maxActive, 1, maxWait, maxIdle)));
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, user, password);
        MyPCF poolableConnectionFactory = new MyPCF((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(name, (ObjectPool)connectionPool);
    }

    static class MyPCF
    extends PoolableConnectionFactory {
        public MyPCF(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) {
            super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit);
            this._defaultReadOnly = null;
        }
    }
}

