/*
 * Decompiled with CFR 0.152.
 */
package com.dc.concurrent;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.dc.concurrent.ExecuteException;
import com.dc.concurrent.Executor;
import com.dc.concurrent.ExecutorConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPooledExecutor
implements Executor {
    private static Log log = LogFactory.getLog((Class)DefaultPooledExecutor.class);
    private static final String ATTR_DEFAULT_SIZE = "default-size";
    private static final String ATTR_MAX_SIZE = "max-size";
    private static final String ATTR_MIN_SIZE = "min-size";
    private PooledExecutor executor;
    private ExecutorConfig config;

    public DefaultPooledExecutor(ExecutorConfig config) {
        this.config = config;
        this.executor = new PooledExecutor();
        this.executor.setMaximumPoolSize(Integer.parseInt(config.getAttribute(ATTR_MAX_SIZE)));
        this.executor.setMinimumPoolSize(Integer.parseInt(config.getAttribute(ATTR_MIN_SIZE)));
        this.executor.createThreads(Integer.parseInt(config.getAttribute(ATTR_DEFAULT_SIZE)));
    }

    public ExecutorConfig getConfig() {
        return this.config;
    }

    public void execute(Runnable task) {
        try {
            this.executor.execute(task);
        }
        catch (InterruptedException e) {
            ExecuteException ex = new ExecuteException();
            ex.addScene("exception", e);
            throw ex;
        }
    }

    public boolean shutdown(boolean flag) {
        return false;
    }
}

