/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.security;

import com.ccb.security.CCBSParameters;
import com.dc.eai.security.CryptMACBean;
import com.dc.security.Cipher;
import com.dc.security.Parameters;

public class CCBSCipher
implements Cipher {
    private String algorithm;
    private CCBSParameters parameters;
    private CryptMACBean crypt = new CryptMACBean();

    public CCBSCipher(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init() {
    }

    public void init(Parameters parameters) {
        this.init();
        this.parameters = (CCBSParameters)parameters;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] encrypt(byte[] input) {
        CryptMACBean.AttachSecurityNode(this.parameters.getSourceNodeID().getBytes());
        byte[] encrypted = this.crypt.GenEncrypt(this.parameters.getSourceNodeID(), input);
        CryptMACBean.DetachSecurityNode();
        return encrypted;
    }

    public byte[] decrypt(byte[] input) {
        CryptMACBean.AttachSecurityNode(this.parameters.getDestNodeID().getBytes());
        byte[] decrypted = this.crypt.GenDecrypt(this.parameters.getDestNodeID(), input);
        CryptMACBean.DetachSecurityNode();
        return decrypted;
    }

    public void cleanUp() {
    }

    public byte[] encrypt(byte[] input, Parameters parameters) {
        return null;
    }

    public byte[] decrypt(byte[] input, Parameters parameters) {
        return null;
    }
}

