/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.server.special;

import com.ccb.eai.dispatch.FillContext;
import com.ccb.eai.security.CCBSParameters;
import com.ccb.eai.server.special.Configable;
import com.dc.eai.adapter.Adapter;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.IOConfig;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import com.dc.eai.server.selfbyte.ServerSpecialProcess;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPSSSpecialProcess
implements ServerSpecialProcess,
Configable {
    private static final Log log = LogFactory.getLog((Class)IPSSSpecialProcess.class);
    private ServerConfig config;
    private Cipher cip;
    private CCBSParameters parameters;
    private static final int IS_SUCCESS = 0;

    public void setConfig(ServerConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.cip = CipherFactory.getCipher("CCBS");
        String local = System.getProperty("algorithm.dcc");
        ComponentManager cm = ComponentManagerGetter.getManager();
        Adapter adapter = (Adapter)cm.getComponent(this.config.getCommAdapter());
        String remote = adapter.getConfig().getAttribute("serverid");
        Context.getInstance().addProperty("temp_node_id", remote);
        this.parameters = new CCBSParameters(local, remote);
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        this.changeNodeId();
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultRequestPackageMode());
        IOConfig ioconfig = this.config.getRequestHeader().getIOConfig();
        converter.pack(packet, data, ioconfig);
        log.debug((Object)"========== \u7ec4\u62a5\u6587\u7ed3\u675f");
    }

    public byte[] beforeSendRequest(byte[] data) {
        return data;
    }

    public byte[] afterRecvResponse(byte[] data) {
        return data;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultResponsePackageMode());
        IOConfig ioconfig = this.config.getResponseHeader().getIOConfig();
        converter.unpack(packet, data, ioconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("========== \u62c6\u62a5\u6587\u7ed3\u675f\uff0c\u83b7\u5f97\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data));
        }
        FillContext.fillInContextServer(data);
    }

    public boolean isSuccess(byte[] buff, CompositeData data) {
        int status = NumberUtils.intValue(data.getField("SERVICE_STATUS").strValue());
        return status == 0;
    }

    private synchronized void changeNodeId() {
        String local = System.getProperty("algorithm.dcc");
        Context.getInstance().addProperty("local_node_id", local);
        String remote = (String)Context.getInstance().getProperty("temp_node_id");
        String temp = (String)Context.getInstance().getProperty("remote_node_id");
        Context.getInstance().addProperty("temp_node_id", temp);
        Context.getInstance().addProperty("remote_node_id", remote);
    }
}

