/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.server.special;

import com.ccb.eai.security.CCBSParameters;
import com.ccb.eai.server.special.Configable;
import com.dc.eai.adapter.Adapter;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.server.traditional.ServerSpecialProcess;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostSpecialProcess
implements ServerSpecialProcess,
Configable {
    private static final Log log = LogFactory.getLog((Class)HostSpecialProcess.class);
    private ServerConfig config;
    private Cipher cip;
    private CCBSParameters parameters;
    private static final int IS_SUCCESS = 0;

    public void setConfig(ServerConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.cip = CipherFactory.getCipher("CCBS");
        String local = System.getProperty("algorithm.dcc");
        ComponentManager cm = ComponentManagerGetter.getManager();
        Adapter adapter = (Adapter)cm.getComponent(this.config.getCommAdapter());
        String remote = adapter.getConfig().getAttribute("serverid");
        this.parameters = new CCBSParameters(local, remote);
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u5934\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getRequestHeader().getPackageMode());
        converter.pack(packet, data, this.config.getRequestHeader().getIOConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u5934\u7ed3\u675f");
        }
    }

    public byte[] beforeSendRequest(byte[] data) {
        PackUtils.put_int16(data, 8, data.length - 8);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5bf9\u4e3b\u673a\u62a5\u6587\u5f00\u59cb\u52a0\u5bc6\uff1a");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid :" + this.parameters.getLocalNodeID()));
            log.debug((Object)("remote nodeid :" + this.parameters.getRemoteNodeID()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u5f00\u59cb,\u52a0\u5bc6\u524d\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(data)));
        }
        byte[] out = data;
        byte[] result = new byte[out.length + 10];
        byte[] temp = this.parameters.getLocalNodeID().getBytes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid\uff1a" + StringUtils.bytesToString(temp)));
        }
        System.arraycopy(temp, 0, result, 0, temp.length);
        System.arraycopy(out, 0, result, 10, out.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(result)));
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u957f\u5ea6[length]=\uff1a" + result.length));
        }
        return result;
    }

    public byte[] afterRecvResponse(byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62a5\u6587\u89e3\u5bc6\u5f00\u59cb\uff1a");
        }
        return data;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u62a5\u6587\u5934\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getResponseHeader().getPackageMode());
        converter.unpack(packet, data, this.config.getResponseHeader().getIOConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)("========== \u62c6\u62a5\u6587\u5934\u7ed3\u675f\uff0c\u83b7\u5f97\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data.toString()));
        }
    }

    public boolean isSuccess(byte[] buff, CompositeData data) {
        int status = NumberUtils.intValue(data.getField("OPM_TX_STATUS").strValue());
        return status == 0;
    }
}

