/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.security;

import com.ccb.eai.security.CCBSParameters;
import com.ccb.eai.security.CryptPinFieldConverter;
import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.DataConvertException;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.data.Array;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.dispatch.Context;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.pack.PackUtils;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EBCCryptPinFieldConverter
extends DefaultFieldConverter {
    private static final Log log = LogFactory.getLog((Class)CryptPinFieldConverter.class);
    private Cipher cip;
    private Cipher midCip;

    public EBCCryptPinFieldConverter() {
        super("EBCCryptPin");
        this.init();
    }

    private void init() {
        this.cip = CipherFactory.getCipher("CCBSPIN");
        this.midCip = CipherFactory.getCipher("DES");
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        Array secgroup;
        Field fld = data.getField(config.getName());
        byte[] beforeMid = fld.imageValue();
        String value = new String(this.midCip.decrypt(beforeMid));
        byte[] converted = this.asc2ebcdic(value);
        if (converted == null) {
            throw new DataConvertException("DES\u89e3\u5bc6\u540eASCII\u5b57\u7b26\u4e32\u8f6c\u6210EBCDIC\u7801\u51fa\u9519!");
        }
        String localNodeId = (String)Context.getInstance().getProperty("local_node_id");
        String remoteNodeId = (String)Context.getInstance().getProperty("remote_node_id");
        CCBSParameters param = new CCBSParameters(localNodeId, remoteNodeId);
        byte[] out = this.cip.encrypt(value.getBytes(), param);
        int length = out.length;
        packet.ensure(length);
        System.arraycopy(out, 0, packet.getBuff(), packet.getOffset(), length);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5c06\u57df\u504f\u79fb\u548c\u957f\u5ea6\u4fe1\u606f\u52a0\u5165secgroup\u4e2d");
        }
        if ((secgroup = data.getArray("secgroup")) == null) {
            secgroup = new Array();
            data.addArray("secgroup", secgroup);
        }
        CompositeData pin = new CompositeData();
        Field offset = new Field(new FieldAttr(FieldType.FIELD_IMAGE, 2));
        byte[] buff = new byte[2];
        PackUtils.put_int16(buff, 0, packet.getOffset());
        pin.addField("INM_SEC_OFFSET", offset);
        Field len = new Field(new FieldAttr(FieldType.FIELD_IMAGE, 2));
        byte[] len_buff = new byte[2];
        PackUtils.put_int16(len_buff, 0, length);
        pin.addField("INM_SEC_LENGTH", len);
        secgroup.addStruct(pin);
        packet.advance(length);
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        int length = config.getLength();
        if (packet.exceed(length)) {
            throw this.PacketLenOverflowException(packet, length);
        }
        byte[] source = new byte[length];
        System.arraycopy(packet.getBuff(), packet.getOffset(), source, 0, length);
        packet.advance(length);
        String localNodeId = System.getProperty("local_node_id");
        String remoteNodeId = (String)Context.getInstance().getProperty("remote_node_id");
        CCBSParameters param = new CCBSParameters(localNodeId, remoteNodeId);
        byte[] target = this.cip.decrypt(source, param);
        String conv = null;
        PackUtils.put_string(target, 0, conv, target.length);
        byte[] converted = conv.getBytes();
        byte[] afterMid = this.midCip.encrypt(converted);
        Field fld = new Field(new FieldAttr(FieldType.FIELD_IMAGE, afterMid.length));
        fld.setValue(afterMid);
        data.addField(config.getName(), fld);
    }

    private byte[] asc2ebcdic(String source) {
        try {
            byte[] conv = source.getBytes("cp935");
            return conv;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

