/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.security;

import com.ccb.eai.security.CCBSParameters;
import com.ccb.eai.security.CipherException;
import com.dc.security.Cipher;
import com.dc.security.Parameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CCBSPinCipher
implements Cipher {
    private static final Log log = LogFactory.getLog((Class)CCBSPinCipher.class);
    private String algorithm;

    private static native int EncryptPIN(byte[] var0, byte[] var1, int var2, byte[] var3);

    private static native int DecryptPIN(byte[] var0, byte[] var1, int var2, byte[] var3);

    private static native int AttachSecurityNode(byte[] var0);

    private static native int DetachSecurityNode();

    public String getAlgorithm() {
        return this.algorithm;
    }

    public CCBSPinCipher(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init() {
    }

    public void init(Parameters parameters) {
        this.init();
    }

    private byte[] EncryptPIN(String NodeID2, byte[] in) throws CipherException {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        int result = 0;
        byte[] out = new byte[len];
        try {
            result = CCBSPinCipher.EncryptPIN(node_id, in, len, out);
        }
        catch (Exception e) {
            CipherException ex = new CipherException("CRY00003", e);
            throw ex;
        }
        if (result != 0) {
            CipherException ex = new CipherException("CRY00003");
            ex.addScene("EncryptPINRv", result);
            throw ex;
        }
        return out;
    }

    private byte[] DecryptPIN(String NodeID2, byte[] in) throws CipherException {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        byte[] out = new byte[len];
        int result = 0;
        try {
            result = CCBSPinCipher.DecryptPIN(node_id, in, len, out);
            if (log.isDebugEnabled()) {
                log.debug((Object)("DecryptPIN result: " + result));
            }
        }
        catch (Exception e) {
            CipherException ex = new CipherException("CRY00004");
            throw ex;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("DecryptPIN out:" + out));
            log.debug((Object)("DecryptPIN outLength:" + out.length));
        }
        if (result != 0) {
            CipherException ex = new CipherException("CRY00004");
            throw ex;
        }
        return out;
    }

    public byte[] encrypt(byte[] input) {
        return null;
    }

    public byte[] decrypt(byte[] input) {
        return null;
    }

    public synchronized byte[] encrypt(byte[] input, Parameters parameters) {
        String localNodeId = ((CCBSParameters)parameters).getLocalNodeID();
        String remoteNodeId = ((CCBSParameters)parameters).getRemoteNodeID();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("encrypt: local[" + localNodeId + "] remote[" + remoteNodeId + "] plain-len [" + input.length + "]"));
            }
            CCBSPinCipher.AttachSecurityNode(localNodeId.getBytes());
            byte[] encrypted = this.EncryptPIN(remoteNodeId, input);
            CCBSPinCipher.DetachSecurityNode();
            return encrypted;
        }
        catch (CipherException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"CCBS\u52a0\u5bc6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!");
            }
            e.printStackTrace();
            return null;
        }
    }

    public synchronized byte[] decrypt(byte[] input, Parameters parameters) {
        String localNodeId = ((CCBSParameters)parameters).getLocalNodeID();
        String remoteNodeId = ((CCBSParameters)parameters).getRemoteNodeID();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("decrypt: local[" + localNodeId + "] remote[" + remoteNodeId + "] crypt-len [" + input.length + "]"));
            }
            CCBSPinCipher.AttachSecurityNode(localNodeId.getBytes());
            byte[] decrypted = this.DecryptPIN(remoteNodeId, input);
            CCBSPinCipher.DetachSecurityNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("decrypted:" + decrypted));
            }
            return decrypted;
        }
        catch (CipherException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"CCBS\u89e3\u5bc6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!");
            }
            e.printStackTrace();
            return null;
        }
    }

    public void cleanUp() {
    }

    static {
        try {
            System.loadLibrary("security");
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot load secrity shared lib in (java.library.path[" + System.getProperty("java.library.path") + "])");
        }
    }
}

