/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.security;

import com.ccb.eai.security.CCBSParameters;
import com.ccb.eai.security.CipherException;
import com.dc.security.Cipher;
import com.dc.security.Parameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CCBSCipher
implements Cipher {
    private static final Log log = LogFactory.getLog((Class)CCBSCipher.class);
    private String algorithm;

    private static native int GenEncrypt(byte[] var0, byte[] var1, int var2, byte[] var3);

    private static native int GenDecrypt(byte[] var0, byte[] var1, int var2, byte[] var3);

    private static native int AttachSecurityNode(byte[] var0);

    private static native int DetachSecurityNode();

    public String getAlgorithm() {
        return this.algorithm;
    }

    public CCBSCipher(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init() {
    }

    public void init(Parameters parameters) {
        this.init();
    }

    private byte[] GenEncrypt(String NodeID2, byte[] in) {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        int result = 0;
        byte[] out = new byte[len + 32];
        try {
            result = CCBSCipher.GenEncrypt(node_id, in, len, out);
        }
        catch (Exception e) {
            CipherException ex = new CipherException("CRY00001");
            throw ex;
        }
        if (result != 0) {
            CipherException ex = new CipherException("CRY00001");
            ex.addScene("EncryptRv", result);
            throw ex;
        }
        return out;
    }

    private byte[] GenDecrypt(String NodeID2, byte[] in) throws CipherException {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        byte[] out = new byte[len - 32];
        int result = 0;
        try {
            result = CCBSCipher.GenDecrypt(node_id, in, len, out);
        }
        catch (Exception e) {
            CipherException ex = new CipherException("CRY00002", e);
            throw ex;
        }
        if (result != 0) {
            CipherException ex = new CipherException("CRY00002");
            ex.addScene("DecryptRv", result);
            throw ex;
        }
        return out;
    }

    public byte[] encrypt(byte[] input) {
        return null;
    }

    public byte[] decrypt(byte[] input) {
        return null;
    }

    public synchronized byte[] encrypt(byte[] input, Parameters parameters) {
        String localNodeId = ((CCBSParameters)parameters).getLocalNodeID();
        String remoteNodeId = ((CCBSParameters)parameters).getRemoteNodeID();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("encrypt: local[" + localNodeId + "] remote[" + remoteNodeId + "] plain-len [" + input.length + "]"));
            }
            CCBSCipher.AttachSecurityNode(localNodeId.getBytes());
            byte[] encrypted = this.GenEncrypt(remoteNodeId, input);
            CCBSCipher.DetachSecurityNode();
            return encrypted;
        }
        catch (CipherException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"CCBS\u52a0\u5bc6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!");
            }
            e.printStackTrace();
            return null;
        }
    }

    public synchronized byte[] decrypt(byte[] input, Parameters parameters) {
        String localNodeId = ((CCBSParameters)parameters).getLocalNodeID();
        String remoteNodeId = ((CCBSParameters)parameters).getRemoteNodeID();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("decrypt: local[" + localNodeId + "] remote[" + remoteNodeId + "] crypt-len [" + input.length + "]"));
            }
            CCBSCipher.AttachSecurityNode(localNodeId.getBytes());
            byte[] decrypted = this.GenDecrypt(remoteNodeId, input);
            CCBSCipher.DetachSecurityNode();
            return decrypted;
        }
        catch (CipherException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"CCBS\u89e3\u5bc6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!");
            }
            e.printStackTrace();
            return null;
        }
    }

    public void cleanUp() {
    }

    static {
        try {
            System.loadLibrary("security");
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot load secrity shared lib in (java.library.path[" + System.getProperty("java.library.path") + "])");
        }
    }
}

