/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.pack.serialized;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.DataConvertException;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.Packet;
import com.dc.eai.conv.PacketException;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializedPackageConverter
implements PackageConverter {
    private static final Log log = LogFactory.getLog((Class)SerializedPackageConverter.class);
    private String storeMode;

    public void setStoreMode(String storeMode) {
        this.storeMode = storeMode;
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u7ec4\u5305\u5f00\u59cb");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u53d8\u91cf\u4e2a\u6570\u672a\u77e5,\u62a5\u6587\u5934\u7559\u51fa\u56db\u4e2a\u5b57\u8282,\u5f85\u660e\u786e\u53d8\u91cf\u4e2a\u6570\u540e\u8865\u5165");
        }
        packet.ensure(4);
        packet.advance(4);
        int counter = 0;
        Iterator variableNameList = data.iterator();
        while (variableNameList.hasNext()) {
            String variableName = (String)variableNameList.next();
            AtomData value = data.getObject(variableName);
            if (value.isField()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u53d8\u91cf" + variableName + "\u4e3a\u5355\u4e2a\u57df,\u76f4\u63a5\u7ec4\u5165\u62a5\u6587\u5373\u53ef"));
                }
                Field field = (Field)value;
                this.putVariable(packet, variableName, field, config);
                ++counter;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("\u53d8\u91cf" + variableName + "\u6210\u529f\u7ec4\u5165\u62a5\u6587\n"));
                continue;
            }
            if (!value.isArray()) continue;
            Array dataArray = (Array)value;
            int size = dataArray.size();
            if (dataArray.getObject(0).isField()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u7ec4\u6570\u7ec4" + variableName + "\u5f00\u59cb"));
                }
                for (int i = 0; i < size; ++i) {
                    String name = variableName + "#" + i;
                    Field field = dataArray.getField(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u7ec4\u6570\u7ec4\u53d8\u91cf" + name + "\u5f00\u59cb"));
                    }
                    this.putVariable(packet, name, field, config);
                    ++counter;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("\u7ec4\u6570\u7ec4\u53d8\u91cf" + name + "\u6210\u529f\n"));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("\u7ec4\u6570\u7ec4" + variableName + "\u6210\u529f\n"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4Group" + variableName + "\u5f00\u59cb"));
            }
            String groupName = variableName + "##";
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4Group\u53d8\u91cf" + groupName + "\u5f00\u59cb"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7ec4\u53d8\u91cf\u540d");
            }
            this.putString(packet, groupName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7ec4\u53d8\u91cf\u7c7b\u578b\u7801,\u6b64\u5904\u7ec4\u5165\u6574\u578b\u7c7b\u578b\u7801,\u4e3a3");
            }
            this.putInt(packet, 3);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7ec4\u53d8\u91cf\u503c,\u6b64\u5904\u7ec4\u5165Group\u7684size");
            }
            this.putInt(packet, size);
            ++counter;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4Group\u53d8\u91cf" + groupName + "\u6210\u529f\n"));
            }
            for (int i = 0; i < size; ++i) {
                CompositeData dataStruct = dataArray.getStruct(i);
                Iterator fieldList = dataStruct.iterator();
                while (fieldList.hasNext()) {
                    String fieldName = (String)fieldList.next();
                    String name = variableName + "." + fieldName + "#" + i;
                    Field field = dataStruct.getField(fieldName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u7ec4Group\u7684\u5143\u7d20\u53d8\u91cf" + name + "\u5f00\u59cb"));
                    }
                    this.putVariable(packet, name, field, config);
                    ++counter;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("\u7ec4Group\u7684\u5143\u7d20\u53d8\u91cf" + name + "\u6210\u529f\n"));
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\u7ec4Group" + variableName + "\u6210\u529f\n"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8865\u5165\u53d8\u91cf\u4e2a\u6570:" + counter));
        }
        PackUtils.put_int32(packet.getBuff(), 0, counter);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u7ec4\u5305\u6210\u529f");
        }
    }

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        if (packet.getOffset() == packet.getLength()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u5f53\u524d\u504f\u79fb\u5df2\u8fbe\u62a5\u6587\u5c3e\uff0c\u8868\u660e\u62a5\u6587\u5df2\u7ecf\u62c6\u597d!");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u62c6\u5305\u5f00\u59cb");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62c6\u51fa\u57df\u4e2a\u6570\u5f00\u59cb");
        }
        int fieldNum = this.getInt(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62c6\u51fa\u57df\u4e2a\u6570\u6210\u529f\uff0c\u4e2a\u6570\u4e3a[" + fieldNum + "]"));
        }
        String groupName = null;
        int groupSize = 0;
        for (int i = 0; i < fieldNum; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u62c6\u7b2c" + (i + 1) + "\u4e2a\u57df\u5f00\u59cb"));
            }
            String fieldName = this.getString(packet);
            int fieldType = this.getInt(packet);
            Field value = this.getField(fieldType, fieldName, packet, config);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6210\u529f\u62c6\u51fa\u7b2c" + (i + 1) + "\u4e2a\u57df,\u57df\u540d[" + fieldName + "],value=" + value));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5c06\u62c6\u51fa\u7684value\u653e\u5165data\u4e2d");
            }
            if (fieldName.indexOf(35) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u8be5\u57df\u4e3aField,\u76f4\u63a5\u52a0\u5165data\u4e2d\u5373\u53ef");
                }
                data.addField(fieldName, value);
            } else if (this.isArrayElement(fieldName)) {
                String arrayName = fieldName.substring(0, fieldName.indexOf(35));
                String sIndex = fieldName.substring(fieldName.indexOf(35) + 1);
                int index = Integer.parseInt(sIndex);
                if (index == 0) {
                    data.addArray(arrayName, new Array());
                }
                data.getArray(arrayName).addField(value);
            } else if (this.isGroupElement(fieldName)) {
                if (fieldName.indexOf("##") >= 0) {
                    groupName = fieldName.substring(0, fieldName.indexOf(35));
                    data.addArray(groupName, new Array());
                    groupSize = value.intValue();
                } else {
                    if (groupName == null || groupSize == 0) {
                        throw new RuntimeException("\u5728\u8fdb\u5165Group\u503c\u57df\u4e4b\u524d,groupName\u548cgroupSize\u5e94\u5df2\u88ab\u521d\u59cb\u5316!");
                    }
                    String sIndex = fieldName.substring(fieldName.indexOf(35) + 1);
                    int index = Integer.parseInt(sIndex);
                    if (index + 1 > groupSize) {
                        throw new RuntimeException("\u5faa\u73af\u5e8f\u53f7[+1,\u5e8f\u53f7\u4ece0\u5f00\u59cb]\u8d85\u51fa\u62a5\u6587\u4e2d\u5b9a\u4e49\u7684\u5faa\u73af\u6b21\u6570,index=" + index + ",groupSize=" + groupSize);
                    }
                    int counter = data.getArray(groupName).size();
                    if (index + 1 > counter) {
                        data.getArray(groupName).addStruct(new CompositeData());
                    }
                    CompositeData struct = data.getArray(groupName).getStruct(index);
                    String realFieldName = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.indexOf(35));
                    struct.addField(realFieldName, value);
                }
            } else {
                throw new RuntimeException("\u9519\u8bef\u7684\u57df\u540d!fieldName=" + fieldName);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"\u62c6\u51fa\u7684value\u653e\u5165data\u4e2d\u6210\u529f");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u62c6\u5305\u6210\u529f!");
        }
    }

    private FieldConverter getConverter(String name, IOConfig config) {
        FieldConverter converter = FieldConverterFactory.getInstance().getFieldConverter(this.storeMode);
        int counter = config.size();
        while (--counter > 0) {
            FieldIOConfig fieldioconfig;
            Object o = config.getObject(counter);
            if (!(o instanceof FieldIOConfig) || !(fieldioconfig = (FieldIOConfig)o).getName().equals(name)) continue;
            converter = FieldConverterFactory.getInstance().getFieldConverter(fieldioconfig.getStoreMode());
            break;
        }
        return converter;
    }

    private void putInt(OutputPacket packet, int value) {
        packet.ensure(4);
        PackUtils.put_int32(packet.getBuff(), packet.getOffset(), value);
        packet.advance(4);
    }

    private void putString(OutputPacket packet, String value) {
        this.putInt(packet, value.length());
        packet.ensure(value.length());
        PackUtils.put_string(packet.getBuff(), packet.getOffset(), value, value.length());
        packet.advance(value.length());
    }

    private void putStringWithConverter(OutputPacket packet, String name, Field field, IOConfig config) {
        FieldIOConfig fieldconfig = new FieldIOConfig();
        fieldconfig.setName("putStringWithConverter");
        fieldconfig.setType(field.getFieldType());
        fieldconfig.setLength(field.getAttr().getLength());
        fieldconfig.setScale(field.getAttr().getScale());
        fieldconfig.setStoreMode(this.storeMode);
        CompositeData data = new CompositeData();
        data.addField("putStringWithConverter", field);
        FieldConverter converter = this.getConverter(name, config);
        OutputPacket tmpPacket = new OutputPacket();
        converter.pack(tmpPacket, data, fieldconfig);
        int length = tmpPacket.getOffset();
        this.putInt(packet, length);
        packet.ensure(length);
        System.arraycopy(tmpPacket.getBuff(), 0, packet.getBuff(), packet.getOffset(), length);
        packet.advance(length);
    }

    private int convTypeCode(FieldType fieldType) {
        int typeCode = 3;
        if (fieldType == FieldType.FIELD_STRING) {
            typeCode = 7;
        } else if (fieldType == FieldType.FIELD_DOUBLE) {
            typeCode = 6;
        } else if (fieldType == FieldType.FIELD_BYTE) {
            typeCode = 20;
        } else if (fieldType == FieldType.FIELD_IMAGE) {
            typeCode = 8;
        }
        return typeCode;
    }

    private void putTypeCode(OutputPacket packet, FieldType type) {
        int typeCode = this.convTypeCode(type);
        this.putInt(packet, typeCode);
    }

    private void putValue(OutputPacket packet, String name, Field field, IOConfig config) {
        int typeCode = this.convTypeCode(field.getFieldType());
        switch (typeCode) {
            case 3: {
                if (field.getFieldType() == FieldType.FIELD_SHORT) {
                    this.putInt(packet, field.shortValue());
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("\u53d8\u91cf\u503c\u4e3a:" + field.shortValue()));
                    break;
                }
                this.putInt(packet, field.intValue());
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u53d8\u91cf\u503c\u4e3a:" + field.intValue()));
                break;
            }
            case 6: {
                double doubleValue = field.doubleValue();
                this.putString(packet, Double.toString(doubleValue));
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u53d8\u91cf\u503c\u4e3a:" + Double.toString(doubleValue)));
                break;
            }
            case 7: {
                this.putStringWithConverter(packet, name, field, config);
                break;
            }
            case 8: {
                byte[] imageValue = field.imageValue();
                int length = imageValue.length;
                this.putInt(packet, length);
                packet.ensure(length);
                System.arraycopy(imageValue, 0, packet.getBuff(), packet.getOffset(), length);
                packet.advance(length);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u53d8\u91cf\u503c\u4e3a:" + StringUtils.bytesToString(imageValue)));
                break;
            }
            case 20: {
                this.putInt(packet, field.byteValue());
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u53d8\u91cf\u503c\u4e3a:" + field.byteValue()));
                break;
            }
            default: {
                throw new PacketException("SerializedPackage_FieldType_Err");
            }
        }
    }

    private void putVariable(OutputPacket packet, String name, Field field, IOConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u53d8\u91cf\u540d:" + name));
        }
        this.putString(packet, name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u53d8\u91cf\u7c7b\u578b\u7801:" + this.convTypeCode(field.getFieldType())));
        }
        this.putTypeCode(packet, field.getFieldType());
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u53d8\u91cf\u503c");
        }
        this.putValue(packet, name, field, config);
    }

    private int getInt(InputPacket packet) {
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        int fieldValue = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        return fieldValue;
    }

    private String getString(InputPacket packet) {
        int length = this.getInt(packet);
        if (packet.exceed(length)) {
            throw this.PacketLenOverflowException(packet, length);
        }
        String value = PackUtils.get_string(packet.getBuff(), packet.getOffset(), length);
        packet.advance(length);
        return value;
    }

    private Field getStringWithConverter(InputPacket packet, String name, IOConfig config) {
        int length = this.getInt(packet);
        FieldConverter converter = this.getConverter(name, config);
        CompositeData tempData = new CompositeData();
        FieldIOConfig fieldconfig = new FieldIOConfig();
        fieldconfig.setName("getStringWithConverter");
        fieldconfig.setLength(length);
        fieldconfig.setType(FieldType.FIELD_STRING);
        converter.unpack(packet, tempData, fieldconfig);
        return tempData.getField("getStringWithConverter");
    }

    private byte[] getImage(InputPacket packet) {
        int length = this.getInt(packet);
        if (packet.exceed(length)) {
            throw this.PacketLenOverflowException(packet, length);
        }
        byte[] value = new byte[length];
        System.arraycopy(packet.getBuff(), packet.getOffset(), value, 0, length);
        packet.advance(length);
        return value;
    }

    private Field getField(int fieldType, String fieldName, InputPacket packet, IOConfig config) {
        Field value;
        switch (fieldType) {
            case 3: {
                int fieldIntValue = this.getInt(packet);
                value = new Field(new FieldAttr(FieldType.FIELD_INT, 4));
                value.setValue(fieldIntValue);
                break;
            }
            case 20: {
                int fieldIntValue = this.getInt(packet);
                value = new Field(new FieldAttr(FieldType.FIELD_BYTE, 1));
                value.setValue(fieldIntValue);
                break;
            }
            case 6: {
                String fieldStringValue = this.getString(packet);
                int length = fieldStringValue.length();
                int scale = 0;
                if (fieldStringValue.indexOf(43) >= 0 || fieldStringValue.indexOf(45) >= 0) {
                    --length;
                }
                if (fieldStringValue.indexOf(46) > 0) {
                    --length;
                    scale = fieldStringValue.length() - fieldStringValue.indexOf(46) - 1;
                }
                double fieldDoubleValue = NumberUtils.doubleValue(fieldStringValue);
                value = new Field(new FieldAttr(FieldType.FIELD_DOUBLE, length, scale));
                value.setValue(fieldDoubleValue);
                break;
            }
            case 7: {
                value = this.getStringWithConverter(packet, fieldName, config);
                break;
            }
            case 8: {
                byte[] bv = this.getImage(packet);
                FieldAttr fieldattr = new FieldAttr(FieldType.FIELD_IMAGE, bv.length);
                value = new Field(fieldattr);
                value.setValue(bv);
                break;
            }
            default: {
                throw new PacketException("SerializedPackage_FieldType_Err");
            }
        }
        return value;
    }

    private boolean isArrayElement(String fieldName) {
        return fieldName.indexOf(35) >= 0 && fieldName.indexOf("##") < 0 && fieldName.indexOf(46) < 0;
    }

    private boolean isGroupElement(String fieldName) {
        return fieldName.indexOf("##") >= 0 || fieldName.indexOf(35) > 0 && fieldName.indexOf(46) > 0;
    }

    private RuntimeException PacketLenOverflowException(Packet packet, int length) {
        DataConvertException e = new DataConvertException("PacketLenOverflow");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("RequestLen", length);
        return e;
    }
}

