/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.pack.eaih;

import com.dc.eai.config.DataDictionary;
import com.dc.eai.config.DictionaryItem;
import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.dispatch.Context;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EAIHPackageConverter
implements PackageConverter {
    private static final Log log = LogFactory.getLog((Class)EAIHPackageConverter.class);
    private static final String EAIH_TAG = "Transaction";
    private static final String HEADER_TAG = "Transaction_Header";
    private static final String BODY_TAG = "Transaction_Body";
    private static final String REQUEST_TAG = "request";
    private static final String RESPONSE_TAG = "response";
    private static final BASE64Encoder encoder = new BASE64Encoder();
    private static final BASE64Decoder decoder = new BASE64Decoder();
    private static final DataDictionary dict = DataDictionary.instance();

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        int length = packet.getLength();
        int offset = packet.getOffset();
        if (length == 0 || offset == length) {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u8f93\u5165\u62a5\u6587\u4e3a\u7a7a\u6216\u62a5\u6587\u5df2\u62c6\u89e3\u5b8c\u6bd5");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5f00\u59cb\u62c6\u89e3EAIH\u62a5\u6587");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06\u8f93\u5165\u62a5\u6587\u4e2d\u7684\u5b57\u8282\u6570\u7ec4\u8f6c\u6362\u4e3aCommonData");
        }
        byte[] xmlData = packet.getBuff();
        XMLCommonData root = new XMLCommonData();
        XMLoader.load((CommonData)root, xmlData);
        packet.advance(length);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5bf9\u4e0a\u9762\u751f\u6210\u7684CommonData\u8fdb\u884c\u6821\u9a8c");
        }
        if (!EAIHPackageConverter.check(root.getChild(0))) {
            throw new RuntimeException("");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06CommonData\u8f6c\u6362\u4e3aCompositeData");
        }
        this.CommonData2CompositeData(root, data, config);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u62c6\u89e3EAIH\u62a5\u6587\u6210\u529f\uff0c\u5f97\u5230\u7684\u6570\u636e\u4e3a:\n" + data));
        }
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5f00\u59cb\u7ec4EAIH\u62a5\u6587");
        }
        XMLCommonData root = new XMLCommonData();
        CommonData eaih = root.addChild(EAIH_TAG);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u53d6\u4e0a\u4e0b\u6587\u4e2d\u76f8\u5173\u4fe1\u606f\u7ec4\u62a5\u6587\u5934CommonData");
        }
        CommonData header = eaih.addChild(HEADER_TAG);
        Context ctx = Context.getInstance();
        if (ctx.getPkgType() == null || ctx.getServiceStatus() == null || ctx.getTimeConsumed() == 0) {
            throw new RuntimeException("\u5b57\u6bb5pkgType[\u62a5\u6587\u7c7b\u578b],serviceStatus[\u670d\u52a1\u72b6\u6001],timeConsumed[\u6267\u884c\u65f6\u95f4]\u4e3a\u5fc5\u586b\u62a5\u6587\u5934\u5b57\u6bb5");
        }
        CommonData header_element = header.addChild("pkg_type");
        header_element.setValue(ctx.getPkgType());
        header_element = header.addChild("service_status");
        header_element.setValue(ctx.getServiceStatus());
        header_element = header.addChild("time_consumed");
        header_element.setValue("" + ctx.getTimeConsumed());
        CommonData opt_header_element = null;
        if (ctx.getRespTraceNo() != null) {
            opt_header_element = header.addChild("resp_trace_no");
            opt_header_element.setValue(ctx.getRespTraceNo());
        }
        if (ctx.getRespCode() != null) {
            opt_header_element = header.addChild("resp_code");
            opt_header_element.setValue(ctx.getRespCode());
        }
        if (ctx.getRespDesc() != null) {
            opt_header_element = header.addChild("resp_desc");
            opt_header_element.setValue(ctx.getRespDesc());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06CompositeData\u8f6c\u6362\u4e3a\u62a5\u6587\u4f53CommonData");
        }
        EAIHPackageConverter.storeBody(eaih, data, config);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06CommonData\u5b57\u8282\u6570\u7ec4\u7f6e\u5165\u8f93\u51fa\u62a5\u6587");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLoader.store((CommonData)root, out);
        byte[] xmlData = out.toByteArray();
        int length = xmlData.length;
        packet.ensure(length);
        System.arraycopy(xmlData, 0, packet.getBuff(), packet.getOffset(), length);
        packet.advance(length);
        if (log.isInfoEnabled()) {
            byte[] realbuff = new byte[packet.getOffset()];
            System.arraycopy(packet.getBuff(), 0, realbuff, 0, packet.getOffset());
            log.info((Object)("\u7ec4EAIH\u62a5\u6587\u6210\u529f,\u7ec4\u597d\u7684\u62a5\u6587\u5185\u5bb9\u4e3a:\n" + new String(realbuff)));
        }
    }

    private void CommonData2CompositeData(CommonData root, CompositeData compData, IOConfig config) {
        CommonData eaihData = root.getChild(EAIH_TAG);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u62a5\u6587\u5934");
        }
        EAIHPackageConverter.populateSet(HEADER_TAG, eaihData, compData, config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62c6\u89e3\u62a5\u6587\u5934\u540e\u5f97\u5230\u7684\u7edf\u4e00\u63a5\u53e3\u6570\u636e\u4e3a:\n" + compData.getStruct(HEADER_TAG)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u62a5\u6587\u4f53");
        }
        CompositeData bodyData = new CompositeData();
        compData.addStruct(BODY_TAG, bodyData);
        CommonData body = eaihData.getChild(BODY_TAG);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u62a5\u6587\u4f53request\u90e8\u5206");
        }
        EAIHPackageConverter.populateSet(REQUEST_TAG, body, bodyData, config);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u62a5\u6587\u4f53response\u90e8\u5206");
        }
        EAIHPackageConverter.populateSet(RESPONSE_TAG, body, bodyData, config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62c6\u89e3\u62a5\u6587\u4f53\u540e\u5f97\u5230\u7684\u7edf\u4e00\u63a5\u53e3\u6570\u636e\u4e3a:\n" + bodyData));
        }
    }

    private static Field getField(CommonData commonData, IOConfig config) {
        Field field;
        FieldIOConfig fieldIOConfig;
        String fieldName = commonData.getName();
        String strValue = (String)commonData.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5f00\u59cb\u5c06CommonData\u8282\u70b9[" + fieldName + "]\u8f6c\u6362\u6210\u540c\u540d\u7684Field"));
        }
        if ((fieldIOConfig = EAIHPackageConverter.getFieldIOConfig(fieldName, config)) != null) {
            FieldConverter converter = FieldConverterFactory.getInstance().getFieldConverter(fieldIOConfig.getStoreMode());
            InputPacket inputPacket = new InputPacket(strValue.getBytes());
            CompositeData tempCompData = new CompositeData();
            converter.unpack(inputPacket, tempCompData, fieldIOConfig);
            field = tempCompData.getField(fieldIOConfig.getName());
        } else {
            DictionaryItem item = dict.getItem(fieldName);
            if (item == null) {
                throw new RuntimeException("\u57df[" + fieldName + "]\u5728\u5b57\u5178\u4e2d\u6ca1\u6709\u5b9a\u4e49");
            }
            FieldType fieldType = item.getType();
            int length = item.getLength();
            int scale = item.getScale();
            FieldAttr fieldAttr = new FieldAttr(fieldType, length, scale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5b57\u5178\u4e2d\u5bf9\u57df[" + fieldName + "]\u7684\u5b9a\u4e49:fieldType[" + fieldType + "];length[" + length + "];scale[" + scale + "]."));
            }
            field = new Field(fieldAttr);
            if (strValue == null || strValue.equals("")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u57df\u503c\u5bf9\u5e94\u7684\u5b57\u7b26\u4e32\u4e3anull\u6216\u7a7a\u4e32,\u6570\u503c\u578b\u5904\u7406\u4e3a0,image\u578b\u5904\u7406\u4e3abyte[0],\u5b57\u7b26\u4e32\u5904\u7406\u4e3a\u7a7a\u4e32");
                }
                if (FieldType.numberType(fieldType)) {
                    field.setValue(0);
                } else if (fieldType == FieldType.FIELD_IMAGE) {
                    field.setValue(new byte[0]);
                } else {
                    field.setValue("");
                }
                return field;
            }
            if (fieldType == FieldType.FIELD_BYTE) {
                byte value = (byte)NumberUtils.intValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_DOUBLE) {
                double value = NumberUtils.doubleValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_FLOAT) {
                float value = (float)NumberUtils.doubleValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT) {
                int value = NumberUtils.intValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT24 || fieldType == FieldType.FIELD_LONG) {
                long value = NumberUtils.longValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_SHORT) {
                short value = (short)NumberUtils.intValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + value));
                }
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_IMAGE) {
                try {
                    byte[] value = decoder.decodeBuffer(strValue);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u57df\u503c\u4e3a:" + StringUtils.bytesToString(value)));
                    }
                    field.setValue(value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                field.setValue(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u57df\u503c\u4e3a:" + strValue));
                }
            }
        }
        return field;
    }

    private static void populateElement(CommonData commonData, CompositeData compData, IOConfig config) {
        String p_type;
        String name = commonData.getName();
        if (commonData.getAttribute("p_type") != null && (p_type = (String)commonData.getAttribute("p_type")).equalsIgnoreCase("G")) {
            EAIHPackageConverter.populateSet(name, commonData.getParent(), compData, config);
            return;
        }
        Field value = EAIHPackageConverter.getField(commonData, config);
        if (compData.contains(name)) {
            AtomData atom = compData.getObject(name);
            if (atom instanceof Field) {
                Field field = (Field)atom;
                Array array = new Array();
                array.addField(field);
                array.addField(value);
                compData.addArray(name, array);
            } else if (atom instanceof Array) {
                Array array = (Array)atom;
                array.addField(value);
            }
        } else {
            compData.addField(name, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void populateSet(String tagName, CommonData parentCommonData, CompositeData parentCompData, IOConfig config) {
        CompositeData compData = new CompositeData();
        if (parentCompData.contains(tagName)) {
            AtomData atom = parentCompData.getObject(tagName);
            if (!(atom instanceof CompositeData)) throw new RuntimeException("");
            Array array = new Array();
            array.addStruct((CompositeData)atom);
            array.addStruct(compData);
            parentCompData.addArray(tagName, array);
        } else {
            parentCompData.addStruct(tagName, compData);
        }
        CommonData commonData = parentCommonData.getChild(tagName);
        int count = commonData.childCount();
        for (int i = 0; i < count; ++i) {
            CommonData element = commonData.getChild(i);
            EAIHPackageConverter.populateElement(element, compData, config);
        }
    }

    private static boolean check(CommonData commonData) {
        return true;
    }

    private static void storeBody(CommonData commonData, CompositeData compData, IOConfig config) {
        CommonData body = commonData.addChild(BODY_TAG);
        CommonData reqCommonData = body.addChild(REQUEST_TAG);
        CompositeData reqCompData = compData.getStruct(REQUEST_TAG);
        EAIHPackageConverter.storeStruct(reqCommonData, "", reqCompData, config);
        CommonData respCommonData = body.addChild(RESPONSE_TAG);
        CompositeData respCompData = compData.getStruct(RESPONSE_TAG);
        EAIHPackageConverter.storeStruct(respCommonData, "", respCompData, config);
    }

    private static void storeStruct(CommonData commonData, String name, CompositeData compData, IOConfig config) {
        if (!name.equals("")) {
            commonData = commonData.addChild(name);
            commonData.setAttribute("p_type", "G");
        }
        Iterator iter = compData.iterator();
        while (iter.hasNext()) {
            String elementName = (String)iter.next();
            AtomData atom = compData.getObject(elementName);
            if (atom.isField()) {
                EAIHPackageConverter.storeField(commonData, elementName, (Field)atom, config);
                continue;
            }
            if (atom.isArray()) {
                EAIHPackageConverter.storeArray(commonData, elementName, (Array)atom, config);
                continue;
            }
            if (!atom.isStruct()) continue;
            CompositeData struct = (CompositeData)atom;
            EAIHPackageConverter.storeStruct(commonData, elementName, struct, config);
        }
    }

    private static void storeArray(CommonData commonData, String name, Array array, IOConfig config) {
        for (int i = 0; i < array.size(); ++i) {
            AtomData arrayItem = array.getObject(i);
            if (arrayItem.isField()) {
                EAIHPackageConverter.storeField(commonData, name, (Field)arrayItem, config);
                continue;
            }
            if (arrayItem.isArray()) {
                EAIHPackageConverter.storeArray(commonData, name, (Array)arrayItem, config);
                continue;
            }
            if (!arrayItem.isStruct()) continue;
            EAIHPackageConverter.storeStruct(commonData, name, (CompositeData)arrayItem, config);
        }
    }

    private static void storeField(CommonData commonData, String name, Field field, IOConfig config) {
        String strValue;
        FieldType fieldType;
        CommonData fieldCommonData = commonData.addChild(name);
        FieldIOConfig fieldIOConfig = EAIHPackageConverter.getFieldIOConfig(name, config);
        if (fieldIOConfig != null) {
            FieldConverter converter = FieldConverterFactory.getInstance().getFieldConverter(fieldIOConfig.getStoreMode());
            CompositeData data = new CompositeData();
            data.addField(fieldIOConfig.getName(), field);
            OutputPacket packet = new OutputPacket();
            converter.pack(packet, data, fieldIOConfig);
            field = data.getField(fieldIOConfig.getName());
        }
        if ((fieldType = field.getFieldType()) == FieldType.FIELD_BYTE) {
            byte value = field.byteValue();
            strValue = Byte.toString(value);
        } else if (fieldType == FieldType.FIELD_DOUBLE) {
            double value = field.doubleValue();
            strValue = Double.toString(value);
        } else if (fieldType == FieldType.FIELD_FLOAT) {
            float value = field.floatValue();
            strValue = Float.toString(value);
        } else if (fieldType == FieldType.FIELD_INT) {
            int value = field.intValue();
            strValue = Integer.toString(value);
        } else if (fieldType == FieldType.FIELD_INT24 || fieldType == FieldType.FIELD_LONG) {
            long value = field.longValue();
            strValue = Long.toString(value);
        } else if (fieldType == FieldType.FIELD_SHORT) {
            short value = field.shortValue();
            strValue = Short.toString(value);
        } else if (fieldType == FieldType.FIELD_IMAGE) {
            byte[] value = field.imageValue();
            strValue = encoder.encode(value);
        } else {
            strValue = field.strValue();
        }
        fieldCommonData.setValue(strValue);
    }

    private static FieldIOConfig getFieldIOConfig(String name, IOConfig config) {
        FieldIOConfig fieldIOConfig = null;
        for (int i = 0; i < config.size(); ++i) {
            Object o = config.getObject(i);
            if (!(o instanceof FieldIOConfig) || !((FieldIOConfig)o).getName().equals(name)) continue;
            fieldIOConfig = (FieldIOConfig)o;
            break;
        }
        return fieldIOConfig;
    }
}

