/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.dispatch.passthrough;

import com.ccb.eai.security.CCBSParameters;
import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.FieldType;
import com.dc.eai.dispatch.Context;
import com.dc.eai.dispatch.passthrough.SpecialProcess;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostSpecialProcess
implements SpecialProcess {
    private static final Log log = LogFactory.getLog((Class)HostSpecialProcess.class);
    private static ThreadLocal channelID = new ThreadLocal();
    private String localNodeID;
    private String serverNodeID;
    private Cipher cip = CipherFactory.getCipher("CCBS");
    private Cipher pinCip = CipherFactory.getCipher("CCBSPIN");

    public Object afterRecvRequest(Object data) {
        byte[] in = (byte[])data;
        FieldConverter converter = FieldConverterFactory.getInstance().getFieldConverter("stdEBCD");
        CompositeData datas = new CompositeData();
        FieldIOConfig fieldconfig = new FieldIOConfig();
        fieldconfig.setName("INM_TELLER_ID");
        fieldconfig.setType(FieldType.FIELD_STRING);
        fieldconfig.setLength(12);
        byte[] buff = new byte[12];
        System.arraycopy(in, 47, buff, 0, fieldconfig.getLength());
        InputPacket packet = new InputPacket(buff);
        converter.unpack(packet, datas, fieldconfig);
        Context.getInstance().addProperty("INM_TELLER_ID", datas.getField("INM_TELLER_ID").strValue());
        fieldconfig.setName("INM_BRANCH_ID");
        fieldconfig.setLength(9);
        buff = new byte[9];
        System.arraycopy(in, 21, buff, 0, fieldconfig.getLength());
        packet = new InputPacket(buff);
        converter.unpack(packet, datas, fieldconfig);
        Context.getInstance().setBranchId(datas.getField("INM_BRANCH_ID").strValue());
        fieldconfig.setName("INM_SVR_TYPE");
        fieldconfig.setLength(3);
        buff = new byte[3];
        System.arraycopy(in, 35, buff, 0, fieldconfig.getLength());
        packet = new InputPacket(buff);
        converter.unpack(packet, datas, fieldconfig);
        String svr = datas.getField("INM_SVR_TYPE").strValue();
        fieldconfig.setName("INM_APP_TX_CODE");
        fieldconfig.setLength(4);
        buff = new byte[4];
        System.arraycopy(in, 38, buff, 0, fieldconfig.getLength());
        packet = new InputPacket(buff);
        converter.unpack(packet, datas, fieldconfig);
        String app = datas.getField("INM_APP_TX_CODE").strValue();
        fieldconfig.setName("INM_SUB_TX_CODE");
        fieldconfig.setLength(2);
        buff = new byte[2];
        System.arraycopy(in, 42, buff, 0, fieldconfig.getLength());
        packet = new InputPacket(buff);
        converter.unpack(packet, datas, fieldconfig);
        String sub = datas.getField("INM_SUB_TX_CODE").strValue();
        String tranId = svr + app + sub;
        Context.getInstance().setTranName(tranId);
        return data;
    }

    public Object beforeSendRequest(Object data) {
        return data;
    }

    public Object afterRecvResponse(Object data) {
        return data;
    }

    public Object beforeSendResponse(Object data) {
        return data;
    }

    private byte[] convertPin(byte[] data, String sourceNodeID, String targetNodeID, boolean in) {
        int[] OPTIONAL_INPUT_HEADER = new int[]{12, 12, 20, 20, 12, 19, 129, 8, 4, 4, 7, 1, 16};
        int[] OPTIONAL_OUTPUT_HEADER = new int[]{19, 8, 41, 41, 41, 41, 41, 41, 41, 41, 129, 7, 9};
        if (in) {
            return this.convertPin(data, sourceNodeID, targetNodeID, OPTIONAL_INPUT_HEADER, 87, 4);
        }
        return this.convertPin(data, sourceNodeID, targetNodeID, OPTIONAL_OUTPUT_HEADER, 54, 2);
    }

    private byte[] convertPin(byte[] data, String sourceNodeID, String targetNodeID, int[] optionalHeader, int mapOffset, int pinCount) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("In convertPin input_data=" + StringUtils.bytesToString(data)));
            log.debug((Object)("sourceNodeID=[" + sourceNodeID + "],targetNodeID=[" + targetNodeID + "],mapOffset=" + mapOffset));
        }
        int bitmap = PackUtils.get_int32(data, mapOffset);
        if (log.isDebugEnabled()) {
            log.debug((Object)("bitmap: " + bitmap));
        }
        if ((bitmap >> 2 & 1) == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"It has Pin!");
            }
            int offset = mapOffset + 4;
            for (int i = 15; i > 2; --i) {
                if ((bitmap >> i & 1) != 1) continue;
                offset += optionalHeader[15 - i];
            }
            int current = offset + 4 * pinCount;
            if ((bitmap >> 1 & 1) == 1) {
                current += 3;
            }
            for (int i = 0; i < pinCount; ++i) {
                int secOffset = PackUtils.get_int16(data, offset) + current;
                short secLength = PackUtils.get_int16(data, offset + 2);
                if (secLength != 0) {
                    byte[] pinData = new byte[secLength];
                    System.arraycopy(data, secOffset, pinData, 0, pinData.length);
                    CCBSParameters parameters = new CCBSParameters(this.localNodeID, sourceNodeID);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pinData:" + pinData));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pinData:" + pinData));
                    }
                    parameters = new CCBSParameters(this.localNodeID, targetNodeID);
                    System.arraycopy(pinData, 0, data, secOffset, pinData.length);
                }
                offset += 4;
            }
        }
        return data;
    }

    public void setServerNodeID(String nodeID) {
        this.serverNodeID = nodeID;
    }
}

