/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.channel;

import com.ccb.eai.channel.Configable;
import com.ccb.eai.dispatch.FillContext;
import com.dc.eai.channel.selfbyte.ChannelSpecialProcess;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

public class EAIHSpecialProcess
implements ChannelSpecialProcess,
Configable {
    private static final Log log = LogFactory.getLog((Class)EAIHSpecialProcess.class);
    private ChannelConfig config;

    public byte[] afterRecvRequest(byte[] buff) {
        return buff;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        this.setLocalNodeId();
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultRequestPackageMode());
        IOConfig ioconfig = this.config.getRequestHeader().getIOConfig();
        converter.unpack(packet, data, ioconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u62a5\u6587\u7ed3\u675f\uff0c\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u4fe1\u606f\uff1a");
        }
        FillContext.fillInContextChannel(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("========== \u62c6\u62a5\u6587\u7ed3\u675f\uff0c\u83b7\u5f97\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data));
        }
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        this.changeNodeId();
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultResponsePackageMode());
        IOConfig headconfig = this.config.getResponseHeader().getIOConfig();
        converter.pack(packet, data, headconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u7ed3\u675f");
        }
    }

    public void beforePackSystemError(OutputPacket packet, CompositeData data) {
        this.changeNodeId();
        this.beforePackError(packet, data);
    }

    public void beforePackError(OutputPacket packet, CompositeData data) {
        this.changeNodeId();
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u9519\u8bef\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultErrorPackageMode());
        IOConfig headconfig = this.config.getError().getIOConfig();
        converter.pack(packet, data, headconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u9519\u8bef\u62a5\u6587\u7ed3\u675f");
        }
    }

    public byte[] beforeSendResponse(byte[] buff) {
        return buff;
    }

    public void setConfig(ChannelConfig config) {
        this.config = config;
        this.setLocalNodeId();
    }

    public String getTranName(InputPacket arg0, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u8bc6\u522b\u5f00\u59cb\uff1a");
        }
        String id = Context.getInstance().getServiceName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8bc6\u522b\u4ea4\u6613\u6210\u529f\uff0c\u4ea4\u6613\u53f7\u4e3a\uff1a" + id));
        }
        NDC.push((String)id);
        return id;
    }

    private synchronized void setLocalNodeId() {
        String local = System.getProperty("algorithm.cssp");
        Context.getInstance().addProperty("local_node_id", local);
    }

    private synchronized void changeNodeId() {
        String local = System.getProperty("algorithm.cssp");
        Context.getInstance().addProperty("local_node_id", local);
        String remote = (String)Context.getInstance().getProperty("temp_node_id");
        String temp = (String)Context.getInstance().getProperty("remote_node_id");
        Context.getInstance().addProperty("temp_node_id", temp);
        Context.getInstance().addProperty("remote_node_id", remote);
    }

    public void beforeMapIn(CompositeData data) {
    }

    public void beforeMapOut(CompositeData data) {
    }
}

