/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.channel;

import com.ccb.eai.channel.Configable;
import com.ccb.eai.security.CCBSParameters;
import com.dc.eai.channel.selfbyte.ChannelSpecialProcess;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

public class DrcdSpecialProcess
implements ChannelSpecialProcess,
Configable {
    private static final Log log = LogFactory.getLog((Class)DrcdSpecialProcess.class);
    private ChannelConfig config;
    private CCBSParameters parameters;
    private Cipher cip;

    private void init() {
        this.cip = CipherFactory.getCipher("CCBS");
    }

    public byte[] afterRecvRequest(byte[] buff) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62a5\u6587\u89e3\u5bc6\u5f00\u59cb\uff1a");
        }
        String local = System.getProperty("algorithm.dcc");
        byte[] temp = new byte[10];
        System.arraycopy(buff, 10, temp, 0, 10);
        String remote = new String(temp);
        Context.getInstance().addProperty("remote_node_id", remote);
        this.parameters = new CCBSParameters(local, remote);
        byte[] dataBuff = new byte[buff.length - 20];
        System.arraycopy(buff, 20, dataBuff, 0, dataBuff.length);
        byte[] after = this.cip.decrypt(dataBuff, this.parameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u89e3\u5bc6\u7ed3\u675f\u3002\u89e3\u5bc6\u540e\u7684\u62a5\u6587\u4e3a\uff1a\n" + after));
        }
        return after;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultRequestPackageMode());
        IOConfig ioconfig = this.config.getRequestHeader().getIOConfig();
        converter.unpack(packet, data, ioconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("========== \u62c6\u62a5\u6587\u7ed3\u675f\uff0c\u83b7\u5f97\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data));
        }
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultResponsePackageMode());
        IOConfig pinconfig = this.config.getResponseHeader().getIOConfig();
        converter.pack(packet, data, pinconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u62a5\u6587\u7ed3\u675f");
        }
    }

    public void beforePackSystemError(OutputPacket packet, CompositeData data) {
        this.beforePackError(packet, data);
    }

    public void beforePackError(OutputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u9519\u8bef\u62a5\u6587\u5f00\u59cb\uff1a");
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(this.config.getDefaultErrorPackageMode());
        IOConfig ioconfig = this.config.getError().getIOConfig();
        converter.pack(packet, data, ioconfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u9519\u8bef\u62a5\u6587\u7ed3\u675f");
        }
    }

    public byte[] beforeSendResponse(byte[] buff) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7edf\u4e00\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u5f00\u59cb\u52a0\u5bc6\uff1a");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid :" + this.parameters.getLocalNodeID()));
            log.debug((Object)("remote nodeid :" + this.parameters.getRemoteNodeID()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u5f00\u59cb,\u52a0\u5bc6\u524d\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(buff)));
        }
        byte[] out = this.cip.encrypt(buff, this.parameters);
        byte[] result = new byte[out.length + 10];
        byte[] temp = this.parameters.getLocalNodeID().getBytes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid\uff1a" + StringUtils.bytesToString(temp)));
        }
        System.arraycopy(temp, 0, result, 0, temp.length);
        System.arraycopy(out, 0, result, 10, out.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(result)));
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u957f\u5ea6[length]=\uff1a" + result.length));
        }
        return result;
    }

    public void setConfig(ChannelConfig config) {
        this.config = config;
        this.init();
    }

    public String getTranName(InputPacket arg0, CompositeData data) {
        String type;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u8bc6\u522b\u5f00\u59cb\uff1a");
        }
        String first = (type = data.getField("ISO_MERTYPE").strValue()).equals("6011") ? "11" : (type.equals("6010") ? "10" : (type.equals("6012") ? "12" : "13"));
        String procode = data.getField("ISO_PROCODE").strValue().substring(0, 2);
        String mti = data.getField("ISO_MTI").strValue();
        String id = first + procode + mti;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8bc6\u522b\u4ea4\u6613\u6210\u529f\uff0c\u4ea4\u6613\u53f7\u4e3a\uff1a" + id));
        }
        NDC.push((String)id);
        return id;
    }

    public void beforeMapIn(CompositeData data) {
    }

    public void beforeMapOut(CompositeData data) {
    }
}

