/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.channel;

import com.ccb.eai.channel.Configable;
import com.ccb.eai.security.CCBSParameters;
import com.dc.eai.channel.traditional.ChannelSpecialProcess;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.config.PackageConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.security.Cipher;
import com.dc.security.CipherFactory;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

public class CounterSpecialProcess
implements ChannelSpecialProcess,
Configable {
    private static final Log log = LogFactory.getLog((Class)CounterSpecialProcess.class);
    private ChannelConfig config;
    private CCBSParameters parameters;
    private Cipher cip;

    private void init() {
        this.cip = CipherFactory.getCipher("CCBS");
    }

    public void beforeMapOut(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u51fa\u62a5\u6587\u5934\u6620\u5c04\u5f00\u59cb\uff1a");
        }
        if (this.config.getResponseHeadMapper() != null) {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getResponseHeadMapper());
            mapper.map(data, data);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u51fa\u62a5\u6587\u5934\u65e0\u6620\u5c04");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u51fa\u62a5\u6587\u5934\u6620\u5c04\u7ed3\u675f");
        }
    }

    public void beforeMapIn(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u5165\u62a5\u6587\u5934\u6620\u5c04\u5f00\u59cb\uff1a");
        }
        if (this.config.getRequestHeadMapper() != null) {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getRequestHeadMapper());
            mapper.map(data, data);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u51fa\u62a5\u6587\u5934\u65e0\u6620\u5c04");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u8f93\u51fa\u62a5\u6587\u5934\u6620\u5c04\u7ed3\u675f");
        }
    }

    public byte[] afterRecvRequest(byte[] buff) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u67dc\u9762\u62a5\u6587\u89e3\u5bc6\u5f00\u59cb\uff1a");
        }
        String local = System.getProperty("algorithm.dcc");
        byte[] temp = new byte[10];
        System.arraycopy(buff, 0, temp, 0, 10);
        String remote = new String(temp);
        this.parameters = new CCBSParameters(local, remote);
        byte[] dataBuff = new byte[buff.length - 10];
        System.arraycopy(buff, 10, dataBuff, 0, dataBuff.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u89e3\u5bc6\u524d\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(dataBuff)));
        }
        byte[] after = this.cip.decrypt(dataBuff, this.parameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u67dc\u9762\u62a5\u6587\u89e3\u5bc6\u7ed3\u675f\u3002\u89e3\u5bc6\u540e\u7684\u62a5\u6587\u4e3a\uff1a\n" + StringUtils.bytesToString(after)));
        }
        return after;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        PackageConfig packconfig;
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u62c6\u67dc\u9762\u62a5\u6587\u5934\u5f00\u59cb\uff1a");
        }
        if ((packconfig = this.config.getRequestHeader()) != null) {
            PackageConverter converter;
            IOConfig headconfig = packconfig.getIOConfig();
            String mode = packconfig.getPackageMode();
            if (mode == null || mode == "") {
                log.error((Object)"\u67dc\u9762\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u5934\u7684\u5305\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            }
            if ((converter = PackageModeFactory.getFactory().getPackageMode(mode)) == null) {
                log.error((Object)"\u67dc\u9762\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u5934\u7684\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01");
            }
            converter.unpack(packet, data, headconfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("========== \u62c6\u67dc\u9762\u62a5\u6587\u5934\u7ed3\u675f\uff0c\u83b7\u5f97\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data));
        }
    }

    public String getTranName(InputPacket packet, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u8bc6\u522b\u5f00\u59cb\uff1a");
        }
        String svr = data.getField("INM_SVR_TYPE").strValue();
        String app = data.getField("INM_APP_TX_CODE").strValue();
        String sub = data.getField("INM_SUB_TX_CODE").strValue();
        String tranId = svr + app + sub;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8bc6\u522b\u4ea4\u6613\u6210\u529f\uff0c\u4ea4\u6613\u53f7\u4e3a\uff1a" + tranId));
        }
        NDC.push((String)tranId);
        return tranId;
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        PackageConfig packconfig;
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u67dc\u9762\u62a5\u6587\u5934\u5f00\u59cb\uff1a");
        }
        if ((packconfig = this.config.getResponseHeader()) != null) {
            PackageConverter converter;
            IOConfig headconfig = packconfig.getIOConfig();
            String mode = packconfig.getPackageMode();
            if (mode == null || mode == "") {
                log.error((Object)"\u67dc\u9762\u4ea4\u6613\u54cd\u5e94\u62a5\u6587\u5934\u7684\u5305\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            }
            if ((converter = PackageModeFactory.getFactory().getPackageMode(mode)) == null) {
                log.error((Object)"\u67dc\u9762\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u5934\u7684\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01");
            }
            converter.pack(packet, data, headconfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"========== \u7ec4\u67dc\u9762\u62a5\u6587\u5934\u7ed3\u675f");
        }
    }

    public void beforePackError(OutputPacket packet, CompositeData data) {
        this.beforePack(packet, data);
    }

    public void beforePackSystemError(OutputPacket packet, CompositeData data) {
        this.beforePack(packet, data);
    }

    public byte[] beforeSendResponse(byte[] buff) {
        PackUtils.put_int16(buff, 8, buff.length - 8);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5bf9\u67dc\u9762\u8fd4\u56de\u62a5\u6587\u5f00\u59cb\u52a0\u5bc6\uff1a");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid :" + this.parameters.getLocalNodeID()));
            log.debug((Object)("remote nodeid :" + this.parameters.getRemoteNodeID()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u5f00\u59cb,\u52a0\u5bc6\u524d\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(buff)));
        }
        byte[] out = this.cip.encrypt(buff, this.parameters);
        byte[] result = new byte[out.length + 10];
        byte[] temp = this.parameters.getLocalNodeID().getBytes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("local nodeid\uff1a" + StringUtils.bytesToString(temp)));
        }
        System.arraycopy(temp, 0, result, 0, temp.length);
        System.arraycopy(out, 0, result, 10, out.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString(result)));
            log.debug((Object)("\u62a5\u6587\u52a0\u5bc6\u7ed3\u675f,\u52a0\u5bc6\u540e\u7684\u62a5\u6587\u957f\u5ea6[length]=\uff1a" + result.length));
        }
        return result;
    }

    public void setConfig(ChannelConfig config) {
        this.config = config;
        this.init();
    }
}

