/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.tcp;

import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.dispatch.Dispatch;
import com.dc.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Handler {
    private static final Log log = LogFactory.getLog((Class)Handler.class);
    private Socket client;
    private String dispatcher;
    private int mode;
    private static final int SHORT_CONNECTION = 0;
    private static final int LONG_CONNECTION = 1;
    private int maxbytes;
    private byte[] tmp = new byte[20];

    public Handler(Socket connection, int mode, int maxbytes, String disp) {
        this.client = connection;
        this.mode = mode;
        this.maxbytes = maxbytes;
        this.dispatcher = disp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
        }
        try {
            byte[] resp;
            int read;
            InputStream is = this.client.getInputStream();
            OutputStream os = this.client.getOutputStream();
            int len = 0;
            byte[] buff_len = new byte[8];
            is.read(buff_len);
            len = Integer.parseInt(new String(buff_len));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6d88\u606f\u957f\u5ea6\u4e3a[" + len + "]"));
            }
            byte[] buff = new byte[len];
            for (int remained = len; remained != 0; remained -= read) {
                read = is.read(buff, len - remained, remained);
                if (read != -1 || remained == 0) continue;
                throw new IllegalStateException("\u6d88\u606f\u957f\u5ea6\u5c0f\u4e8ebuff[]\u524d\u516b\u4e2a\u5b57\u8282\u4e2d\u58f0\u660e\u7684\u957f\u5ea6");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4e0d\u5e26\u957f\u5ea6\u7684\u8bf7\u6c42\u6d88\u606f\u5185\u5bb9:" + StringUtils.bytesToString(buff)));
            }
            if (this.mode == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u5904\u7406\u77ed\u8fde\u63a5\u5de5\u4f5c\u8bf7\u6c42");
                }
                byte[] out = this.doService(buff);
                resp = this.doHead(out);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u54cd\u5e94\u7f13\u51b2\u533a\u5185\u5bb9\u4e3a:" + StringUtils.bytesToString(resp)));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u77ed\u8fde\u63a5\u5de5\u4f5c\u8bf7\u6c42\u5904\u7406\u5b8c\u6bd5");
                }
            } else if (this.mode == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u5904\u7406\u957f\u8fde\u63a5\u5de5\u4f5c\u8bf7\u6c42");
                }
                byte[] out = this.doService(buff);
                resp = this.doHead(out);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u54cd\u5e94\u7f13\u51b2\u533a\u5185\u5bb9\u4e3a:" + StringUtils.bytesToString(resp)));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u957f\u8fde\u63a5\u5de5\u4f5c\u8bf7\u6c42\u5904\u7406\u5b8c\u6bd5");
                }
            } else {
                throw new Exception("\u6a21\u5f0f\u9519\u8bef");
            }
            os.write(resp);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u5f02\u5e38", (Throwable)e);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u670d\u52a1\u8c03\u7528\u9519\u8bef", (Throwable)e);
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException ex) {}
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5de5\u4f5c\u8bf7\u6c42\u5904\u7406\u5b8c\u6bd5");
        }
    }

    private byte[] doService(byte[] in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
        }
        ComponentManager cm = ComponentManagerGetter.getManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6");
        }
        Dispatch disp = (Dispatch)cm.getComponent(this.dispatcher);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8c03\u7528\u8c03\u5ea6\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
        }
        byte[] out = (byte[])disp.doDispatch(in);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
        }
        return out;
    }

    private byte[] doHead(byte[] in) {
        int length = in.length + 4;
        byte[] resp = new byte[length + 8];
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5728\u54cd\u5e94\u62a5\u6587\u524d\u52a0\u5165\u957f\u5ea6\u4fe1\u606flength = " + length));
        }
        byte[] len_buff = new Integer(length).toString().getBytes();
        System.arraycopy("00000000".getBytes(), 0, resp, 0, 8);
        System.arraycopy(len_buff, 0, resp, 8 - len_buff.length, len_buff.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5728\u54cd\u5e94\u62a5\u6587\u524d\u52a0\u5165\u72b6\u6001\u78010000!");
        }
        System.arraycopy("0000".getBytes(), 0, resp, 8, 4);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5165\u54cd\u5e94\u62a5\u6587\u6b63\u6587!");
        }
        System.arraycopy(in, 0, resp, 12, in.length);
        return resp;
    }
}

