/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.tcp;

import com.ccb.eai.adapter.tcp.Handler;
import com.ccb.eai.adapter.tcp.WorkPortPool;
import com.dc.eai.adapter.Connector;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrontTCPConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)FrontTCPConnector.class);
    private AdapterConfig config;
    private int listenport = 0;
    private int workportbase = 0;
    private int maxworkports = 0;
    private WorkPortPool workpool;
    private ServerSocket server;
    private Socket client;
    private static final String REQ_WORKPORT = new String("trop1000");

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public FrontTCPConnector(AdapterConfig config) {
        this.setConfig(config);
        this.init();
    }

    private void init() {
        block3: {
            this.listenport = NumberUtils.intValue(this.config.getAttribute("commport"));
            this.workportbase = NumberUtils.intValue(this.config.getAttribute("workportbase"));
            this.maxworkports = NumberUtils.intValue(this.config.getAttribute("maxworkports"));
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u7aef\u53e3\u5217\u8868(" + this.workportbase + "-" + (this.workportbase + this.maxworkports - 1) + ")"));
                }
                this.workpool = new WorkPortPool(this.workportbase, this.maxworkports);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"\u76d1\u542cSocket\u670d\u52a1\u5668\u521d\u59cb\u5316\u51fa\u9519");
            }
        }
    }

    public void run() {
        try {
            this.server = new ServerSocket(this.listenport);
            while (true) {
                this.client = this.server.accept();
                int workport = this.getWorkport(this.client);
                if (workport > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u4e3a\u5ba2\u6237\u7aef\u5206\u914d\u5de5\u4f5c\u7aef\u53e3:" + workport));
                    }
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"\u672a\u80fd\u4e3a\u5ba2\u6237\u7aef\u5206\u914d\u5de5\u4f5c\u7aef\u53e3!");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5728\u5de5\u4f5c\u7aef\u53e3" + workport + "\u4e0a\u542f\u52a8\u5de5\u4f5cSocket\u670d\u52a1\u5668"));
                }
                Thread trd = new Thread((Runnable)new WorkSrv(workport), "WorkSrv-" + workport);
                trd.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5411\u5ba2\u6237\u7aef\u53d1\u9001\u5de5\u4f5c\u7aef\u53e3\u62a5\u6587(" + workport + ")"));
                }
                this.dispatch(this.client, workport);
            }
        }
        catch (IOException e) {
            block11: {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u76d1\u542c\u7aef\u53e3\u5de5\u4f5c\u51fa\u73b0\u5f02\u5e38");
                }
                try {
                    this.server.close();
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) break block11;
                    log.error((Object)"\u76d1\u542c\u7aef\u53e3\u5de5\u4f5c\u51fa\u73b0\u5f02\u5e38\u540e,\u5173\u95ed\u76d1\u542c\u670d\u52a1\u5668\u51fa\u73b0\u5f02\u5e38");
                }
            }
            return;
        }
    }

    private int getWorkport(Socket client) {
        int workport;
        block8: {
            workport = 0;
            try {
                InputStream in = client.getInputStream();
                byte[] recvbuff = new byte[20];
                int length = in.read(recvbuff);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("workport req read:len=" + length + " content:" + StringUtils.bytesToString(recvbuff)));
                }
                byte[] recv = new byte[length - 8];
                System.arraycopy(recvbuff, 8, recv, 0, length - 8);
                String req = new String(recv);
                if (req != null && req.equals(REQ_WORKPORT)) {
                    workport = this.workpool.get();
                    if (workport <= 0 && log.isWarnEnabled()) {
                        log.warn((Object)("\u672a\u80fd\u4e3a" + client.getInetAddress() + "\u5206\u914d\u5de5\u4f5c\u7aef\u53e3"));
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("\u6765\u81ea" + client.getInetAddress() + "\u65e0\u6548\u7684\u5de5\u4f5c\u7aef\u53e3\u8bf7\u6c42"));
                    if (req != null) {
                        log.warn((Object)("\u8bf7\u6c42\u5185\u5bb9\u4e3a:" + req));
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"\u76d1\u542c\u7aef\u53e3\u4e0a\uff0c\u5224\u65ad\u5ba2\u6237\u7aef\u662f\u5426\u5728\u8bf7\u6c42\u5de5\u4f5c\u7aef\u53e3\u65f6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
            }
        }
        return workport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Socket client, int workport) {
        byte[] resp = new byte[24];
        for (int i = 0; i < 12; ++i) {
            resp[i] = 48;
        }
        resp[6] = 49;
        resp[7] = 54;
        System.arraycopy(new String("trop1000").getBytes(), 0, resp, 12, 8);
        PackUtils.put_int32(resp, 20, workport);
        try {
            OutputStream os = client.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5411\u5ba2\u6237\u7aef\u5199\u5de5\u4f5c\u7aef\u53e3\u54cd\u5e94\u62a5\u6587!");
            }
            os.write(resp);
            os.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5411\u5ba2\u6237\u7aef\u5199\u5de5\u4f5c\u7aef\u53e3\u54cd\u5e94\u62a5\u6587\u5b8c\u6bd5!");
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5411\u5ba2\u6237\u7aef\u53d1\u9001\u5de5\u4f5c\u7aef\u53e3\u53f7\u65f6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
            }
        }
    }

    class WorkSrv
    implements Runnable {
        private int workport;
        private ServerSocket worksrv;
        private Socket workclient;
        private int mode = 0;
        private int maxbytes = 0;
        private String dispName;

        private WorkSrv(int port) {
            this.workport = port;
            this.mode = NumberUtils.intValue(FrontTCPConnector.this.config.getAttribute("mode"));
            this.maxbytes = NumberUtils.intValue(FrontTCPConnector.this.config.getAttribute("maxbytes"));
            this.dispName = FrontTCPConnector.this.config.getAttribute("dispName");
            try {
                this.worksrv = new ServerSocket(this.workport);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u670d\u52a1\u5668\u5de5\u4f5c\u7aef\u53e3" + this.workport + "\u5f00\u59cb\u8fd0\u884c!"));
                }
                this.workclient = this.worksrv.accept();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5411\u670d\u52a1\u5668\u5de5\u4f5c\u7aef\u53e3\u53d1\u9001\u8bf7\u6c42\u7684\u5ba2\u6237\u7aefIP\u5730\u5740\u4e3a:" + this.workclient.getRemoteSocketAddress()));
                }
                Handler hanndler = new Handler(this.workclient, this.mode, this.maxbytes, this.dispName);
                hanndler.handle();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                FrontTCPConnector.this.workpool.put(this.workport);
                try {
                    this.worksrv.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

