/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.tcp;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterInitException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.adapter.tcp.TCPException;
import com.dc.eai.adapter.tcp.TCPSocket;
import com.dc.eai.component.LifeCycle;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrontTCPAdapter
implements Adapter,
LifeCycle {
    private static final Log log = LogFactory.getLog((Class)FrontTCPAdapter.class);
    private AdapterConfig config;
    private TCPSocket tcpsock;
    private int mode = 0;
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int maxbytes = 0;
    private static final int SHORT_CONNECTION = 0;
    private static final int LONG_CONNECTION = 1;
    private static final String MODE = "mode";
    private static final String ADDRESS = "address";
    private static final String COMMPORT = "commport";
    private static final String TIMEOUT = "timeout";
    private static final String MAXBYTES = "maxbytes";
    private int workport = 0;
    private static final String REQ_WORKPORT = new String("trop1000");

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public FrontTCPAdapter(AdapterConfig config) {
        this.config = config;
    }

    private void init() {
        this.mode = NumberUtils.intValue(this.config.getAttribute(MODE));
        this.address = this.config.getAttribute(ADDRESS);
        this.commport = NumberUtils.intValue(this.config.getAttribute(COMMPORT));
        this.timeout = NumberUtils.intValue(this.config.getAttribute(TIMEOUT));
        this.maxbytes = NumberUtils.intValue(this.config.getAttribute(MAXBYTES));
        this.tcpsock = new TCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
    }

    private int getWorkport() {
        int workport = 0;
        try {
            this.tcpsock.connect();
            this.writepacket(this.tcpsock, REQ_WORKPORT.getBytes());
            byte[] buff = this.readpacket(this.tcpsock);
            if (buff.length < 12) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u53d6\u5de5\u4f5c\u7aef\u53e3\uff0c\u8fd4\u56de\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e!");
                }
                throw new AdapterInitException(new TCPException("\u83b7\u53d6\u5de5\u4f5c\u7aef\u53e3\u5931\u8d25!"));
            }
            workport = PackUtils.get_int32(buff, 8);
            if (workport <= 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u5de5\u4f5c\u7aef\u53e3\u53f7\u4e0d\u6b63\u786e");
                }
                throw new AdapterInitException(new TCPException("Cannot not get work port"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u83b7\u5f97\u7684\u5de5\u4f5c\u7aef\u53e3\u662f:" + workport));
            }
            this.tcpsock.close();
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"get work port error", (Throwable)e);
            }
            throw new AdapterInitException(e);
        }
        return workport;
    }

    public void start() {
        block6: {
            this.init();
            if (this.mode == 1) {
                try {
                    this.workport = this.getWorkport();
                    if (this.workport != 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u83b7\u5f97\u7684\u5de5\u4f5c\u7aef\u53e3\u662f:" + this.workport));
                        }
                    } else {
                        throw new AdapterInitException(new TCPException("\u83b7\u53d6\u5de5\u4f5c\u7aef\u53e3\u5931\u8d25"));
                    }
                    this.tcpsock = new TCPSocket(this.address, this.workport, this.timeout, this.maxbytes);
                    this.tcpsock.connect();
                }
                catch (TCPException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Cannot establish socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
            }
        }
    }

    public void stop() {
        block3: {
            if (this.mode == 1) {
                try {
                    this.tcpsock.close();
                }
                catch (TCPException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Cannot destroy socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doComm(Object request) {
        byte[] out = null;
        byte[] req = (byte[])request;
        if (this.mode == 0) {
            try {
                this.workport = this.getWorkport();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Business tcp port:" + this.workport));
                }
                if (this.workport == 0) throw new AdapterInitException(new TCPException("\u83b7\u53d6\u5de5\u4f5c\u7aef\u53e3\u5931\u8d25"));
                this.tcpsock = new TCPSocket(this.address, this.workport, this.timeout, this.maxbytes);
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, req);
                out = this.readpacket(this.tcpsock);
                return out;
            }
            catch (TCPException e) {
                if (!log.isErrorEnabled()) return out;
                log.error((Object)"doComm() error", (Throwable)e);
                return out;
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) return out;
                log.error((Object)e);
                return out;
            }
            finally {
                this.tcpsock.close();
            }
        } else {
            if (this.mode != 1) throw new TCPException("mode error");
            try {
                this.writepacket(this.tcpsock, req);
                return this.readpacket(this.tcpsock);
            }
            catch (TCPException e) {
                this.tcpsock.close();
                if (!log.isErrorEnabled()) return out;
                log.error((Object)"doComm() error", (Throwable)e);
            }
        }
        return out;
    }

    private byte[] readpacket(TCPSocket tcpsock) throws AdapterReceiveDataException {
        byte[] out = null;
        byte[] buff = null;
        int buff_length = 0;
        byte[] lbuff = new byte[8];
        byte[] stat = new byte[4];
        try {
            if (tcpsock.recv(lbuff) <= 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8bfb\u6570\u636e\u957f\u5ea6\u5931\u8d25");
                }
                Exception e = new Exception("\u8bfb\u6570\u636e\u957f\u5ea6\u5931\u8d25");
                throw new AdapterReceiveDataException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bfb\u516b\u4e2a\u5b57\u8282\u7684\u6570\u636e\u957f\u5ea6\u57df:" + StringUtils.bytesToString(lbuff)));
            }
            buff_length = Integer.parseInt(new String(lbuff));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a:" + buff_length));
            }
            buff = new byte[buff_length];
            out = new byte[buff_length - 4];
            if (tcpsock.recv(buff) <= 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8bfb\u6570\u636e\u5931\u8d25");
                }
                Exception e = new Exception("\u8bfb\u6570\u636e\u5931\u8d25");
                throw new AdapterReceiveDataException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bfb\u5230\u7684\u6570\u636e\u5185\u5bb9\u4e3a:" + StringUtils.bytesToString(buff)));
            }
            System.arraycopy(buff, 0, stat, 0, 4);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bfb\u5230\u7684\u6570\u636e\u5185\u5bb9\u4e2d\u72b6\u6001\u7801\u4e3a:" + new String(stat)));
            }
            if (!new String(stat).equals("0000")) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("\u8bfb\u6570\u636e\u51fa\u9519,\u9519\u8bef\u72b6\u6001\u7801\u4e3a" + new String(stat)));
                }
                Exception e = new String(stat).equals("ffff") ? new Exception("FNT00007") : (new String(stat).equals("0fff") ? new Exception("FNT00008") : new Exception("FNT00009"));
                throw new AdapterReceiveDataException(e);
            }
            System.arraycopy(buff, 4, out, 0, buff_length - 4);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bfb\u5230\u7684\u6570\u636e\u5185\u5bb9\u4e2d\u62a5\u6587\u6b63\u6587\u4e3a:" + StringUtils.bytesToString(out)));
            }
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bfb\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterReceiveDataException(e);
        }
        return out;
    }

    private void writepacket(TCPSocket tcpsock, byte[] buff) throws AdapterSendDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e3a:\n" + StringUtils.bytesToString(buff) + "\n" + "\u5728\u5f85\u53d1\u9001\u7684\u6570\u636e\u524d\u52a0\u5165\u516b\u4e2a\u5b57\u8282\u7684\u957f\u5ea6\u57df!"));
        }
        byte[] tosend = new byte[8 + buff.length];
        String tmp = Integer.toString(buff.length);
        char[] lendata = new char[8 - tmp.length()];
        for (int i = 0; i < 8 - tmp.length(); ++i) {
            lendata[i] = 48;
        }
        String head = String.copyValueOf(lendata) + tmp;
        System.arraycopy(head.getBytes(), 0, tosend, 0, 8);
        System.arraycopy(buff, 0, tosend, 8, buff.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u52a0\u5165\u957f\u5ea6\u57df\u4e4b\u540e\u7684\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e3a:\n" + StringUtils.bytesToString(tosend)));
        }
        try {
            if (tcpsock.send(tosend) <= 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u5199\u6570\u636e\u51fa\u9519");
                }
                Exception ex = new Exception("\u5199\u6570\u636e\u51fa\u9519");
                throw new AdapterSendDataException(ex);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5199\u6570\u636e\u6210\u529f");
            }
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterSendDataException(e);
        }
    }
}

