/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.tcp;

import com.ccb.eai.adapter.tcp.EaibHandler;
import com.dc.eai.adapter.Connector;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import com.dc.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EaibTCPConnector
implements Connector {
    public static final int DEFAULT_PORT = 7008;
    private static final Log log = LogFactory.getLog((Class)EaibTCPConnector.class);
    private AdapterConfig config;
    private Map parsers = new HashMap();
    private int port = 7008;
    private ServerSocket server;

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    public EaibTCPConnector(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        block3: {
            String port_s = config.getAttribute("commport");
            if (port_s != null) {
                this.port = NumberUtils.intValue(config.getAttribute("commport"));
            }
            String attr_name = "DefaultHandler";
            String hname = config.getAttribute(attr_name);
            try {
                this.parsers.put(attr_name, Class.forName(hname).newInstance());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"\u5904\u7406\u53e5\u67c4\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadConfig(this.config);
        try {
            this.server = new ServerSocket(this.port);
            while (!Thread.interrupted()) {
                try {
                    Socket client = this.server.accept();
                    if (client == null) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)"New Socket Client comming in");
                    }
                    Thread trd = new Thread(new Handler(client));
                    trd.start();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Some unexpectable exception occured");
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.server.close();
            }
            catch (IOException e) {}
        }
    }

    Map getParsers() {
        return this.parsers;
    }

    class Handler
    implements Runnable {
        private Socket connection;

        Handler(Socket connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int read;
                InputStream is = this.connection.getInputStream();
                OutputStream os = this.connection.getOutputStream();
                byte[] buff_len = new byte[4];
                is.read(buff_len);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u957f\u5ea6\u57df\u56db\u4e2a\u5b57\u8282\u4e3a[" + StringUtils.bytesToString(buff_len) + "]"));
                }
                int[] lens = new int[4];
                for (int i = 0; i < buff_len.length; ++i) {
                    lens[i] = buff_len[i] & 0xFF;
                }
                int len = (lens[0] << 24) + (lens[1] << 16) + (lens[2] << 8) + lens[3];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u6d88\u606f\u957f\u5ea6\u4e3a[" + len + "]"));
                }
                byte[] buff = new byte[len];
                for (int remained = len; remained != 0; remained -= read) {
                    read = is.read(buff, len - remained, remained);
                    if (read != -1 || remained == 0) continue;
                    throw new IllegalStateException("\u6d88\u606f\u957f\u5ea6\u5c0f\u4e8ebuff[]\u524d\u56db\u4e2a\u5b57\u8282\u4e2d\u58f0\u660e\u7684\u957f\u5ea6");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Whole Message Received");
                }
                String parserVersion = new String(buff, 0, 2);
                EaibHandler h = (EaibHandler)EaibTCPConnector.this.parsers.get(parserVersion);
                if (h == null) {
                    h = (EaibHandler)EaibTCPConnector.this.parsers.get("DefaultHandler");
                }
                byte[] buff_send = h.handle(buff, 2, EaibTCPConnector.this.config);
                buff_send = this.addLength(buff_send);
                os.write(buff_send);
                os.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("response[" + StringUtils.bytesToString(buff_send) + "]"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Whole Message Responsed");
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Tcp Service failed", (Throwable)e);
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private byte[] addLength(byte[] in) {
            int length = in.length;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5411\u8f93\u5165\u5b57\u8282\u6570\u7ec4\u5934\u90e8\u52a0\u56db\u4e2a\u5b57\u8282\u7684\u957f\u5ea6\u4fe1\u606f\uff0c\u957f\u5ea6\u503c\u4e3a:" + length));
            }
            byte[] out = new byte[length + 4];
            out[0] = (byte)((0xFF000000 & length) >> 24);
            out[1] = (byte)((0xFF0000 & length) >> 16);
            out[2] = (byte)((0xFF00 & length) >> 8);
            out[3] = (byte)(0xFF & length);
            System.arraycopy(in, 0, out, 4, length);
            return out;
        }
    }
}

