/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.tcp;

import com.ccb.eai.adapter.SysSerialIDGen;
import com.ccb.eai.adapter.file.FileTransferGetter;
import com.ccb.eai.adapter.tcp.EaibHandler;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.dispatch.Context;
import com.dc.eai.dispatch.Dispatch;
import csspui.CSSPCipher;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EaibHandlerImpl0
implements EaibHandler {
    private static final Log log = LogFactory.getLog((Class)EaibHandlerImpl0.class);
    static final String VERSION = "Version";
    static final String SYSTEM_HEAD = "SystemHead";
    static final String MAC_VALUE = "MAC";
    static final String TRAN_PACKET = "Transaction ";
    static final String EMBR_PACKET = "Emb_body";
    static final String ATCH_PACKET = "Attachment ";
    private boolean CSSPCipherEnable = true;
    private static final SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.mss");
    private boolean dispatchEnable = true;

    EaibHandlerImpl0() {
    }

    public void disableCSSPCipher() {
        this.CSSPCipherEnable = false;
    }

    public void disableDispatch() {
        this.dispatchEnable = false;
    }

    public byte[] handle(byte[] wholeMsg, int offset, AdapterConfig config) {
        boolean hasAtch;
        boolean hasEmbr;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.getClass().getName() + " start handle version[" + new String(wholeMsg, 0, 2) + "] communication packet"));
        }
        Properties sys_h = EaibHandlerImpl0.unpack(wholeMsg, 2);
        String clnode = EaibHandlerImpl0.strValue(sys_h, "sys_node_id", "node id not found");
        Context ctx = Context.getInstance();
        ctx.setSenderNodeId(clnode);
        int mac_len = EaibHandlerImpl0.intValue(sys_h, "sys_mac_value_length", 0);
        int tran_len = EaibHandlerImpl0.intValue(sys_h, "sys_msg_length", 0);
        int embr_len = 0;
        boolean bl = hasEmbr = EaibHandlerImpl0.intValue(sys_h, "sys_have_embedded_msg", 0) == 1;
        if (hasEmbr) {
            embr_len = EaibHandlerImpl0.intValue(sys_h, "sys_embedded_msg_length", 0);
        }
        int atch_len = 0;
        boolean bl2 = hasAtch = EaibHandlerImpl0.intValue(sys_h, "sys_have_attachment", 0) == 1;
        if (hasAtch) {
            atch_len = EaibHandlerImpl0.intValue(sys_h, "sys_attachment_msg_length", 0);
        }
        boolean secEnable = EaibHandlerImpl0.intValue(sys_h, "sys_is_encrypted", 0) == 1;
        boolean prsEnable = EaibHandlerImpl0.intValue(sys_h, "sys_is_compressed", 0) == 1;
        String prsName = EaibHandlerImpl0.strValue(sys_h, "sys_compress_type", null);
        String secName = EaibHandlerImpl0.strValue(sys_h, "sys_encrypt_type", null);
        String macName = EaibHandlerImpl0.strValue(sys_h, "sys_mac_type", null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"system head parse end");
        }
        int mac_s = wholeMsg.length - atch_len - embr_len - tran_len - mac_len;
        byte[] mac_v = new byte[mac_len];
        System.arraycopy(wholeMsg, mac_s, mac_v, 0, mac_len);
        int tran_s = wholeMsg.length - atch_len - embr_len - tran_len;
        byte[] tran_v = new byte[tran_len];
        System.arraycopy(wholeMsg, tran_s, tran_v, 0, tran_len);
        if (log.isDebugEnabled()) {
            log.debug((Object)"encrypted tran and mac value retrived");
        }
        byte[] tran_plain_v = this.unmushall(tran_v, mac_v, clnode, macName, secName, prsName, config);
        byte[] embr_v = null;
        if (hasEmbr) {
            int embr_s = wholeMsg.length - atch_len - embr_len;
            Properties embr_h = EaibHandlerImpl0.unpack(wholeMsg, embr_s);
            Enumeration<Object> e = embr_h.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                ctx.addProperty((String)key, (String)embr_h.get(key));
            }
            int embr_inner_len = EaibHandlerImpl0.intValue(embr_h, "emb_msg_length", 0);
            embr_s = embr_s + embr_len - embr_inner_len;
            embr_v = new byte[embr_inner_len];
            System.arraycopy(wholeMsg, embr_s, embr_v, 0, embr_inner_len);
            ctx.addProperty("embedded_msg", embr_v);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"embeded message in request disposed");
        }
        boolean atch_in_bytes = false;
        byte[] atch_v = null;
        if (hasAtch) {
            Properties atch_h;
            block36: {
                int atch_s = wholeMsg.length - atch_len;
                atch_h = EaibHandlerImpl0.unpack(wholeMsg, atch_s);
                atch_in_bytes = Integer.parseInt(atch_h.getProperty("attachment_has_content")) == 1;
                int atch_inner_len = EaibHandlerImpl0.intValue(atch_h, "attachment_length", 0);
                if (atch_in_bytes) {
                    atch_v = new byte[atch_inner_len];
                    atch_s = atch_s + atch_len - atch_inner_len;
                    System.arraycopy(wholeMsg, atch_s, atch_v, 0, atch_inner_len);
                }
                try {
                    FileTransferGetter.getFileTransfer().getFile(atch_h, atch_v);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block36;
                    log.error((Object)"io excpetion", (Throwable)e);
                }
            }
            Enumeration<Object> e = atch_h.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                ctx.addProperty((String)key, (String)atch_h.get(key));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"attachment in request disposed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("tran_v:" + new String(tran_v)));
            if (hasEmbr) {
                log.debug((Object)("embr_v:" + new String(embr_v)));
            }
            if (hasAtch) {
                log.debug((Object)("atch_v:" + new String(atch_v)));
            }
        }
        if (this.dispatchEnable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42");
            }
            ComponentManager cm = ComponentManagerGetter.getManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4ece\u7ec4\u4ef6\u7ba1\u7406\u5668\u4e2d\u53d6\u8c03\u5ea6\u7ec4\u4ef6");
            }
            Dispatch disp = (Dispatch)cm.getComponent(config.getAttribute("dispatcher"));
            tran_plain_v = (byte[])disp.doDispatch(tran_plain_v);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8c03\u7528\u76f8\u5173\u7ec4\u4ef6\u5904\u7406\u5de5\u4f5c\u8bf7\u6c42\u5b8c\u6bd5");
            }
        }
        Properties sys_h_r = new Properties();
        EaibHandlerImpl0.setPropery((String)ctx.getProperty("local_node_id"), sys_h_r, "sys_node_id", "node not found");
        sys_h_r.setProperty("sys_serial_id", SysSerialIDGen.genID());
        sys_h_r.setProperty("sys_occur_time", fmt.format(new Date()));
        sys_h_r.setProperty("sys_is_encrypted", secEnable ? "1" : "0");
        if (secEnable) {
            sys_h_r.setProperty("sys_encrypt_type", secName);
        }
        sys_h_r.setProperty("sys_is_compressed", prsEnable ? "1" : "0");
        if (prsEnable) {
            sys_h_r.setProperty("sys_compress_type", prsName);
        }
        sys_h_r.setProperty("sys_mac_type", macName);
        sys_h_r.setProperty("sys_mac_value_length", "0");
        sys_h_r.setProperty("sys_msg_length", "0");
        EaibHandlerImpl0.setPropery((String)ctx.getProperty("sys_have_embedded_msg"), sys_h_r, "sys_have_embedded_msg", "0");
        sys_h_r.setProperty("sys_embedded_msg_length", "0");
        EaibHandlerImpl0.setPropery((String)ctx.getProperty("sys_have_attachment"), sys_h_r, "sys_have_attachment", "0");
        hasEmbr = EaibHandlerImpl0.intValue(sys_h_r, "sys_have_embedded_msg", 0) == 1;
        hasAtch = EaibHandlerImpl0.intValue(sys_h_r, "sys_have_attachment", 0) == 1;
        sys_h_r.setProperty("sys_attachment_msg_length", "0");
        Properties embr_h_r = new Properties();
        embr_h_r.setProperty("emb_type", (String)ctx.getProperty("emb_type"));
        embr_h_r.setProperty("emb_msg_length", "0");
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_is_encrypted"), embr_h_r, "emb_is_encrypted", "0");
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_encrypt_type"), embr_h_r, "emb_encrypt_type", secName);
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_is_compressed"), embr_h_r, "emb_is_compressed", "0");
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_compress_type"), embr_h_r, "emb_compress_type", prsName);
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_mac_type"), embr_h_r, "emb_mac_type", null);
        EaibHandlerImpl0.setPropery(config.getAttribute("emb_protocol"), embr_h_r, "emb_protocol", null);
        Properties atch_h_r = new Properties();
        if (hasAtch) {
            atch_h_r.setProperty("attachment_id", (String)ctx.getProperty("attachment_id"));
            atch_h_r.setProperty("attachment_has_content", config.getAttribute("attachment_has_content"));
            atch_in_bytes = EaibHandlerImpl0.intValue(atch_h_r, "attachment_has_content", 0) == 1;
            atch_h_r.setProperty("attachment_process_type", (String)ctx.getProperty("attachment_process_type"));
            atch_h_r.setProperty("attachment_format", (String)ctx.getProperty("attachment_format"));
            atch_h_r.setProperty("attachment_length", "0");
            atch_h_r.setProperty("attachment_is_encrypted", "xxx");
            EaibHandlerImpl0.setPropery(config.getAttribute("attachment_encrypt_type"), atch_h_r, "attachment_encrypt_type", secName);
            EaibHandlerImpl0.setPropery(config.getAttribute("attachment_is_compressed"), atch_h_r, "attachment_is_compressed", "0");
            EaibHandlerImpl0.setPropery(prsName, atch_h_r, "attachment_compress_type", null);
            EaibHandlerImpl0.setPropery(config.getAttribute("attachment_mac_type"), atch_h_r, "attachment_mac_type", null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"response head info collected ended");
        }
        tran_v = this.mushall(tran_plain_v, mac_v, clnode, macName, secName, prsName, config);
        tran_len = tran_v.length;
        mac_len = mac_v.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)"response tran, mac prepared");
        }
        embr_v = new byte[]{};
        embr_len = 0;
        if (hasEmbr) {
            embr_v = (byte[])ctx.getProperty("embedded_msg");
            embr_len = embr_v.length;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"response embr prepared");
        }
        atch_v = new byte[]{};
        atch_len = 0;
        if (hasAtch) {
            if (atch_in_bytes) {
                try {
                    atch_v = FileTransferGetter.getFileTransfer().putFile(atch_h_r);
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"io excpetion", (Throwable)e);
                    }
                }
            } else {
                atch_v = new byte[]{};
            }
            atch_h_r.put("attachment_length", Integer.toString(atch_v.length));
            byte[] atch_h_v = EaibHandlerImpl0.packHead(atch_h_r);
            byte[] buf = new byte[atch_h_v.length + atch_v.length];
            System.arraycopy(atch_h_v, 0, buf, 0, atch_h_v.length);
            System.arraycopy(atch_v, 0, buf, atch_h_v.length, atch_v.length);
            atch_v = buf;
            atch_len = atch_v.length;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"response atch prepared");
        }
        sys_h_r.setProperty("sys_mac_value_length", Integer.toString(mac_len));
        sys_h_r.setProperty("sys_msg_length", Integer.toString(tran_len));
        sys_h_r.setProperty("sys_embedded_msg_length", Integer.toString(embr_len));
        sys_h_r.setProperty("sys_attachment_msg_length", Integer.toString(atch_len));
        byte[] sys_h_v = EaibHandlerImpl0.packHead(sys_h_r);
        byte[] wholeMsg_r = new byte[2 + sys_h_v.length + mac_len + tran_len + embr_len + atch_len];
        int start = 0;
        wholeMsg_r[0] = wholeMsg[0];
        wholeMsg_r[1] = wholeMsg[1];
        start = 2;
        System.arraycopy(sys_h_v, 0, wholeMsg_r, start, sys_h_v.length);
        System.arraycopy(mac_v, 0, wholeMsg_r, start += sys_h_v.length, mac_len);
        System.arraycopy(tran_v, 0, wholeMsg_r, start += mac_len, tran_len);
        System.arraycopy(embr_v, 0, wholeMsg_r, start += tran_len, embr_len);
        System.arraycopy(atch_v, 0, wholeMsg_r, start += embr_len, atch_len);
        if (log.isDebugEnabled()) {
            log.debug((Object)"whole reponse message prepared");
        }
        return wholeMsg_r;
    }

    private static Properties unpack(byte[] wholeMsg, int offset) {
        Properties attrs = new Properties();
        ByteArrayInputStream bis = new ByteArrayInputStream(wholeMsg, offset, wholeMsg.length - offset);
        InputStreamReader isr = new InputStreamReader(bis);
        BufferedReader br = new BufferedReader(isr);
        try {
            String attr = "";
            while (!(attr = br.readLine()).equals("")) {
                int index = attr.indexOf(58);
                String name = attr.substring(0, index);
                String value = attr.substring(index + 1);
                attrs.setProperty(name, value);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"System head parse failed", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable e) {}
        }
        return attrs;
    }

    private static byte[] packHead(Properties p) {
        Enumeration<Object> e = p.keys();
        StringBuffer s = new StringBuffer();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            s.append(key).append(':').append(value).append('\n');
        }
        s.append('\n');
        return s.toString().getBytes();
    }

    private static int intValue(Properties p, String key, int defval) {
        if (!p.containsKey(key)) {
            return defval;
        }
        return Integer.parseInt(p.getProperty(key));
    }

    private static boolean boolValue(Properties p, String key, boolean defval) {
        if (!p.containsKey(key)) {
            return defval;
        }
        return Boolean.valueOf(p.getProperty(key));
    }

    private static String strValue(Properties p, String key, String defval) {
        if (!p.containsKey(key)) {
            return defval;
        }
        return p.getProperty(key);
    }

    private static void setPropery(String val, Properties p, String key, String defval) {
        if (val != null) {
            p.put(key, val);
        } else if (defval != null) {
            p.put(key, defval);
        }
    }

    private byte[] mushall(byte[] buf, byte[] mac_v, String clnode, String macName, String secName, String prsName, AdapterConfig config) {
        int keyTag;
        byte[] buf2 = buf;
        if (!this.CSSPCipherEnable) {
            return buf2;
        }
        if (prsName != null) {
            // empty if block
        }
        if (secName != null) {
            keyTag = Integer.parseInt(config.getAttribute(secName));
            buf2 = CSSPCipher.symmEnc((String)clnode, (int)keyTag, (byte[])buf);
        }
        if (macName != null) {
            keyTag = Integer.parseInt(config.getAttribute(macName));
            byte[] _mac_v = CSSPCipher.mac((String)clnode, (int)keyTag, (byte[])buf2);
            System.arraycopy(_mac_v, 0, mac_v, 0, _mac_v.length);
        }
        return buf2;
    }

    private byte[] unmushall(byte[] buf, byte[] mac_v, String clnode, String macName, String secName, String prsName, AdapterConfig config) {
        int keyTag;
        boolean mac_suc;
        byte[] buf2 = buf;
        if (!this.CSSPCipherEnable) {
            return buf2;
        }
        if (macName != null && !(mac_suc = CSSPCipher.macVerify((String)clnode, (int)(keyTag = Integer.parseInt(config.getAttribute(macName))), (byte[])buf, (byte[])mac_v))) {
            throw new IllegalStateException("buffer mac failed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"tran packet mac passed");
        }
        if (secName != null) {
            keyTag = Integer.parseInt(config.getAttribute(secName));
            buf2 = CSSPCipher.symmDec((String)clnode, (int)keyTag, (byte[])buf);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"tran packet decrypt passed");
        }
        if (prsName != null) {
            // empty if block
        }
        return buf2;
    }
}

