/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.eai.adapter.file;

import com.ccb.eai.adapter.file.FILEException;
import com.ccb.eai.adapter.file.FileTranNative;
import com.ccb.eai.adapter.file.FileTransfer;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileTransferImp
implements FileTransfer {
    private static final Log log = LogFactory.getLog((Class)FileTransferImp.class);
    private static AdapterConfig config;
    private static final String FILESVRIP = "filesvrip";
    private static final String FILESVRPORT = "filesvrport";
    private static final String TIMEOUT = "timeout";
    private static final String FILESVCNAME = "filesvcname";
    private static final String FLAG = "flag";
    private static final String FILEDIR = "filedir";
    private String frtFiledir;
    private int port;
    private int timeout = 60;
    private int flag = 0;
    private String pszIp;
    private String pszSvc;
    private String fileName;
    private String fileHasContent;
    private String fileProcessType;
    private String fileFormat;
    private int fileLength;
    private File fileDir;
    private byte[] fileBuf;
    private File putFilename;
    private static FileTransferImp instance;

    public static AdapterConfig getConfig() {
        return config;
    }

    public static void setConfig(AdapterConfig fileconfig) {
        config = fileconfig;
    }

    public static FileTransferImp getInstance() {
        if (instance == null) {
            instance = new FileTransferImp(config);
        }
        return instance;
    }

    private FileTransferImp(AdapterConfig config) {
        this.pszIp = config.getAttribute(FILESVRIP);
        this.port = NumberUtils.intValue(config.getAttribute(FILESVRPORT));
        this.timeout = NumberUtils.intValue(config.getAttribute(TIMEOUT));
        this.pszSvc = config.getAttribute(FILESVCNAME);
        this.flag = NumberUtils.intValue(config.getAttribute(FLAG));
        this.frtFiledir = config.getAttribute(FILEDIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFile(Properties fileHead, byte[] filecontent) throws IOException {
        block16: {
            this.fileBuf = filecontent;
            this.fileName = fileHead.getProperty("attachment_id");
            this.fileProcessType = fileHead.getProperty("attachment_process_type");
            this.fileFormat = fileHead.getProperty("attachment_format");
            this.fileName = this.fileName + "." + this.fileFormat;
            try {
                if (this.fileProcessType.equals("EAIA01")) {
                    if (this.flag == 0) {
                        if (FileTranNative.fileget(this.pszIp, this.fileName, this.port, this.timeout) != 0) {
                            // empty if block
                        }
                        throw new FILEException("\u8c03\u7528\u672c\u5730jni\u65b9\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25!");
                    }
                    if (this.flag == 1) {
                        if (FileTranNative.fileget(this.pszSvc, this.fileName, this.timeout) != 0) {
                            // empty if block
                        }
                        throw new FILEException("\u8c03\u7528\u672c\u5730jni\u65b9\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25!");
                    }
                    throw new FILEException("\u914d\u7f6e\u6587\u4ef6\u9519!");
                }
            }
            catch (FILEException e) {
                if (!log.isErrorEnabled()) break block16;
                log.error((Object)"\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25!", (Throwable)e);
            }
        }
        if (this.frtFiledir == null) {
            this.frtFiledir = System.getProperty("user.home") + "/" + "file";
        }
        this.fileDir = new File(this.frtFiledir);
        if (!this.fileDir.isDirectory() && this.fileDir.exists()) {
            this.fileDir.delete();
            this.fileDir.mkdir();
        }
        File file = new File(this.fileDir, this.fileName);
        file.createNewFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(this.fileBuf);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] putFile(Properties fileHead) throws IOException {
        this.fileName = fileHead.getProperty("attachment_id");
        this.fileProcessType = fileHead.getProperty("attachment_process_type");
        this.fileFormat = fileHead.getProperty("attachment_format");
        this.fileName = this.fileName + "." + this.fileFormat;
        if (this.fileProcessType.equals("EAIA01")) {
            if (this.flag == 0) {
                if (FileTranNative.fileput(this.pszIp, this.fileName, this.port, this.timeout) != 0) {
                    // empty if block
                }
                throw new FILEException("\u8c03\u7528\u672c\u5730jni\u65b9\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25!");
            }
            if (this.flag == 1) {
                if (FileTranNative.fileput(this.pszSvc, this.fileName, this.timeout) != 0) {
                    // empty if block
                }
                throw new FILEException("\u8c03\u7528\u672c\u5730jni\u65b9\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25!");
            }
            throw new FILEException("\u914d\u7f6e\u6587\u4ef6\u9519!");
        }
        if (this.frtFiledir == null) {
            this.frtFiledir = System.getProperty("user.home") + "/" + "file";
        }
        this.fileDir = new File(this.frtFiledir);
        if (!this.fileDir.isDirectory()) {
            throw new IOException("File Directory is not exit:" + this.frtFiledir);
        }
        File file = new File(this.fileDir, this.fileName);
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("File not found: " + file.getName());
        }
        long len = file.length();
        if (len > 32768L) {
            throw new IOException("File is too long!");
        }
        byte[] raw = new byte[(int)len];
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            int r = fin.read(raw);
            if ((long)r != len) {
                throw new IOException("Can't read all, " + r + " != " + len);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return raw;
    }
}

