/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.controller;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.prometheus.utils.PrometheusUtils;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(name={"nacos.prometheus.metrics.enabled"}, havingValue="true")
public class PrometheusController {
    @Autowired
    private InstanceOperatorClientImpl instanceServiceV2;
    private final ServiceManager serviceManager = ServiceManager.getInstance();

    @GetMapping(value={"/prometheus"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<String> metric() throws NacosException {
        ArrayNode arrayNode = JacksonUtils.createEmptyArrayNode();
        HashSet<Instance> targetSet = new HashSet<Instance>();
        Set allNamespaces = this.serviceManager.getAllNamespaces();
        for (String namespace : allNamespaces) {
            Set singletons = this.serviceManager.getSingletons(namespace);
            for (Service service : singletons) {
                List instances = this.instanceServiceV2.listAllInstances(namespace, service.getGroupedServiceName());
                targetSet.addAll(instances);
            }
        }
        PrometheusUtils.assembleArrayNodes(targetSet, arrayNode);
        return ResponseEntity.ok().body((Object)arrayNode.toString());
    }

    @GetMapping(value={"/prometheus/namespaceId/{namespaceId}"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<String> metricNamespace(@PathVariable(value="namespaceId") String namespaceId) throws NacosException {
        ArrayNode arrayNode = this.getServiceArrayNode(namespaceId, s -> true);
        return ResponseEntity.ok().body((Object)arrayNode.toString());
    }

    @GetMapping(value={"/prometheus/namespaceId/{namespaceId}/service/{service}"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<String> metricNamespaceService(@PathVariable(value="namespaceId") String namespaceId, @PathVariable(value="service") String service) throws NacosException {
        ArrayNode arrayNode = this.getServiceArrayNode(namespaceId, s -> s.getName().equals(service));
        return ResponseEntity.ok().body((Object)arrayNode.toString());
    }

    private ArrayNode getServiceArrayNode(String namespaceId, Predicate<Service> serviceFilter) throws NacosException {
        ArrayNode arrayNode = JacksonUtils.createEmptyArrayNode();
        Set allNamespaces = this.serviceManager.getAllNamespaces();
        if (!allNamespaces.contains(namespaceId)) {
            return arrayNode;
        }
        HashSet<Instance> targetSet = new HashSet<Instance>();
        Set singletons = this.serviceManager.getSingletons(namespaceId);
        for (Service existService : singletons) {
            if (!serviceFilter.test(existService)) continue;
            List instances = this.instanceServiceV2.listAllInstances(namespaceId, existService.getGroupedServiceName());
            targetSet.addAll(instances);
        }
        PrometheusUtils.assembleArrayNodes(targetSet, arrayNode);
        return arrayNode;
    }
}

